package com.ldodds.sparql;

import java.awt.EventQueue;
import java.awt.Frame;

import javax.swing.UIManager;

public class Twinkle
{
    public static QueryContext context;
    public static TwinkleFrame ui;
    
    public Twinkle()
    {
        context = new QueryContext();
        new TwinkleFrame("Twinkle");        
    }
    
    public static void main(String[] args)
    {
        try {
            UIManager.setLookAndFeel(
              UIManager.getSystemLookAndFeelClassName());
        } 
        catch (Exception ex) {
            //ignore, use default
        }
        
        Twinkle twinkle = new Twinkle();
        FrameRunner runner = new FrameRunner(Twinkle.ui);
        EventQueue.invokeLater(runner);
    }
    
    static class FrameRunner implements Runnable
    {
        private Frame _frame;
        
        public FrameRunner(Frame frame)
        {
            _frame = frame;
        }
        
        public void run()
        {
            _frame.show();
        }
    }
    
    public static void showStatusBarMessage(String msg)
    {
        Twinkle.ui.getStatusBar().setText(msg);
    }
    
    public static void clearStatusBar()
    {
        Twinkle.ui.getStatusBar().setText("");
    }
}
