package com.ldodds.sparql;

import java.io.OutputStream;
import java.io.PrintWriter;

import com.hp.hpl.jena.util.*;
import com.hp.hpl.jena.query.*;
import com.hp.hpl.jena.query.vocabulary.ResultSetVocab;
import com.hp.hpl.jena.rdf.model.*;

/**
 * @author ccslrd
 */
class SelectQueryRunner extends AbstractQueryRunner
{
    public SelectQueryRunner(OutputStream out)
    {
        super(out);
    }
    
    public void doQuery(QueryContext context, QueryExecution qe)
    {
        ResultSet results = qe.execSelect();

        // Force query to execute - until now it has merely been set up.
        results = ResultSetFactory.rewindableResults(results);

        //TODO not all of these are offered in GUI. Either add them, or remove this code
        
        // The non-display forms / uses a ResultSetFormatter 

        if (context.outputFormat.equals(RunQuery.FMT_NONE))
        {
            ResultSetFormatter fmt = new ResultSetFormatter(results, context.query
                    .getPrefixMap());
            fmt.consume();
            fmt.close();
        }

        if (context.outputFormat.equals(RunQuery.FMT_RS_RDF))
        {
            ResultSetFormatter rsFmt = new ResultSetFormatter(results, context.query
                    .getPrefixMap());
            Model m = rsFmt.toModel();
            RDFWriter rdfw = m.getWriter("TURTLE");
            m.setNsPrefix("rs", ResultSetVocab.getURI());
            rdfw.write(m, _out, null);
            rsFmt.close();
        }

        PrintWriter out = FileUtils.asPrintWriterUTF8(_out);

        if (context.outputFormat.equals(RunQuery.FMT_RS_XML))
        {
            ResultSetFormatter rsFmt = new ResultSetFormatter(results, context.query
                    .getPrefixMap());
            rsFmt.outputAsXML(_out);
            rsFmt.close();
        }

        if (context.outputFormat.equals(RunQuery.FMT_RS_TEXT))
        {
            ResultSetFormatter rsFmt = new ResultSetFormatter(results, context.query
                    .getPrefixMap());
            rsFmt.outputAsText(_out);
        }

        ResultSetTextFormatter fmt = null;

        if (context.outputFormat.equals(RunQuery.FMT_TEXT))
        {
            fmt = new ResultSetTextFormatter(results, context.query.getPrefixMap());
            fmt.printAll(out);
        }

        if (context.outputFormat.equals(RunQuery.FMT_TUPLES))
        {
            fmt = new ResultSetTextFormatter(results);
            fmt.dump(out, true);
        }

        //TODO tidy this up
        if (context.outputFormat.equals("table"))
        {
            JTableResultsSetFormatter tableFormatter = new JTableResultsSetFormatter();
            tableFormatter.display(results);
        }
        if (out != null) out.flush();

        if (fmt != null) fmt.close();

        results.close();

        if (context.query.getQueryBlock().getDataSource() != null)
            context.query.getQueryBlock().getDataSource().close();
        
    }

}
