package com.ldodds.sparql;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;

import com.hp.hpl.jena.query.QueryException;
/**
 * @author ccslrd
 */
public class RunQueryCommand implements ActionListener
{
    public void actionPerformed(ActionEvent e)
    {
        Twinkle.context.query = null;

        //set data url if we have one
        String data = Twinkle.ui.getDataUrlField().getText();        
        Twinkle.context.dataURL = ("".equals(data) ? null : data);
        
        //set baseurl if we have one
        String baseUrl = Twinkle.ui.getBaseUrl().getText();
        Twinkle.context.baseURI = ("".equals(baseUrl) ? null : baseUrl);
        
        //set the query
        Twinkle.context.queryString=Twinkle.ui.getQueryBox().getText();
                
        //then run it
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        RunQuery queryRunner = new RunQuery(out, Twinkle.context);
        Twinkle.showStatusBarMessage("Running Query...");
        
        try
        {
            queryRunner.query();
            Twinkle.ui.getResultsBox().setText(out.toString("UTF-8"));
            Twinkle.showStatusBarMessage("Query successful");
        } catch (QueryException qe)
        {
        	Twinkle.showStatusBarMessage(qe.getMessage());
        } catch (UnsupportedEncodingException ue)
        {
            //will never happen
        }
                
    }

}
