package com.ldodds.sparql;

import java.io.OutputStream;
import java.io.PrintWriter;

import com.hp.hpl.jena.util.*;
import com.hp.hpl.jena.query.*;
import com.hp.hpl.jena.rdf.model.*;

/**
 * @author ccslrd
 */
class DescribeQueryRunner extends AbstractQueryRunner
{
    public DescribeQueryRunner(OutputStream out)
    {
        super(out);
    }
    
    public void doQuery(QueryContext context, QueryExecution qe)
    {
        Model r = qe.execDescribe();
        PrintWriter out = FileUtils.asPrintWriterUTF8(_out);
        
        if (!context.outputFormat.equals(RunQuery.FMT_NONE))
        {
            r.write(out, 
                    (context.outputFormat.equals(RunQuery.FMT_TEXT) ? "N3" : "RDF/XML"), null);
        }
        out.flush();
        out.close();
    }

}
