package com.ldodds.sparql;

import java.io.OutputStream;
import java.io.PrintWriter;

import com.hp.hpl.jena.util.*;
import com.hp.hpl.jena.query.*;

/**
 * @author ccslrd
 */
class AskQueryRunner extends AbstractQueryRunner
{
    public AskQueryRunner(OutputStream out)
    {
        super(out);
    }
    
    public void doQuery(QueryContext context, QueryExecution qe)
    {
        boolean b = qe.execAsk();
        PrintWriter out = FileUtils.asPrintWriterUTF8(_out);
        if (!context.outputFormat.equals(RunQuery.FMT_NONE))
        {
            out.println( (b ? "Yes" : "No") );
        }
        out.flush();
        out.close();
    }

}
