package com.ldodds.sparql;

import java.io.OutputStream;

import com.hp.hpl.jena.query.Query;

/**
 * TODO check that outputFormat is supported, and if not, change to default
 * 
 * @author ccslrd
 */
abstract class AbstractQueryRunner implements QueryRunner
{
    protected OutputStream _out;    
    public AbstractQueryRunner(OutputStream out)
    {
        _out = out;
    }
    
    public static QueryRunner getQueryRunner(Query query, OutputStream out)
    {
        if (query.isSelectType())
            	return new SelectQueryRunner(out);
        
        if (query.isDescribeType()) 
            	return new DescribeQueryRunner(out);
        
        if (query.isConstructType())
            	return new ConstructQueryRunner(out);
        
        if (query.isAskType()) 
            	return new AskQueryRunner(out);
        
        throw new RuntimeException("Unknown query type!");        
    }
    
}
