/*
 * Decompiled with CFR 0.152.
 */
package jena;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.ProfileRegistry;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.StringSubstitution;
import org.apache.oro.text.regex.Substitution;
import org.apache.oro.text.regex.Util;
import org.apache.xerces.util.XMLChar;

public class schemagen {
    public static final String NS = "http://jena.hpl.hp.com/2003/04/schemagen#";
    public static final String DEFAULT_CONFIG_URI = "file:schemagen.rdf";
    public static final String DEFAULT_MARKER = "%";
    public static final String DEFAULT_TEMPLATE = "public static final %valclass% %valname% = m_model.%valcreator%( \"%valuri%\" );";
    public static final String DEFAULT_INDIVIDUAL_TEMPLATE = "public static final %valclass% %valname% = m_model.%valcreator%( \"%valuri%\", %valtype% );";
    public static final String DEFAULT_HEADER_TEMPLATE = "/* CVS $Id: $ */%nl%%package% %nl%%imports% %nl%/**%nl% * Vocabulary definitions from %sourceURI% %nl% * @author Auto-generated by schemagen on %date% %nl% */";
    public static final int COMMENT_LENGTH_LIMIT = 80;
    protected static final Object OPT_CONFIG_FILE = new Object();
    protected static final Object OPT_NO_COMMENTS = new Object();
    protected static final Object OPT_INPUT = new Object();
    protected static final Object OPT_LANG_DAML = new Object();
    protected static final Object OPT_LANG_OWL = new Object();
    protected static final Object OPT_LANG_RDFS = new Object();
    protected static final Object OPT_OUTPUT = new Object();
    protected static final Object OPT_HEADER = new Object();
    protected static final Object OPT_FOOTER = new Object();
    protected static final Object OPT_ROOT = new Object();
    protected static final Object OPT_MARKER = new Object();
    protected static final Object OPT_PACKAGENAME = new Object();
    protected static final Object OPT_ONTOLOGY = new Object();
    protected static final Object OPT_CLASSNAME = new Object();
    protected static final Object OPT_CLASSDEC = new Object();
    protected static final Object OPT_NAMESPACE = new Object();
    protected static final Object OPT_DECLARATIONS = new Object();
    protected static final Object OPT_PROPERTY_SECTION = new Object();
    protected static final Object OPT_CLASS_SECTION = new Object();
    protected static final Object OPT_INDIVIDUALS_SECTION = new Object();
    protected static final Object OPT_NOPROPERTIES = new Object();
    protected static final Object OPT_NOCLASSES = new Object();
    protected static final Object OPT_NOINDIVIDUALS = new Object();
    protected static final Object OPT_NOHEADER = new Object();
    protected static final Object OPT_PROP_TEMPLATE = new Object();
    protected static final Object OPT_CLASS_TEMPLATE = new Object();
    protected static final Object OPT_INDIVIDUAL_TEMPLATE = new Object();
    protected static final Object OPT_UC_NAMES = new Object();
    protected static final Object OPT_INCLUDE = new Object();
    protected static final Object OPT_CLASSNAME_SUFFIX = new Object();
    protected static final Object OPT_ENCODING = new Object();
    protected static final Object OPT_HELP = new Object();
    protected static final Object OPT_DOS = new Object();
    protected List m_cmdLineArgs;
    protected Resource m_root;
    protected Model m_config = ModelFactory.createDefaultModel();
    protected OntModel m_source;
    protected PrintStream m_output;
    protected Object[][] m_optionDefinitions = new Object[][]{{OPT_CONFIG_FILE, new OptionDefinition("-c", null)}, {OPT_ROOT, new OptionDefinition("-r", null)}, {OPT_NO_COMMENTS, new OptionDefinition("--nocomments", "noComments")}, {OPT_INPUT, new OptionDefinition("-i", "input")}, {OPT_LANG_DAML, new OptionDefinition("--daml", "daml")}, {OPT_LANG_OWL, new OptionDefinition("--owl", "owl")}, {OPT_LANG_RDFS, new OptionDefinition("--rdfs", "rdfs")}, {OPT_OUTPUT, new OptionDefinition("-o", "output")}, {OPT_HEADER, new OptionDefinition("--header", "header")}, {OPT_FOOTER, new OptionDefinition("--footer", "footer")}, {OPT_MARKER, new OptionDefinition("--marker", "marker")}, {OPT_PACKAGENAME, new OptionDefinition("--package", "package")}, {OPT_ONTOLOGY, new OptionDefinition("--ontology", "ontology")}, {OPT_CLASSNAME, new OptionDefinition("-n", "classname")}, {OPT_CLASSDEC, new OptionDefinition("--classdec", "classdec")}, {OPT_NAMESPACE, new OptionDefinition("-a", "namespace")}, {OPT_DECLARATIONS, new OptionDefinition("--declarations", "declarations")}, {OPT_PROPERTY_SECTION, new OptionDefinition("--propSection", "propSection")}, {OPT_CLASS_SECTION, new OptionDefinition("--classSection", "classSection")}, {OPT_INDIVIDUALS_SECTION, new OptionDefinition("--individualsSection", "individualsSection")}, {OPT_NOPROPERTIES, new OptionDefinition("--noproperties", "noproperties")}, {OPT_NOCLASSES, new OptionDefinition("--noclasses", "noclasses")}, {OPT_NOINDIVIDUALS, new OptionDefinition("--noindividuals", "noindividuals")}, {OPT_PROP_TEMPLATE, new OptionDefinition("--propTemplate", "propTemplate")}, {OPT_CLASS_TEMPLATE, new OptionDefinition("--classTemplate", "classTemplate")}, {OPT_INDIVIDUAL_TEMPLATE, new OptionDefinition("--individualTemplate", "individualTemplate")}, {OPT_UC_NAMES, new OptionDefinition("--uppercase", "uppercase")}, {OPT_INCLUDE, new OptionDefinition("--include", "include")}, {OPT_CLASSNAME_SUFFIX, new OptionDefinition("--classnamesuffix", "classnamesuffix")}, {OPT_NOHEADER, new OptionDefinition("--noheader", "noheader")}, {OPT_ENCODING, new OptionDefinition("-e", "encoding")}, {OPT_HELP, new OptionDefinition("--help", null)}, {OPT_DOS, new OptionDefinition("--dos", "dos")}};
    protected List m_replacements = new ArrayList();
    protected Perl5Compiler m_perlCompiler = new Perl5Compiler();
    protected PatternMatcher m_matcher = new Perl5Matcher();
    protected String m_nl = "\n";
    protected int m_indentStep = 4;
    protected Set m_usedNames = new HashSet();
    protected Map m_resourcesToNames = new HashMap();
    protected List m_includeURI = new ArrayList();

    public static void main(String[] stringArray) {
        new schemagen().go(stringArray);
    }

    protected void go(String[] stringArray) {
        block4: {
            this.m_cmdLineArgs = Arrays.asList(stringArray);
            if (this.m_cmdLineArgs.contains(this.getOpt((Object)schemagen.OPT_HELP).m_cmdLineForm)) {
                this.usage();
            }
            String string = DEFAULT_CONFIG_URI;
            if (this.hasValue(OPT_CONFIG_FILE)) {
                string = this.urlCheck(this.getValue(OPT_CONFIG_FILE));
            }
            try {
                this.m_config.read(string);
            }
            catch (Exception exception) {
                if (string.equals(DEFAULT_CONFIG_URI)) break block4;
                this.abort("Failed to read configuration from URI " + string, exception);
            }
        }
        this.processInput();
    }

    protected void processInput() {
        this.determineConfigRoot();
        this.determineLanguage();
        this.selectInput();
        this.selectOutput();
        this.setGlobalReplacements();
        this.processHeader();
        this.writeClassDeclaration();
        this.writeInitialDeclarations();
        this.writeProperties();
        this.writeClasses();
        this.writeIndividuals();
        this.writeClassClose();
        this.processFooter();
        this.closeOutput();
    }

    protected void determineConfigRoot() {
        if (this.hasValue(OPT_ROOT)) {
            String string = this.getValue(OPT_ROOT);
            this.m_root = this.m_config.getResource(string);
        } else {
            StmtIterator stmtIterator = this.m_config.listStatements(null, RDF.type, this.m_config.getResource("http://jena.hpl.hp.com/2003/04/schemagen#Config"));
            this.m_root = stmtIterator.hasNext() ? stmtIterator.nextStatement().getSubject() : this.m_config.createResource();
        }
        this.m_includeURI.addAll(this.getAllValues(OPT_INCLUDE));
    }

    protected void determineLanguage() {
        OntModelSpec ontModelSpec = null;
        ontModelSpec = this.isTrue(OPT_LANG_DAML) ? OntModelSpec.getDefaultSpec("http://www.daml.org/2001/03/daml+oil#") : (this.isTrue(OPT_LANG_RDFS) ? OntModelSpec.getDefaultSpec(ProfileRegistry.RDFS_LANG) : OntModelSpec.getDefaultSpec(ProfileRegistry.OWL_LANG));
        this.m_source = ModelFactory.createOntologyModel(ontModelSpec, null);
        this.m_source.getDocumentManager().setProcessImports(false);
    }

    protected void selectInput() {
        if (!this.hasResourceValue(OPT_INPUT)) {
            this.usage();
        }
        String string = this.urlCheck(this.getValue(OPT_INPUT));
        String string2 = this.getValue(OPT_ENCODING);
        try {
            if (string2 == null) {
                this.m_source.read(string);
            } else {
                this.m_source.read(string, string2);
            }
        }
        catch (JenaException jenaException) {
            this.abort("Failed to read input source " + string, jenaException);
        }
    }

    protected void selectOutput() {
        String string = this.getValue(OPT_OUTPUT);
        if (string == null) {
            this.m_output = System.out;
        } else {
            try {
                File file = new File(string);
                if (file.isDirectory()) {
                    String string2 = string + System.getProperty("file.separator") + this.getClassName() + ".java";
                    file = new File(string2);
                }
                this.m_output = new PrintStream(new FileOutputStream(file));
            }
            catch (Exception exception) {
                this.abort("I/O error while trying to open file for writing: " + string, null);
            }
        }
        if (this.isTrue(OPT_DOS)) {
            this.m_nl = "\r\n";
        }
    }

    protected void processHeader() {
        String string;
        String string2 = string = this.hasValue(OPT_HEADER) ? this.getValue(OPT_HEADER) : DEFAULT_HEADER_TEMPLATE;
        if (!this.hasValue(OPT_NOHEADER)) {
            this.writeln(0, this.substitute(string));
        } else {
            this.writeln(0, "import com.hp.hpl.jena.rdf.model.*;");
            if (this.isTrue(OPT_ONTOLOGY)) {
                this.writeln(0, "import com.hp.hpl.jena.ontology.*;");
            }
        }
    }

    protected void processFooter() {
        String string = this.getValue(OPT_FOOTER);
        if (string != null) {
            this.writeln(0, this.substitute(string));
        }
    }

    protected void setGlobalReplacements() {
        this.addReplacementPattern("date", new SimpleDateFormat("dd MMM yyyy HH:mm").format(new Date()));
        this.addReplacementPattern("package", this.hasValue(OPT_PACKAGENAME) ? "package " + this.getValue(OPT_PACKAGENAME) + ";" : "");
        this.addReplacementPattern("imports", this.getImports());
        this.addReplacementPattern("classname", this.getClassName());
        this.addReplacementPattern("sourceURI", this.getResource(OPT_INPUT).getURI());
        this.addReplacementPattern("nl", this.m_nl);
    }

    protected void addReplacementPattern(String string, String string2) {
        if (string2 != null && string != null) {
            String string3 = this.getValue(OPT_MARKER);
            string3 = string3 == null ? DEFAULT_MARKER : string3;
            try {
                this.m_replacements.add(new Replacement(this.m_perlCompiler.compile(string3 + string + string3), (Substitution)new StringSubstitution(string2)));
            }
            catch (MalformedPatternException malformedPatternException) {
                this.abort("Malformed regexp pattern " + string3 + string + string3, (Exception)((Object)malformedPatternException));
            }
        }
    }

    protected void pop(int n) {
        for (int i = 0; i < n; ++i) {
            this.m_replacements.remove(this.m_replacements.size() - 1);
        }
    }

    protected void closeOutput() {
        this.m_output.flush();
        this.m_output.close();
    }

    protected boolean isTrue(Object object) {
        return this.getOpt(object).isTrue();
    }

    protected boolean hasValue(Object object) {
        return this.getOpt(object).hasValue();
    }

    protected boolean hasResourceValue(Object object) {
        return this.getOpt(object).hasResourceValue();
    }

    protected String getValue(Object object) {
        return this.getOpt(object).getValue();
    }

    protected List getAllValues(Object object) {
        Object object2;
        ArrayList arrayList = new ArrayList();
        OptionDefinition optionDefinition = this.getOpt(object);
        StmtIterator stmtIterator = this.m_cmdLineArgs.iterator();
        while (stmtIterator.hasNext()) {
            object2 = (String)stmtIterator.next();
            if (!((String)object2).equals(optionDefinition.m_cmdLineForm)) continue;
            arrayList.add(stmtIterator.next());
        }
        stmtIterator = this.m_root.listProperties(optionDefinition.m_prop);
        while (stmtIterator.hasNext()) {
            object2 = stmtIterator.nextStatement();
            if (object2.getObject() instanceof Literal) {
                arrayList.add(object2.getString());
                continue;
            }
            arrayList.add(object2.getResource().getURI());
        }
        return arrayList;
    }

    protected Resource getResource(Object object) {
        return this.getOpt(object).getResource();
    }

    protected OptionDefinition getOpt(Object object) {
        for (int i = 0; i < this.m_optionDefinitions.length; ++i) {
            if (this.m_optionDefinitions[i][0] != object) continue;
            return (OptionDefinition)this.m_optionDefinitions[i][1];
        }
        return null;
    }

    protected void abort(String string, Exception exception) {
        System.err.println(string);
        if (exception != null) {
            System.err.println(exception);
        }
        System.exit(1);
    }

    protected void usage() {
        System.err.println("Usage:");
        System.err.println("  java jena.schemagen [options ...]");
        System.err.println();
        System.err.println("Commonly used options include:");
        System.err.println("   -i <input> the source document as a file or URL.");
        System.err.println("   -n <name> the name of the created Java class.");
        System.err.println("   -a <uri> the namespace URI of the source document.");
        System.err.println("   -o <file> the file to write the generated class into.");
        System.err.println("   -o <dir> the directory in which the generated Java class is created.");
        System.err.println("            By default, output goes to stdout.");
        System.err.println("   -e <encoding> the encoding of the input document (N3, RDF/XML, etc).");
        System.err.println("   -c <config> a filename or URL for an RDF document containing ");
        System.err.println("               configuration parameters.");
        System.err.println();
        System.err.println("Many other options are available. See the schemagen HOWTO in the ");
        System.err.println("Jena documentation for full details.");
        System.exit(1);
    }

    protected String substitute(String string) {
        String string2 = string;
        Iterator iterator = this.m_replacements.iterator();
        while (iterator.hasNext()) {
            Replacement replacement = (Replacement)iterator.next();
            string2 = Util.substitute((PatternMatcher)this.m_matcher, (Pattern)replacement.pattern, (Substitution)replacement.sub, (String)string2, (int)-1);
        }
        return string2;
    }

    protected int indentTo(int n, StringBuffer stringBuffer) {
        int n2 = n * this.m_indentStep;
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(' ');
        }
        return n2;
    }

    protected void writeln(int n) {
        this.writeln(n, "");
    }

    protected void writeln(int n, String string) {
        this.write(n, string);
        this.m_output.print(this.m_nl);
    }

    protected void write(int n, String string) {
        for (int i = 0; i < this.m_indentStep * n; ++i) {
            this.m_output.print(" ");
        }
        this.m_output.print(string);
    }

    protected String getImports() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("import com.hp.hpl.jena.rdf.model.*;");
        stringBuffer.append(this.m_nl);
        if (this.useOntology()) {
            stringBuffer.append("import com.hp.hpl.jena.ontology.*;");
        }
        return stringBuffer.toString();
    }

    protected String getClassName() {
        int n;
        if (this.hasValue(OPT_CLASSNAME)) {
            return this.getValue(OPT_CLASSNAME);
        }
        String string = this.getValue(OPT_INPUT);
        string = string.endsWith("#") ? string.substring(0, string.length() - 1) : string;
        string = string.endsWith(".daml") ? string.substring(0, string.length() - 5) : string;
        string = string.endsWith(".owl") ? string.substring(0, string.length() - 4) : string;
        string = string.endsWith(".rdf") ? string.substring(0, string.length() - 4) : string;
        string = string.endsWith(".rdfs") ? string.substring(0, string.length() - 5) : string;
        string = string.endsWith(".n3") ? string.substring(0, string.length() - 3) : string;
        string = string.endsWith(".xml") ? string.substring(0, string.length() - 4) : string;
        for (n = string.length() - 1; n > 0; --n) {
            if (Character.isUnicodeIdentifierPart(string.charAt(n)) || string.charAt(n) == '-') continue;
            ++n;
            break;
        }
        String string2 = string.substring(n);
        if (this.hasValue(OPT_CLASSNAME_SUFFIX)) {
            string2 = string2 + this.getValue(OPT_CLASSNAME_SUFFIX);
        }
        return this.asLegalJavaID(string2, true);
    }

    protected boolean useOntology() {
        return this.isTrue(OPT_ONTOLOGY);
    }

    protected boolean noComments() {
        return this.isTrue(OPT_NO_COMMENTS);
    }

    protected String asLegalJavaID(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        try {
            while (!Character.isJavaIdentifierStart(string.charAt(n))) {
                ++n;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            System.err.println("Could not identify legal Java identifier start character in '" + string + "', replacing with __");
            return "__";
        }
        stringBuffer.append(bl ? Character.toUpperCase(string.charAt(n)) : string.charAt(n));
        ++n;
        while (n < string.length()) {
            char c = string.charAt(n);
            stringBuffer.append(Character.isJavaIdentifierPart(c) ? c : (char)'_');
            ++n;
        }
        return stringBuffer.toString();
    }

    protected void writeClassDeclaration() {
        this.write(0, "public class ");
        this.write(0, this.getClassName());
        this.write(0, " ");
        if (this.hasValue(OPT_CLASSDEC)) {
            this.write(0, this.getValue(OPT_CLASSDEC));
        }
        this.writeln(0, "{");
    }

    protected void writeClassClose() {
        this.writeln(0, "}");
    }

    protected void writeInitialDeclarations() {
        this.writeModelDeclaration();
        this.writeNamespace();
        if (this.hasValue(OPT_DECLARATIONS)) {
            this.writeln(0, this.getValue(OPT_DECLARATIONS));
        }
    }

    protected void writeModelDeclaration() {
        if (this.useOntology()) {
            String string = "OWL";
            if (this.isTrue(OPT_LANG_DAML)) {
                string = "DAML";
            } else if (this.isTrue(OPT_LANG_RDFS)) {
                string = "RDFS";
            }
            this.writeln(1, "/** <p>The ontology model that holds the vocabulary terms</p> */");
            this.writeln(1, "private static OntModel m_model = ModelFactory.createOntologyModel( OntModelSpec." + string + "_MEM, null );");
        } else {
            this.writeln(1, "/** <p>The RDF model that holds the vocabulary terms</p> */");
            this.writeln(1, "private static Model m_model = ModelFactory.createDefaultModel();");
        }
        this.writeln(1);
    }

    protected void writeNamespace() {
        String string = this.determineNamespaceURI();
        this.writeln(1, "/** <p>The namespace of the vocabulary as a string</p> */");
        this.writeln(1, "public static final String NS = \"" + string + "\";");
        this.writeln(1);
        this.writeln(1, "/** <p>The namespace of the vocabulary as a string</p>");
        this.writeln(1, " *  @see #NS */");
        this.writeln(1, "public static String getURI() {return NS;}");
        this.writeln(1);
        this.writeln(1, "/** <p>The namespace of the vocabulary as a resource</p> */");
        this.writeln(1, "public static final Resource NAMESPACE = m_model.createResource( NS );");
        this.writeln(1);
    }

    protected String determineNamespaceURI() {
        if (this.hasResourceValue(OPT_NAMESPACE)) {
            String string = this.getResource(OPT_NAMESPACE).getURI();
            this.m_includeURI.add(string);
            return string;
        }
        String string = this.m_source.getNsPrefixURI("");
        if (string == null) {
            string = this.m_source.getBaseModel().getNsPrefixURI("");
        }
        if (string != null) {
            this.m_includeURI.add(string);
            return string;
        }
        try {
            Resource resource = this.m_source.getBaseModel().listStatements(null, RDF.type, this.m_source.getProfile().ONTOLOGY()).nextStatement().getSubject();
            String string2 = resource.getURI();
            char c = string2.charAt(string2.length() - 1);
            boolean bl = XMLChar.isNCName((int)c);
            string2 = bl ? string2 + "#" : string2;
            this.m_includeURI.add(string2);
            return string2;
        }
        catch (Exception exception) {
            this.abort("Could not determine the base URI for the input vocabulary", null);
            return null;
        }
    }

    protected void writeProperties() {
        if (this.isTrue(OPT_NOPROPERTIES)) {
            return;
        }
        if (this.hasValue(OPT_PROPERTY_SECTION)) {
            this.writeln(0, this.getValue(OPT_PROPERTY_SECTION));
        }
        if (this.useOntology()) {
            this.writeObjectProperties();
            this.writeDatatypeProperties();
            this.writeAnnotationProperties();
            this.writeRDFProperties();
        } else {
            this.writeRDFProperties();
        }
    }

    protected void writeObjectProperties() {
        String string;
        String string2 = string = this.hasValue(OPT_PROP_TEMPLATE) ? this.getValue(OPT_PROP_TEMPLATE) : DEFAULT_TEMPLATE;
        if (!this.isTrue(OPT_LANG_RDFS)) {
            ExtendedIterator extendedIterator = this.m_source.listObjectProperties();
            while (extendedIterator.hasNext()) {
                this.writeValue((Resource)extendedIterator.next(), string, "ObjectProperty", "createObjectProperty", "_PROP");
            }
        }
    }

    protected void writeDatatypeProperties() {
        String string;
        String string2 = string = this.hasValue(OPT_PROP_TEMPLATE) ? this.getValue(OPT_PROP_TEMPLATE) : DEFAULT_TEMPLATE;
        if (!this.isTrue(OPT_LANG_RDFS)) {
            ExtendedIterator extendedIterator = this.m_source.listDatatypeProperties();
            while (extendedIterator.hasNext()) {
                this.writeValue((Resource)extendedIterator.next(), string, "DatatypeProperty", "createDatatypeProperty", "_PROP");
            }
        }
    }

    protected void writeAnnotationProperties() {
        String string;
        String string2 = string = this.hasValue(OPT_PROP_TEMPLATE) ? this.getValue(OPT_PROP_TEMPLATE) : DEFAULT_TEMPLATE;
        if (!this.isTrue(OPT_LANG_RDFS)) {
            ExtendedIterator extendedIterator = this.m_source.listAnnotationProperties();
            while (extendedIterator.hasNext()) {
                this.writeValue((Resource)extendedIterator.next(), string, "AnnotationProperty", "createAnnotationProperty", "_PROP");
            }
        }
    }

    protected void writeRDFProperties() {
        String string = this.hasValue(OPT_PROP_TEMPLATE) ? this.getValue(OPT_PROP_TEMPLATE) : DEFAULT_TEMPLATE;
        StmtIterator stmtIterator = this.m_source.listStatements(null, RDF.type, RDF.Property);
        while (stmtIterator.hasNext()) {
            this.writeValue(stmtIterator.nextStatement().getSubject(), string, "Property", "createProperty", "_PROP");
        }
    }

    protected void writeClasses() {
        if (this.isTrue(OPT_NOCLASSES)) {
            return;
        }
        if (this.hasValue(OPT_CLASS_SECTION)) {
            this.writeln(0, this.getValue(OPT_CLASS_SECTION));
        }
        if (this.useOntology()) {
            this.writeOntClasses();
        } else {
            this.writeRDFClasses();
        }
    }

    protected void writeOntClasses() {
        String string = this.hasValue(OPT_CLASS_TEMPLATE) ? this.getValue(OPT_CLASS_TEMPLATE) : DEFAULT_TEMPLATE;
        ExtendedIterator extendedIterator = this.m_source.listClasses();
        while (extendedIterator.hasNext()) {
            this.writeValue((Resource)extendedIterator.next(), string, "OntClass", "createClass", "_CLASS");
        }
    }

    protected void writeRDFClasses() {
        String string = this.hasValue(OPT_CLASS_TEMPLATE) ? this.getValue(OPT_CLASS_TEMPLATE) : DEFAULT_TEMPLATE;
        StmtIterator stmtIterator = this.m_source.listStatements(null, RDF.type, RDFS.Class);
        while (stmtIterator.hasNext()) {
            this.writeValue(stmtIterator.nextStatement().getSubject(), string, "Resource", "createResource", "_CLASS");
        }
    }

    protected void writeIndividuals() {
        if (this.isTrue(OPT_NOINDIVIDUALS)) {
            return;
        }
        if (this.hasValue(OPT_INDIVIDUALS_SECTION)) {
            this.writeln(0, this.getValue(OPT_INDIVIDUALS_SECTION));
        }
        if (this.useOntology()) {
            this.writeOntIndividuals();
        } else {
            this.writeRDFIndividuals();
        }
    }

    protected void writeOntIndividuals() {
        String string = this.hasValue(OPT_INDIVIDUAL_TEMPLATE) ? this.getValue(OPT_INDIVIDUAL_TEMPLATE) : DEFAULT_INDIVIDUAL_TEMPLATE;
        StmtIterator stmtIterator = this.m_source.listStatements(null, RDF.type, (RDFNode)null);
        block0: while (stmtIterator.hasNext()) {
            Resource resource;
            Statement statement = stmtIterator.nextStatement();
            if (!(statement.getObject() instanceof Resource) || (resource = (Resource)statement.getObject()).isAnon()) continue;
            String string2 = resource.getURI();
            Iterator iterator = this.m_includeURI.iterator();
            while (iterator.hasNext()) {
                if (!string2.startsWith((String)iterator.next())) continue;
                Resource resource2 = statement.getSubject();
                String string3 = (String)this.m_resourcesToNames.get(statement.getObject());
                String string4 = string3 != null ? string3 : "m_model.createClass( \"" + string2 + "\" )";
                this.addReplacementPattern("valtype", string4);
                this.writeValue(resource2, string, "Individual", "createIndividual", "_INSTANCE");
                this.pop(1);
                continue block0;
            }
        }
    }

    protected void writeRDFIndividuals() {
        String string = this.hasValue(OPT_INDIVIDUAL_TEMPLATE) ? this.getValue(OPT_INDIVIDUAL_TEMPLATE) : DEFAULT_TEMPLATE;
        StmtIterator stmtIterator = this.m_source.listStatements(null, RDF.type, (RDFNode)null);
        block0: while (stmtIterator.hasNext()) {
            Resource resource;
            Statement statement = stmtIterator.nextStatement();
            if (!(statement.getObject() instanceof Resource) || (resource = statement.getResource()).isAnon()) continue;
            String string2 = resource.getURI();
            Iterator iterator = this.m_includeURI.iterator();
            while (iterator.hasNext()) {
                if (!string2.startsWith((String)iterator.next())) continue;
                this.writeValue(statement.getSubject(), string, "Resource", "createResource", "_INSTANCE");
                continue block0;
            }
        }
    }

    protected void writeValue(Resource resource, String string, String string2, String string3, String string4) {
        if (!this.filter(resource)) {
            if (!this.noComments() && this.hasComment(resource)) {
                this.writeln(1, this.formatComment(this.getComment(resource)));
            }
            this.addReplacementPattern("valuri", resource.getURI());
            this.addReplacementPattern("valname", this.getValueName(resource, string4));
            this.addReplacementPattern("valclass", string2);
            this.addReplacementPattern("valcreator", string3);
            this.writeln(1, this.substitute(string));
            this.writeln(1);
            this.pop(4);
        }
    }

    protected boolean hasComment(Resource resource) {
        return resource.hasProperty(RDFS.comment) || resource.hasProperty(DAML_OIL.comment);
    }

    protected String getComment(Resource resource) {
        StringBuffer stringBuffer = new StringBuffer();
        NodeIterator nodeIterator = this.m_source.listObjectsOfProperty(resource, RDFS.comment);
        while (nodeIterator.hasNext()) {
            stringBuffer.append(((Literal)nodeIterator.nextNode()).getLexicalForm().trim());
        }
        nodeIterator = this.m_source.listObjectsOfProperty(resource, DAML_OIL.comment);
        while (nodeIterator.hasNext()) {
            stringBuffer.append(((Literal)nodeIterator.nextNode()).getLexicalForm().trim());
        }
        return stringBuffer.toString();
    }

    protected String formatComment(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("/** <p>");
        boolean bl = false;
        int n = stringBuffer.length();
        boolean bl2 = true;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) {
                if (bl) continue;
                c = ' ';
                bl = true;
            } else {
                bl = false;
            }
            if (c == '\\') {
                c = string.charAt(++i);
                switch (c) {
                    case 'n': {
                        stringBuffer.append(this.m_nl);
                        n = this.indentTo(1, stringBuffer);
                        stringBuffer.append(" *  ");
                        n += 3;
                        bl2 = false;
                        break;
                    }
                }
            } else if (c == '<') {
                stringBuffer.append("&lt;");
                n += 4;
            } else if (c == '>') {
                stringBuffer.append("&gt;");
                n += 4;
            } else if (c == '&') {
                stringBuffer.append("&amp;");
                n += 5;
            } else {
                stringBuffer.append(c);
                ++n;
            }
            if (n <= 80 || !bl) continue;
            stringBuffer.append(this.m_nl);
            n = this.indentTo(1, stringBuffer);
            stringBuffer.append(" *  ");
            n += 3;
            bl2 = false;
        }
        stringBuffer.append("</p>");
        stringBuffer.append(bl2 ? "" : this.m_nl);
        this.indentTo(bl2 ? 0 : 1, stringBuffer);
        stringBuffer.append(" */");
        return stringBuffer.toString();
    }

    protected boolean filter(Resource resource) {
        if (resource.isAnon()) {
            return true;
        }
        if (this.m_resourcesToNames.containsKey(resource)) {
            return true;
        }
        Iterator iterator = this.m_includeURI.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!resource.getURI().startsWith(string)) continue;
            return false;
        }
        return true;
    }

    protected String getValueName(Resource resource, String string) {
        String string2 = this.isTrue(OPT_UC_NAMES) ? this.getUCValueName(resource) : resource.getLocalName();
        string2 = this.asLegalJavaID(string2, false);
        int n = 0;
        String string3 = string2;
        while (this.m_usedNames.contains(string2)) {
            string2 = n == 0 ? string2 + string : string3 + string + n;
            ++n;
        }
        this.m_usedNames.add(string2);
        this.m_resourcesToNames.put(resource, string2);
        return string2;
    }

    protected String getUCValueName(Resource resource) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = resource.getLocalName();
        char c = '\u0000';
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (Character.isLowerCase(c) && Character.isUpperCase(c2)) {
                stringBuffer.append('_');
            }
            stringBuffer.append(Character.toUpperCase(c2));
            c = c2;
        }
        return stringBuffer.toString();
    }

    protected String urlCheck(String string) {
        boolean bl = true;
        String string2 = string;
        try {
            new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            bl = false;
        }
        if (!bl) {
            bl = true;
            String string3 = System.getProperty("file.separator");
            string2 = "file:" + (string.startsWith(string3) ? string3 + string3 : "") + string;
            try {
                new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                bl = false;
            }
        }
        if (!bl) {
            this.abort("Could not parse " + string + " as a legal URL or a file reference. Aborting.", null);
        }
        return string2;
    }

    protected class Replacement {
        protected Substitution sub;
        protected Pattern pattern;

        protected Replacement(Pattern pattern, Substitution substitution) {
            this.sub = substitution;
            this.pattern = pattern;
        }
    }

    protected class OptionDefinition {
        protected String m_cmdLineForm;
        protected Property m_prop;

        protected OptionDefinition(String string, String string2) {
            this.m_cmdLineForm = string;
            if (string2 != null) {
                this.m_prop = schemagen.this.m_config.getProperty(schemagen.NS, string2);
            }
        }

        protected boolean isTrue() {
            if (schemagen.this.m_cmdLineArgs.contains(this.m_cmdLineForm)) {
                return true;
            }
            if (schemagen.this.m_root.hasProperty(this.m_prop)) {
                return schemagen.this.m_root.getRequiredProperty(this.m_prop).getBoolean();
            }
            return false;
        }

        protected String getValue() {
            int n = schemagen.this.m_cmdLineArgs.indexOf(this.m_cmdLineForm);
            if (n >= 0) {
                try {
                    return (String)schemagen.this.m_cmdLineArgs.get(n + 1);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    System.err.println("Value for parameter " + this.m_cmdLineForm + " not set! Aborting.");
                }
            }
            if (this.m_prop != null && schemagen.this.m_root.hasProperty(this.m_prop)) {
                return schemagen.this.m_root.getRequiredProperty(this.m_prop).getString();
            }
            return null;
        }

        protected boolean hasValue() {
            return this.getValue() != null;
        }

        protected Resource getResource() {
            int n = schemagen.this.m_cmdLineArgs.indexOf(this.m_cmdLineForm);
            if (n >= 0) {
                try {
                    return schemagen.this.m_config.getResource((String)schemagen.this.m_cmdLineArgs.get(n + 1));
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    System.err.println("Value for parameter " + this.m_cmdLineForm + " not set! Aborting.");
                }
            }
            if (this.m_prop != null && schemagen.this.m_root.hasProperty(this.m_prop)) {
                return schemagen.this.m_root.getRequiredProperty(this.m_prop).getResource();
            }
            return null;
        }

        protected boolean hasResourceValue() {
            return this.getResource() != null;
        }
    }
}

