/*
 * Decompiled with CFR 0.152.
 */
package jena;

import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.ProfileRegistry;
import com.hp.hpl.jena.ontology.tidy.Checker;
import com.hp.hpl.jena.ontology.tidy.CheckerResults;
import com.hp.hpl.jena.ontology.tidy.StreamingChecker;
import com.hp.hpl.jena.ontology.tidy.SyntaxProblem;
import com.hp.hpl.jena.ontology.tidy.test.WGTests;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.shared.BrokenException;
import java.io.InputStream;
import java.util.Iterator;
import jena.cmdline.ArgDecl;
import jena.cmdline.CommandLine;

public class owlsyntax {
    static final String NL = System.getProperty("line.separator", "\n");
    private static ArgDecl quietDecl = new ArgDecl(false, "-q", "--quiet");
    private static ArgDecl helpDecl = new ArgDecl(false, "-h", "--help");
    private static ArgDecl liteDecl = new ArgDecl(false, "-l", "--lite");
    private static ArgDecl dlDecl = new ArgDecl(false, "-d", "--dl");
    private static ArgDecl bigDecl = new ArgDecl(false, "-b", "--big");
    private static ArgDecl langDecl = new ArgDecl(true, "-L", "--lang");
    private static ArgDecl dmDecl = new ArgDecl(true, "-m", "--manager");
    private static ArgDecl shortDecl = new ArgDecl(false, "-s", "--short");
    private static ArgDecl textUIDecl = new ArgDecl(false, "--textui");
    private static ArgDecl testDecl = new ArgDecl(false, "--test");
    private static String usageMessage = "    " + owlsyntax.class.getName() + " [--lite|--quiet|--dl] [--big|--lang [N-TRIPLE|N3]] [file1] [file2]" + NL + "    " + owlsyntax.class.getName() + " --help" + NL + "    " + owlsyntax.class.getName() + " [--textui] --test [ManifestURL]" + NL + NL + "The first form reports \"Lite\", \"DL\", or \"Full\"" + NL + "If two files are specified, then both files are checked, and" + NL + "the vocabulary usage by both files together must be separated." + NL + "If no files are specified then standard input is used," + NL + "(in this case, relative URIs and rdf:ID's are resolved" + NL + " against <urn:x-jena:syntaxchecker>)." + NL + NL + "  -l --lite     Give error messages for OWL DL or OWL Full constructions." + NL + "  -d --dl       Give error messages for OWL Full constructions (default)." + NL + "  -q --quiet    No error messages." + NL + "  -s --short    Give short error messages" + NL + "                (Default is long messages for OWL Full only)" + NL + "  -b --big      Input file is big - optimize memory usage." + NL + "                Quality of long error messages suffers." + NL + NL + "  -L --lang     Specify N3 or N-TRIPLE input." + NL + NL + "  -m --manager  Specify OWL Document Manager." + NL + NL + "  --test        Run a test suite - default latest OWL Test publication." + NL + "                URL of file:testing/wg/OWLManifest.rdf uses local copy." + NL + "  --textui      Use the junit.textui instead of the swingui" + NL;

    private owlsyntax() {
    }

    public static void main(String[] stringArray) {
        System.out.println(owlsyntax.mainStr(stringArray));
    }

    public static String mainStr(String[] stringArray) {
        OntDocumentManager ontDocumentManager;
        boolean bl;
        boolean bl2;
        String string = "RDF/XML";
        CommandLine commandLine = new CommandLine();
        commandLine.setUsage(usageMessage);
        commandLine.setOutput(System.err);
        commandLine.add(quietDecl).add(helpDecl).add(liteDecl).add(dlDecl).add(bigDecl).add(langDecl).add(dmDecl).add(shortDecl).add(textUIDecl).add(testDecl);
        try {
            commandLine.process(stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.exit(1);
        }
        if (commandLine.contains(langDecl)) {
            string = commandLine.getArg(langDecl).getValue();
        }
        boolean bl3 = commandLine.contains(testDecl) || commandLine.contains(textUIDecl);
        boolean bl4 = bl2 = !bl3 || commandLine.contains(quietDecl) || commandLine.contains(shortDecl) || commandLine.contains(liteDecl) || commandLine.contains(bigDecl);
        boolean bl5 = bl3 ? bl2 || commandLine.items().size() > 1 : (bl = commandLine.items().size() > 2 || commandLine.contains(liteDecl) && commandLine.contains(quietDecl) || commandLine.contains(dlDecl) && commandLine.contains(quietDecl) || commandLine.contains(liteDecl) && commandLine.contains(dlDecl));
        if (commandLine.contains(helpDecl) || bl) {
            System.out.println(usageMessage);
            System.exit(bl ? 1 : 0);
        }
        if (commandLine.contains(dmDecl)) {
            ontDocumentManager = new OntDocumentManager(commandLine.getArg(dmDecl).getValue());
        } else {
            ontDocumentManager = new OntDocumentManager();
            ontDocumentManager.setProcessImports(true);
        }
        if (bl3) {
            String string2 = "http://www.w3.org/TR/owl-test/Manifest";
            if (commandLine.items().size() > 0) {
                string2 = (String)commandLine.items().get(0);
            }
            WGTests.test(commandLine.contains(textUIDecl), string2);
            return "";
        }
        if (string.equals("RDF/XML")) {
            StreamingChecker streamingChecker = new StreamingChecker(commandLine.contains(liteDecl), ontDocumentManager);
            boolean bl6 = commandLine.contains(bigDecl) || commandLine.contains(quietDecl) || commandLine.contains(shortDecl);
            streamingChecker.setOptimizeMemory(bl6);
            switch (commandLine.items().size()) {
                case 0: {
                    return owlsyntax.check(streamingChecker, System.in, "", commandLine);
                }
                case 1: {
                    return owlsyntax.check(streamingChecker, (String)commandLine.items().get(0), "", commandLine);
                }
                case 2: {
                    String string3 = owlsyntax.check(streamingChecker, (String)commandLine.items().get(0), (String)commandLine.items().get(0), commandLine);
                    StreamingChecker streamingChecker2 = new StreamingChecker(commandLine.contains(liteDecl));
                    streamingChecker2.setOptimizeMemory(bl6);
                    string3 = string3 + owlsyntax.check(streamingChecker2, (String)commandLine.items().get(1), (String)commandLine.items().get(1), commandLine);
                    return string3 + owlsyntax.check(streamingChecker, (String)commandLine.items().get(1), "togther", commandLine);
                }
            }
            throw new BrokenException("Logic error");
        }
        Checker checker = new Checker(commandLine.contains(liteDecl));
        if (commandLine.contains(bigDecl)) {
            System.err.println("--big ignored for " + string + " files.");
        }
        switch (commandLine.items().size()) {
            case 0: {
                return owlsyntax.check(checker, System.in, string, ontDocumentManager, "", commandLine);
            }
            case 1: {
                return owlsyntax.check(checker, (String)commandLine.items().get(0), string, ontDocumentManager, "", commandLine);
            }
            case 2: {
                String string4 = owlsyntax.check(checker, (String)commandLine.items().get(0), string, ontDocumentManager, (String)commandLine.items().get(0), commandLine);
                Checker checker2 = new Checker(commandLine.contains(liteDecl));
                string4 = string4 + owlsyntax.check(checker2, (String)commandLine.items().get(1), string, ontDocumentManager, (String)commandLine.items().get(1), commandLine);
                return string4 + owlsyntax.check(checker, (String)commandLine.items().get(1), string, ontDocumentManager, "togther", commandLine);
            }
        }
        throw new BrokenException("Logic error");
    }

    private static String check(Checker checker, String string, String string2, OntDocumentManager ontDocumentManager, String string3, CommandLine commandLine) {
        OntModelSpec ontModelSpec = new OntModelSpec(null, ontDocumentManager, null, ProfileRegistry.OWL_LANG);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec);
        ontModel.read(string, string2);
        checker.add(ontModel);
        return owlsyntax.results(checker, string3, commandLine);
    }

    private static String check(Checker checker, InputStream inputStream, String string, OntDocumentManager ontDocumentManager, String string2, CommandLine commandLine) {
        OntModelSpec ontModelSpec = new OntModelSpec(null, ontDocumentManager, null, ProfileRegistry.OWL_LANG);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec);
        ontModel.read(inputStream, "urn:x-jena:syntaxchecker", string);
        checker.add(ontModel);
        return owlsyntax.results(checker, string2, commandLine);
    }

    private static String check(StreamingChecker streamingChecker, InputStream inputStream, String string, CommandLine commandLine) {
        streamingChecker.load(inputStream, "urn:x-jena:syntaxchecker");
        return owlsyntax.results(streamingChecker, string, commandLine);
    }

    private static String check(StreamingChecker streamingChecker, String string, String string2, CommandLine commandLine) {
        streamingChecker.load(string);
        return owlsyntax.results(streamingChecker, string2, commandLine);
    }

    private static String prefix(String string) {
        if (string.length() == 0) {
            return string;
        }
        return string + ": ";
    }

    private static String results(CheckerResults checkerResults, String string, CommandLine commandLine) {
        String string2 = checkerResults.getSubLanguage();
        String string3 = owlsyntax.prefix(string);
        if (!commandLine.contains(quietDecl)) {
            Iterator iterator = checkerResults.getProblems();
            while (iterator.hasNext()) {
                SyntaxProblem syntaxProblem = (SyntaxProblem)iterator.next();
                System.err.println(string3 + (commandLine.contains(shortDecl) ? syntaxProblem.shortDescription() : syntaxProblem.longDescription()));
            }
        }
        return string3 + string2 + NL;
    }
}

