/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.xmloutput.test;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.xmloutput.test.TestXMLFeatures;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import org.apache.oro.text.awk.AwkCompiler;
import org.apache.oro.text.awk.AwkMatcher;
import org.apache.oro.text.regex.MalformedPatternException;

public class PrettyWriterTest
extends ModelTestBase {
    static AwkCompiler awk = new AwkCompiler();
    static AwkMatcher matcher = new AwkMatcher();

    public PrettyWriterTest(String string) {
        super(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check(String string, String string2) throws IOException, MalformedPatternException {
        String string3 = null;
        try {
            Model model = PrettyWriterTest.createMemModel();
            model.read(string);
            StringWriter stringWriter = new StringWriter();
            model.write(stringWriter, "RDF/XML-ABBREV", string);
            stringWriter.close();
            string3 = stringWriter.toString();
            Model model2 = PrettyWriterTest.createMemModel();
            model2.read(new StringReader(string3), string);
            PrettyWriterTest.assertTrue((boolean)model.isIsomorphicWith(model2));
            PrettyWriterTest.assertTrue((String)("Looking for /" + string2 + "/"), (boolean)matcher.contains(string3, awk.compile(string2)));
            string3 = null;
            if (string3 != null) {
                System.err.println("Incorrect contents:");
                System.err.println(string3);
            }
        }
        catch (Throwable throwable) {
            if (string3 != null) {
                System.err.println("Incorrect contents:");
                System.err.println(string3);
            }
            throw throwable;
        }
    }

    public void testAnonDamlClass() throws IOException, MalformedPatternException {
        this.check("file:testing/abbreviated/daml.rdf", "rdf:parseType=[\"']daml:collection[\"']");
    }

    public void testRDFCollection() throws IOException, MalformedPatternException {
        this.check("file:testing/abbreviated/collection.rdf", "rdf:parseType=[\"']Collection[\"']");
    }

    public void testOWLPrefix() throws IOException, MalformedPatternException {
    }

    public void testLi() throws IOException, MalformedPatternException {
        this.check("file:testing/abbreviated/container.rdf", "<rdf:li.*<rdf:li.*<rdf:li.*<rdf:li");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test803804() {
        String string = "<rdf:RDF  xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#' xmlns:rdfs='http://www.w3.org/2000/01/rdf-schema#' xmlns:owl=\"http://www.w3.org/2002/07/owl#\"> <owl:ObjectProperty rdf:about='http://example.org/foo#p'> </owl:ObjectProperty></rdf:RDF>";
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM_RULE_INF, null);
        ontModel.read(new ByteArrayInputStream(string.getBytes()), "http://example.org/foo");
        Model model = ModelFactory.createModelForGraph(ontModel.getGraph());
        TestXMLFeatures.blockLogger();
        try {
            model.write(new OutputStream(){

                public void write(int n) throws IOException {
                }
            }, "RDF/XML-ABBREV");
        }
        finally {
            PrettyWriterTest.assertTrue((boolean)TestXMLFeatures.unblockLogger());
        }
    }
}

