/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.vocabulary;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.vocabulary.RDFS;

public class JMS {
    public static final String baseURI = "http://jena.hpl.hp.com/2003/08/jms#";
    public static final Property loadWith = JMS.property("loadWith");
    public static final Property ontLanguage = JMS.property("ontLanguage");
    public static final Property docManager = JMS.property("docManager");
    public static final Property importMaker = JMS.property("importMaker");
    public static final Property reasonsWith = JMS.property("reasonsWith");
    public static final Property ruleSetURL = JMS.property("ruleSetURL");
    public static final Property ruleSet = JMS.property("ruleSet");
    public static final Property schemaURL = JMS.property("schemaURL");
    public static final Property hasRule = JMS.property("hasRule");
    public static final Property policyPath = JMS.property("policyPath");
    public static final Property dbUser = JMS.property("dbUser");
    public static final Property dbPassword = JMS.property("dbPassword");
    public static final Property dbURL = JMS.property("dbURL");
    public static final Property dbType = JMS.property("dbType");
    public static final Property dbClass = JMS.property("dbClass");
    public static final Property maker = JMS.property("maker");
    public static final Property reificationMode = JMS.property("reificationMode");
    public static final Property reasoner = JMS.property("reasoner");
    public static final Property fileBase = JMS.property("fileBase");
    public static final Resource MakerSpec = JMS.resource("MakerSpec");
    public static final Resource FileMakerSpec = JMS.resource("FileMakerSpec");
    public static final Resource MemMakerSpec = JMS.resource("MemMakerSpec");
    public static final Resource RDBMakerSpec = JMS.resource("RDBMakerSpec");
    public static final Resource ModelSpec = JMS.resource("ModelSpec");
    public static final Resource DefaultModelSpec = JMS.resource("DefaultModelSpec");
    public static final Resource PlainModelSpec = JMS.resource("PlainModelSpec");
    public static final Resource InfModelSpec = JMS.resource("InfModelSpec");
    public static final Resource OntModelSpec = JMS.resource("OntModelSpec");
    public static final Resource rsStandard = JMS.resource("rsStandard");
    public static final Resource rsMinimal = JMS.resource("rsMinimal");
    public static final Resource rsConvenient = JMS.resource("rsConvenient");
    public static final Model schema = ModelFactory.createDefaultModel().add(MemMakerSpec, RDFS.subClassOf, MakerSpec).add(FileMakerSpec, RDFS.subClassOf, MakerSpec).add(RDBMakerSpec, RDFS.subClassOf, MakerSpec).add(DefaultModelSpec, RDFS.subClassOf, ModelSpec).add(PlainModelSpec, RDFS.subClassOf, ModelSpec).add(InfModelSpec, RDFS.subClassOf, PlainModelSpec).add(OntModelSpec, RDFS.subClassOf, InfModelSpec).add((Resource)reificationMode, RDFS.domain, MakerSpec).add((Resource)maker, RDFS.domain, PlainModelSpec).add((Resource)importMaker, RDFS.domain, OntModelSpec).add((Resource)ontLanguage, RDFS.domain, OntModelSpec).add((Resource)reasonsWith, RDFS.domain, InfModelSpec);

    public static String getURI() {
        return baseURI;
    }

    protected static Literal literal(String string) {
        return ResourceFactory.createPlainLiteral(string);
    }

    protected static Resource resource(String string) {
        return ResourceFactory.createResource(baseURI + string);
    }

    protected static Property property(String string) {
        return ResourceFactory.createProperty(baseURI + string);
    }

    public static Node styleAsJMS(ReificationStyle reificationStyle) {
        if (reificationStyle == ReificationStyle.Minimal) {
            return rsMinimal.asNode();
        }
        if (reificationStyle == ReificationStyle.Convenient) {
            return rsConvenient.asNode();
        }
        if (reificationStyle == ReificationStyle.Standard) {
            return rsStandard.asNode();
        }
        return null;
    }

    public static ReificationStyle findStyle(RDFNode rDFNode) {
        return JMS.findStyle(rDFNode.asNode());
    }

    public static ReificationStyle findStyle(Node node) {
        if (node.equals(rsStandard.asNode())) {
            return ReificationStyle.Standard;
        }
        if (node.equals(rsMinimal.asNode())) {
            return ReificationStyle.Minimal;
        }
        if (node.equals(rsConvenient.asNode())) {
            return ReificationStyle.Convenient;
        }
        return null;
    }
}

