/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.test;

import com.hp.hpl.jena.util.LocationMapper;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestLocationMapper
extends TestCase {
    static Log log = LogFactory.getLog((Class)TestLocationMapper.class);
    static final String testingDir = "testing/FileManager";
    static final String filename1 = "file:test";
    static final String notFilename = "zzzz";
    static final String filename2 = "file:testing/FileManager/location-mapping-test-file";
    static final String mapping = "location-mapping-test.n3;testing/FileManager/location-mapping-test.n3";

    public TestLocationMapper(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestLocationMapper.class);
    }

    public void testLocationMapping() {
        LocationMapper locationMapper = new LocationMapper(mapping);
        String string = locationMapper.altMapping(filename1);
        TestLocationMapper.assertNotNull((Object)string);
        TestLocationMapper.assertEquals((String)string, (String)filename2);
    }

    public void testLocationMappingMiss() {
        LocationMapper locationMapper = new LocationMapper(mapping);
        String string = locationMapper.altMapping(notFilename);
        TestLocationMapper.assertNotNull((Object)string);
        TestLocationMapper.assertEquals((String)string, (String)notFilename);
    }

    public void testLocationMappingURLtoFile() {
        LocationMapper locationMapper = new LocationMapper(mapping);
        String string = locationMapper.altMapping("http://example.org/file");
        TestLocationMapper.assertNotNull((Object)string);
        TestLocationMapper.assertEquals((String)string, (String)filename2);
    }
}

