/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.test;

import com.hp.hpl.jena.util.FileUtils;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestFileUtils
extends TestCase {
    public TestFileUtils(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestFileUtils.class);
    }

    public void testLangXML() {
        TestFileUtils.assertEquals((String)"RDF/XML", (String)"RDF/XML");
    }

    public void testLangXMLAbbrev() {
        TestFileUtils.assertEquals((String)"RDF/XML-ABBREV", (String)"RDF/XML-ABBREV");
    }

    public void testLangNTriple() {
        TestFileUtils.assertEquals((String)"N-TRIPLE", (String)"N-TRIPLE");
    }

    public void testLangN3() {
        TestFileUtils.assertEquals((String)"N3", (String)"N3");
    }

    public void testLangTurtle() {
        TestFileUtils.assertEquals((String)"TURTLE", (String)"TURTLE");
    }

    public void testGuessLangLowerCase() {
        TestFileUtils.assertEquals((String)"N3", (String)FileUtils.guessLang("simple.n3"));
        TestFileUtils.assertEquals((String)"N3", (String)FileUtils.guessLang("hello.there.n3"));
        TestFileUtils.assertEquals((String)"TURTLE", (String)FileUtils.guessLang("simple.ttl"));
        TestFileUtils.assertEquals((String)"TURTLE", (String)FileUtils.guessLang("hello.there.ttl"));
        TestFileUtils.assertEquals((String)"N-TRIPLE", (String)FileUtils.guessLang("simple.nt"));
        TestFileUtils.assertEquals((String)"N-TRIPLE", (String)FileUtils.guessLang("whats.up.nt"));
        TestFileUtils.assertEquals((String)"RDF/XML", (String)FileUtils.guessLang("poggle.rdf"));
        TestFileUtils.assertEquals((String)"RDF/XML", (String)FileUtils.guessLang("wise.owl"));
        TestFileUtils.assertEquals((String)"RDF/XML", (String)FileUtils.guessLang("dotless"));
    }

    public void testGuessLangMixedCase() {
        TestFileUtils.assertEquals((String)"N3", (String)FileUtils.guessLang("simple.N3"));
        TestFileUtils.assertEquals((String)"N3", (String)FileUtils.guessLang("hello.there.N3"));
        TestFileUtils.assertEquals((String)"TURTLE", (String)FileUtils.guessLang("simple.TTL"));
        TestFileUtils.assertEquals((String)"TURTLE", (String)FileUtils.guessLang("hello.there.TTL"));
        TestFileUtils.assertEquals((String)"N-TRIPLE", (String)FileUtils.guessLang("simple.NT"));
        TestFileUtils.assertEquals((String)"N-TRIPLE", (String)FileUtils.guessLang("whats.up.Nt"));
        TestFileUtils.assertEquals((String)"RDF/XML", (String)FileUtils.guessLang("poggle.rDf"));
        TestFileUtils.assertEquals((String)"RDF/XML", (String)FileUtils.guessLang("wise.OwL"));
        TestFileUtils.assertEquals((String)"RDF/XML", (String)FileUtils.guessLang("dotless"));
    }

    public void testGuessLangFallback() {
        TestFileUtils.assertEquals((String)"spoo", (String)FileUtils.guessLang("noSuffix", "spoo"));
        TestFileUtils.assertEquals((String)"pots", (String)FileUtils.guessLang("suffix.unknown", "pots"));
        TestFileUtils.assertEquals((String)"RDF/XML", (String)FileUtils.guessLang("rdf.rdf", "spoo"));
        TestFileUtils.assertEquals((String)"RDF/XML", (String)FileUtils.guessLang("rdf.owl", "spoo"));
    }

    public void testMisplacedDots() {
        TestFileUtils.assertEquals((String)"spoo", (String)FileUtils.guessLang("stuff.left/right", "spoo"));
        TestFileUtils.assertEquals((String)"spoo", (String)FileUtils.guessLang("stuff.left\\right", "spoo"));
    }
}

