/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util;

import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.Locator;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocatorURL
implements Locator {
    static Log log = LogFactory.getLog((Class)LocatorURL.class);
    static final String acceptHeader = "application/rdf+xml,application/xml;q=0.9,*/*;q=0.5";

    public InputStream open(String string) {
        if (!this.hasScheme(string, "http:")) {
            if (FileManager.logAllLookups && log.isTraceEnabled()) {
                log.trace((Object)("Not found: " + string));
            }
            return null;
        }
        try {
            URL uRL = new URL(string);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestProperty("Accept", acceptHeader);
            httpURLConnection.setRequestProperty("Accept-Charset", "utf-8,*");
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(false);
            httpURLConnection.connect();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(httpURLConnection.getInputStream());
            if (bufferedInputStream == null) {
                if (FileManager.logAllLookups && log.isTraceEnabled()) {
                    log.trace((Object)("Not found: " + string));
                }
                return null;
            }
            if (FileManager.logAllLookups && log.isTraceEnabled()) {
                log.trace((Object)("Found: " + string));
            }
            return bufferedInputStream;
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (FileManager.logAllLookups && log.isTraceEnabled()) {
                log.trace((Object)("LocatorURL: not found: " + string));
            }
            return null;
        }
        catch (MalformedURLException malformedURLException) {
            log.warn((Object)("Malformed URL: " + string));
            return null;
        }
        catch (IOException iOException) {
            log.warn((Object)("IO Exception opening URL: " + string));
            return null;
        }
    }

    public String getName() {
        return "LocatorURL";
    }

    private boolean hasScheme(String string, String string2) {
        String string3 = this.getScheme(string);
        if (string3 == null) {
            return false;
        }
        return string3.equalsIgnoreCase(string2);
    }

    private String getScheme(String string) {
        int n = string.indexOf(58);
        if (n < 0) {
            return null;
        }
        return string.substring(0, n + 1);
    }
}

