/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util;

import com.hp.hpl.jena.JenaRuntime;
import com.hp.hpl.jena.reasoner.rulesys.Util;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.WrappedIOException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;

public class FileUtils {
    public static final String langXML = "RDF/XML";
    public static final String langXMLAbbrev = "RDF/XML-ABBREV";
    public static final String langNTriple = "N-TRIPLE";
    public static final String langN3 = "N3";
    public static final String langTurtle = "TURTLE";
    public static final String langBDB = "RDF/BDB";
    public static final String langSQL = "RDF/SQL";
    static Charset utf8 = null;
    private static int counter;

    public static Reader asUTF8(InputStream inputStream) {
        if (JenaRuntime.runUnder("http://jena.hpl.hp.com/2004/07/feature/noCharset")) {
            return new InputStreamReader(inputStream);
        }
        return new InputStreamReader(inputStream, utf8);
    }

    public static BufferedReader asBufferedUTF8(InputStream inputStream) {
        return new BufferedReader(FileUtils.asUTF8(inputStream));
    }

    public static Writer asUTF8(OutputStream outputStream) {
        if (JenaRuntime.runUnder("http://jena.hpl.hp.com/2004/07/feature/noCharset")) {
            return new OutputStreamWriter(outputStream);
        }
        return new OutputStreamWriter(outputStream, utf8);
    }

    public static PrintWriter asPrintWriterUTF8(OutputStream outputStream) {
        return new PrintWriter(FileUtils.asUTF8(outputStream));
    }

    public static String guessLang(String string, String string2) {
        if (string.startsWith("jdbc:") || string.startsWith("JDBC:")) {
            return langSQL;
        }
        String string3 = FileUtils.getFilenameExt(string);
        if (string3.equals("n3")) {
            return langN3;
        }
        if (string3.equals("nt")) {
            return langNTriple;
        }
        if (string3.equals("ttl")) {
            return langTurtle;
        }
        if (string3.equals("rdf")) {
            return langXML;
        }
        if (string3.equals("owl")) {
            return langXML;
        }
        return string2;
    }

    public static String guessLang(String string) {
        return FileUtils.guessLang(string, langXML);
    }

    public static String toFilename(String string) {
        if (!FileUtils.isFile(string)) {
            return null;
        }
        String string2 = string;
        if (string2.startsWith("file:")) {
            string2 = string2.substring("file:".length());
        }
        return string2;
    }

    public static boolean isFile(String string) {
        return string.startsWith("file:") || !FileUtils.isURI(string);
    }

    public static boolean isURI(String string) {
        return FileUtils.getScheme(string) != null;
    }

    public static String getScheme(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ':') {
                return string.substring(0, i);
            }
            if (!FileUtils.isASCIILetter(c)) break;
        }
        return null;
    }

    private static boolean isASCIILetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    public static String getDirname(String string) {
        File file = new File(string);
        return file.getParent();
    }

    public static String getBasename(String string) {
        File file = new File(string);
        return file.getName();
    }

    public static String getFilenameExt(String string) {
        int n = string.lastIndexOf(47);
        int n2 = string.lastIndexOf(92);
        int n4 = string.lastIndexOf(46);
        if (n2 > n) {
            n = n2;
        }
        return n4 > n ? string.substring(n4 + 1).toLowerCase() : "";
    }

    public static File tempFileName(String string, String string2) {
        File file = new File(FileUtils.getTempDirectory(), string + FileUtils.randomNumber() + string2);
        if (file.exists()) {
            return FileUtils.tempFileName(string, string2);
        }
        file.deleteOnExit();
        return file;
    }

    public static File getScratchDirectory(String string) {
        File file = new File(FileUtils.getTempDirectory(), string + FileUtils.randomNumber());
        if (file.exists()) {
            return FileUtils.getScratchDirectory(string);
        }
        if (!file.mkdir()) {
            throw new JenaException("mkdir failed on " + file);
        }
        file.deleteOnExit();
        return file;
    }

    public static String getTempDirectory() {
        return System.getProperty("java.io.tmpdir");
    }

    private static int randomNumber() {
        return ++counter;
    }

    public static BufferedReader openResourceFile(String string) {
        try {
            InputStream inputStream = FileUtils.openResourceFileAsStream(string);
            return new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        }
        catch (IOException iOException) {
            throw new WrappedIOException(iOException);
        }
    }

    public static InputStream openResourceFileAsStream(String string) throws FileNotFoundException {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(string);
        if (inputStream == null && (inputStream = Util.class.getResourceAsStream("/" + string)) == null) {
            inputStream = new FileInputStream(string);
        }
        return inputStream;
    }

    public static BufferedReader readerFromURL(String string) {
        try {
            return FileUtils.asBufferedUTF8(new URL(string).openStream());
        }
        catch (MalformedURLException malformedURLException) {
            try {
                return FileUtils.asBufferedUTF8(new FileInputStream(string));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new WrappedIOException(fileNotFoundException);
            }
        }
        catch (IOException iOException) {
            throw new WrappedIOException(iOException);
        }
    }

    public static String readWholeFileAsUTF8(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        return FileUtils.readWholeFileAsUTF8(fileInputStream);
    }

    public static String readWholeFileAsUTF8(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(FileUtils.asUTF8(inputStream), 1024);
        return FileUtils.readWholeFileAsUTF8(bufferedReader);
    }

    private static String readWholeFileAsUTF8(Reader reader) throws IOException {
        int n;
        StringWriter stringWriter = new StringWriter(1024);
        char[] cArray = new char[1024];
        while (reader.ready() && (n = reader.read(cArray)) > 0) {
            stringWriter.write(cArray, 0, n);
        }
        reader.close();
        stringWriter.close();
        return stringWriter.toString();
    }

    static {
        try {
            utf8 = Charset.forName("utf-8");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        counter = 0;
    }
}

