/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.WrappedIOException;
import com.hp.hpl.jena.util.FileUtils;
import com.hp.hpl.jena.util.LocationMapper;
import com.hp.hpl.jena.util.Locator;
import com.hp.hpl.jena.util.LocatorClassLoader;
import com.hp.hpl.jena.util.LocatorFile;
import com.hp.hpl.jena.util.LocatorURL;
import com.hp.hpl.jena.util.LocatorZip;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileManager {
    public static final String PATH_DELIMITER = ";";
    public static final String filePathSeparator = File.separator;
    static Log log = LogFactory.getLog((Class)FileManager.class);
    static FileManager instance = null;
    static boolean logAllLookups = true;
    List handlers = new ArrayList();
    LocationMapper mapper = null;
    boolean cacheModelLoads = false;
    Map modelCache = null;

    public static FileManager get() {
        if (instance == null) {
            instance = FileManager.makeGlobal();
        }
        return instance;
    }

    public FileManager() {
    }

    private static FileManager makeGlobal() {
        FileManager fileManager = new FileManager(LocationMapper.get());
        fileManager.addLocatorFile();
        fileManager.addLocatorURL();
        fileManager.addLocatorSystemClassLoader();
        return fileManager;
    }

    public FileManager(LocationMapper locationMapper) {
        this.setMapper(locationMapper);
    }

    public void setMapper(LocationMapper locationMapper) {
        this.mapper = locationMapper;
    }

    public Iterator locators() {
        return this.handlers.listIterator();
    }

    public void addLocator(Locator locator) {
        log.debug((Object)("Add location: " + locator.getName()));
        this.handlers.add(locator);
    }

    public void addLocatorFile() {
        this.addLocatorFile(null);
    }

    public void addLocatorFile(String string) {
        LocatorFile locatorFile = new LocatorFile(string);
        this.addLocator(locatorFile);
    }

    public void addLocatorSystemClassLoader() {
        this.addLocatorClassLoader(ClassLoader.getSystemClassLoader());
    }

    public void addLocatorClassLoader(ClassLoader classLoader) {
        LocatorClassLoader locatorClassLoader = new LocatorClassLoader(classLoader);
        this.addLocator(locatorClassLoader);
    }

    public void addLocatorURL() {
        LocatorURL locatorURL = new LocatorURL();
        this.addLocator(locatorURL);
    }

    public void addLocatorZip(String string) {
        LocatorZip locatorZip = new LocatorZip(string);
        this.addLocator(locatorZip);
    }

    public void remove(Locator locator) {
        this.handlers.remove(locator);
    }

    public void resetCache() {
        if (this.modelCache != null) {
            Iterator iterator = this.modelCache.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Model model = (Model)this.modelCache.remove(string);
                if (model == null) continue;
                model.close();
            }
            this.modelCache = new HashMap();
        }
    }

    public void setModelCaching(boolean bl) {
        this.cacheModelLoads = bl;
        if (this.cacheModelLoads && this.modelCache == null) {
            this.modelCache = new HashMap();
        }
    }

    public Model loadModel(String string) {
        return this.loadModel(string, null);
    }

    public Model loadModel(String string, String string2) {
        return this.loadModel(string, null, string2);
    }

    public Model loadModel(String string, String string2, String string3) {
        if (this.modelCache != null && this.modelCache.containsKey(string)) {
            log.debug((Object)("Model cache hit: " + string));
            return (Model)this.modelCache.get(string);
        }
        Model model = ModelFactory.createDefaultModel();
        this.readModel(model, string, string2, string3);
        if (this.cacheModelLoads) {
            if (this.modelCache == null) {
                this.modelCache = new HashMap();
            }
            this.modelCache.put(string, model);
        }
        return model;
    }

    public Model readModel(Model model, String string) {
        return this.readModel(model, string, null);
    }

    public Model readModel(Model model, String string, String string2) {
        return this.readModel(model, string, null, string2);
    }

    public Model readModel(Model model, String string, String string2, String string3) {
        InputStream inputStream;
        if (string2 == null) {
            string2 = this.chooseBaseURI(string);
        }
        String string4 = this.remap(string);
        if (string3 == null) {
            string3 = FileUtils.guessLang(string4);
            if (string3 == null || string3.equals("")) {
                string3 = "RDF/XML";
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Syntax guess: " + string3));
            }
        }
        if ((inputStream = this.openNoMap(string4)) == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Failed to locate '" + string4 + "'"));
            }
            throw new JenaException("Can't open: " + string);
        }
        model.read(inputStream, string2, string3);
        return model;
    }

    private String chooseBaseURI(String string) {
        String string2 = FileUtils.getScheme(string);
        if (string2 != null) {
            return string;
        }
        if (string.startsWith("/")) {
            return "file://" + string;
        }
        return "file:" + string;
    }

    public InputStream open(String string) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("open(" + string + ")"));
        }
        String string2 = this.remap(string);
        return this.openNoMap(string2);
    }

    public String remap(String string) {
        if (this.mapper == null) {
            return string;
        }
        String string2 = this.mapper.altMapping(string, null);
        if (string2 == null) {
            if (logAllLookups && log.isDebugEnabled()) {
                log.debug((Object)("Not mapped: " + string));
            }
            string2 = string;
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Mapped: " + string + " => " + string2));
        }
        return string2;
    }

    public String readWholeFileAsUTF8(InputStream inputStream) {
        try {
            int n;
            BufferedReader bufferedReader = FileUtils.asBufferedUTF8(inputStream);
            StringWriter stringWriter = new StringWriter(1024);
            char[] cArray = new char[1024];
            while (((Reader)bufferedReader).ready() && (n = bufferedReader.read(cArray)) > 0) {
                stringWriter.write(cArray, 0, n);
            }
            ((Reader)bufferedReader).close();
            stringWriter.close();
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            throw new WrappedIOException(iOException);
        }
    }

    public String readWholeFileAsUTF8(String string) {
        InputStream inputStream = this.open(string);
        return this.readWholeFileAsUTF8(inputStream);
    }

    public InputStream openNoMap(String string) {
        Iterator iterator = this.handlers.iterator();
        while (iterator.hasNext()) {
            Locator locator = (Locator)iterator.next();
            InputStream inputStream = locator.open(string);
            if (inputStream == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found: " + string + " (" + locator.getName() + ")"));
            }
            return inputStream;
        }
        return null;
    }
}

