/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.shared.test;

import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.shared.test.AbstractTestPrefixMapping;
import com.hp.hpl.jena.vocabulary.DC;
import com.hp.hpl.jena.vocabulary.JMS;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.RSS;
import com.hp.hpl.jena.vocabulary.VCARD;
import junit.framework.TestSuite;

public class TestPrefixMapping
extends AbstractTestPrefixMapping {
    public TestPrefixMapping(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestPrefixMapping.class);
    }

    protected PrefixMapping getMapping() {
        return new PrefixMappingImpl();
    }

    public void testStandard() {
        this.testStandard(PrefixMapping.Standard);
    }

    public void testExtended() {
        this.testExtended(PrefixMapping.Extended);
    }

    public void testStandard(PrefixMapping prefixMapping) {
        TestPrefixMapping.assertEquals((String)RDF.getURI(), (String)prefixMapping.getNsPrefixURI("rdf"));
        TestPrefixMapping.assertEquals((String)RDFS.getURI(), (String)prefixMapping.getNsPrefixURI("rdfs"));
        TestPrefixMapping.assertEquals((String)DC.getURI(), (String)prefixMapping.getNsPrefixURI("dc"));
        TestPrefixMapping.assertEquals((String)OWL.getURI(), (String)prefixMapping.getNsPrefixURI("owl"));
        TestPrefixMapping.assertEquals((String)"http://www.daml.org/2001/03/daml+oil#", (String)prefixMapping.getNsPrefixURI("daml"));
    }

    public void testExtended(PrefixMapping prefixMapping) {
        this.testStandard(prefixMapping);
        TestPrefixMapping.assertEquals((String)RSS.getURI(), (String)prefixMapping.getNsPrefixURI("rss"));
        TestPrefixMapping.assertEquals((String)VCARD.getURI(), (String)prefixMapping.getNsPrefixURI("vcard"));
        TestPrefixMapping.assertEquals((String)JMS.getURI(), (String)prefixMapping.getNsPrefixURI("jms"));
    }
}

