/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.transitiveReasoner;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import com.hp.hpl.jena.util.iterator.SingletonIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class TransitiveGraphCache
implements Finder {
    protected boolean cacheTriples = false;
    protected HashMap nodeMap = new HashMap();
    protected Node directPredicate;
    protected Node closedPredicate;
    protected Set deletesPending;
    protected Set originalTriples = new HashSet();

    public TransitiveGraphCache(Node node, Node node2) {
        this.directPredicate = node;
        this.closedPredicate = node2;
    }

    public Node getClosedPredicate() {
        return this.closedPredicate;
    }

    public Node getDirectPredicate() {
        return this.directPredicate;
    }

    public synchronized void addRelation(Triple triple) {
        this.originalTriples.add(triple);
        this.addRelation(triple.getSubject(), triple.getObject());
    }

    private void addRelation(Node node, Node node2) {
        GraphNode graphNode;
        if (node.equals(node2)) {
            return;
        }
        GraphNode graphNode2 = this.getLead(node);
        if (graphNode2.pathTo(graphNode = this.getLead(node2))) {
            return;
        }
        boolean bl = graphNode.pathTo(graphNode2);
        HashSet<GraphNode> hashSet = null;
        if (bl) {
            hashSet = new HashSet<GraphNode>();
            hashSet.add(graphNode);
            graphNode2.visitPredecessors(new Visitor(){

                public void visit(GraphNode graphNode, Object object, Object object2) {
                    if (((GraphNode)object2).pathTo(graphNode)) {
                        ((Set)object).add(graphNode);
                    }
                }
            }, hashSet, graphNode);
            graphNode2.makeLeadNodeFor(hashSet);
            graphNode2.propagateSCC();
        } else {
            graphNode2.propagateAdd(graphNode);
            graphNode2.assertLinkTo(graphNode);
        }
        if (bl) {
            // empty if block
        }
    }

    public void removeRelation(Triple triple) {
        GraphNode graphNode;
        Node node;
        Node node2 = triple.getSubject();
        if (node2 == (node = triple.getObject())) {
            return;
        }
        GraphNode graphNode2 = this.getLead(node2);
        if (graphNode2 != (graphNode = this.getLead(node)) && !graphNode2.directPathTo(graphNode)) {
            return;
        }
        if (this.deletesPending == null) {
            this.deletesPending = new HashSet();
        }
        this.deletesPending.add(triple);
    }

    private void processDeletes() {
        GraphNode graphNode;
        Object object;
        Object object2;
        Iterator iterator;
        HashSet<GraphNode> hashSet = new HashSet<GraphNode>();
        Object object3 = this.deletesPending.iterator();
        while (object3.hasNext()) {
            iterator = (Triple)object3.next();
            object2 = (GraphNode)this.nodeMap.get(((Triple)((Object)iterator)).getSubject());
            hashSet.add((GraphNode)object2);
        }
        object3 = new HashSet();
        object3.addAll(hashSet);
        iterator = this.nodeMap.values().iterator();
        block1: while (iterator.hasNext()) {
            object2 = (GraphNode)iterator.next();
            object = hashSet.iterator();
            while (object.hasNext()) {
                graphNode = (GraphNode)object.next();
                if (!((GraphNode)object2).pathTo(graphNode)) continue;
                object3.add(object2);
                continue block1;
            }
        }
        iterator = object3.iterator();
        while (iterator.hasNext()) {
            object2 = (GraphNode)iterator.next();
            object = ((GraphNode)object2).succ.iterator();
            while (object.hasNext()) {
                graphNode = (GraphNode)object.next();
                if (object3.contains(graphNode)) continue;
                graphNode.pred.remove(object2);
            }
            ((GraphNode)object2).succ.clear();
            ((GraphNode)object2).succClosed.clear();
            ((GraphNode)object2).pred.clear();
        }
        this.originalTriples.removeAll(this.deletesPending);
        this.deletesPending.clear();
        iterator = this.originalTriples.iterator();
        while (iterator.hasNext()) {
            object2 = (Triple)iterator.next();
            object = (GraphNode)this.nodeMap.get(((Triple)object2).getSubject());
            if (!object3.contains(object)) continue;
            this.addRelation((Triple)object2);
        }
    }

    public ExtendedIterator findWithContinuation(TriplePattern triplePattern, Finder finder) {
        Node node = triplePattern.getPredicate();
        if (node.isVariable()) {
            return this.find(triplePattern).andThen(finder.find(triplePattern));
        }
        if (node.equals(this.directPredicate) || node.equals(this.closedPredicate)) {
            return this.find(triplePattern);
        }
        return finder.find(triplePattern);
    }

    public boolean contains(TriplePattern triplePattern) {
        ExtendedIterator extendedIterator = this.find(triplePattern);
        boolean bl = extendedIterator.hasNext();
        extendedIterator.close();
        return bl;
    }

    public ExtendedIterator listAllSubjects() {
        return WrappedIterator.create(this.nodeMap.keySet().iterator());
    }

    public boolean isSubject(Node node) {
        return this.nodeMap.keySet().contains(node);
    }

    public boolean cacheAll(Finder finder, Node node) {
        ExtendedIterator extendedIterator = finder.find(new TriplePattern(null, node, null));
        boolean bl = extendedIterator.hasNext();
        while (extendedIterator.hasNext()) {
            Triple triple = (Triple)extendedIterator.next();
            this.addRelation(triple);
        }
        extendedIterator.close();
        return bl;
    }

    public ExtendedIterator find(TriplePattern triplePattern) {
        if (this.deletesPending != null && this.deletesPending.size() > 0) {
            this.processDeletes();
        }
        Node node = triplePattern.getSubject();
        Node node2 = triplePattern.getPredicate();
        Node node3 = triplePattern.getObject();
        if (node2.isVariable() || node2.equals(this.directPredicate) || node2.equals(this.closedPredicate)) {
            boolean bl = !node2.equals(this.directPredicate);
            Node node4 = this.closedPredicate;
            if (node.isVariable()) {
                if (node3.isVariable()) {
                    ExtendedIterator extendedIterator = null;
                    Iterator iterator = this.nodeMap.values().iterator();
                    while (iterator.hasNext()) {
                        ExtendedIterator extendedIterator2 = ((GraphNode)iterator.next()).listTriples(bl, this);
                        if (extendedIterator == null) {
                            extendedIterator = extendedIterator2;
                            continue;
                        }
                        extendedIterator = extendedIterator.andThen(extendedIterator2);
                    }
                    if (extendedIterator == null) {
                        return NullIterator.instance;
                    }
                    return extendedIterator;
                }
                GraphNode graphNode = (GraphNode)this.nodeMap.get(node3);
                if (graphNode == null) {
                    return NullIterator.instance;
                }
                return graphNode.listPredecessorTriples(bl, this);
            }
            GraphNode graphNode = (GraphNode)this.nodeMap.get(node);
            if (graphNode == null) {
                return NullIterator.instance;
            }
            if (node3.isVariable()) {
                return graphNode.listTriples(bl, this);
            }
            GraphNode graphNode2 = (GraphNode)this.nodeMap.get(node3);
            graphNode = graphNode.leadNode();
            if (graphNode2 == null) {
                return NullIterator.instance;
            }
            graphNode2 = graphNode2.leadNode();
            if (bl ? graphNode.pathTo(graphNode2) : graphNode.directPathTo(graphNode2)) {
                return new SingletonIterator(new Triple(node, node4, node3));
            }
            return NullIterator.instance;
        }
        return NullIterator.instance;
    }

    public TransitiveGraphCache deepCopy() {
        TransitiveGraphCache transitiveGraphCache = new TransitiveGraphCache(this.directPredicate, this.closedPredicate);
        ExtendedIterator extendedIterator = this.find(new TriplePattern(null, this.directPredicate, null));
        while (extendedIterator.hasNext()) {
            Triple triple = (Triple)extendedIterator.next();
            transitiveGraphCache.addRelation(triple.getSubject(), triple.getObject());
        }
        return transitiveGraphCache;
    }

    public void clear() {
        this.nodeMap.clear();
    }

    public void setCaching(boolean bl) {
        if (!bl && this.cacheTriples) {
            Iterator iterator = this.nodeMap.values().iterator();
            while (iterator.hasNext()) {
                ((GraphNode)iterator.next()).clearTripleCache();
            }
        }
        this.cacheTriples = bl;
    }

    public String dump() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.nodeMap.values().iterator();
        while (iterator.hasNext()) {
            GraphNode graphNode = (GraphNode)iterator.next();
            stringBuffer.append(graphNode.dump());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private GraphNode getLead(Node node) {
        GraphNode graphNode = (GraphNode)this.nodeMap.get(node);
        if (graphNode == null) {
            graphNode = new GraphNode(node);
            this.nodeMap.put(node, graphNode);
            return graphNode;
        }
        return graphNode.leadNode();
    }

    private static class GraphWalker
    extends NiceIterator
    implements ExtendedIterator {
        boolean isDeep;
        GraphNode node;
        Node root;
        Node predicate;
        Iterator iterator = null;
        Iterator aliasIterator = null;
        ArrayList nodeStack = new ArrayList();
        ArrayList iteratorStack = new ArrayList();
        Triple next;
        HashSet visited = new HashSet();

        GraphWalker(GraphNode graphNode, Node node, boolean bl, Node node2) {
            this.isDeep = bl;
            this.node = graphNode;
            this.root = node;
            this.predicate = node2;
            this.iterator = graphNode.pred.iterator();
            if (graphNode.aliases instanceof Set) {
                this.aliasIterator = ((Set)graphNode.aliases).iterator();
            }
            this.next = new Triple(this.root, node2, this.root);
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            Triple triple = this.next;
            this.walkOne();
            return triple;
        }

        /*
         * Enabled aggressive block sorting
         */
        protected void walkOne() {
            if (this.aliasIterator != null) {
                if (this.aliasIterator.hasNext()) {
                    GraphNode graphNode = (GraphNode)this.aliasIterator.next();
                    this.next = new Triple(graphNode.rdfNode, this.predicate, this.root);
                    return;
                }
                this.aliasIterator = null;
            }
            if (this.iterator.hasNext()) {
                GraphNode graphNode = (GraphNode)this.iterator.next();
                if (!this.visited.add(graphNode)) {
                    this.walkOne();
                    return;
                }
                if (this.isDeep) {
                    this.pushStack(graphNode);
                }
                this.next = new Triple(graphNode.rdfNode, this.predicate, this.root);
                if (!(graphNode.aliases instanceof Set)) return;
                this.aliasIterator = ((Set)graphNode.aliases).iterator();
                return;
            }
            if (this.nodeStack.isEmpty()) {
                this.next = null;
                return;
            }
            this.popStack();
            this.walkOne();
        }

        protected void pushStack(GraphNode graphNode) {
            this.nodeStack.add(this.node);
            this.iteratorStack.add(this.iterator);
            this.iterator = graphNode.pred.iterator();
            this.node = graphNode;
        }

        protected void popStack() {
            int n = this.nodeStack.size() - 1;
            this.iterator = (Iterator)this.iteratorStack.remove(n);
            this.node = (GraphNode)this.nodeStack.remove(n);
        }
    }

    private static class GraphNode {
        protected Node rdfNode;
        protected Set succ = new HashSet();
        protected Set pred = new HashSet();
        protected Set succClosed = new HashSet();
        protected List succClosedTriples;
        protected Object aliases;

        public GraphNode(Node node) {
            this.rdfNode = node;
        }

        public boolean pathTo(GraphNode graphNode) {
            if (this == graphNode) {
                return true;
            }
            return this.succClosed.contains(graphNode);
        }

        public boolean directPathTo(GraphNode graphNode) {
            if (this == graphNode) {
                return true;
            }
            return this.succ.contains(graphNode);
        }

        public GraphNode leadNode() {
            if (this.aliases != null && this.aliases instanceof GraphNode) {
                return ((GraphNode)this.aliases).leadNode();
            }
            return this;
        }

        public void visitPredecessors(Visitor visitor, Object object, Object object2) {
            visitor.visit(this, object, object2);
            this.doVisitPredecessors(visitor, object, object2, new HashSet());
        }

        private void doVisitPredecessors(Visitor visitor, Object object, Object object2, Set set) {
            if (set.add(this)) {
                GraphNode graphNode;
                Iterator iterator = this.pred.iterator();
                while (iterator.hasNext()) {
                    graphNode = (GraphNode)iterator.next();
                    visitor.visit(graphNode, object, object2);
                }
                iterator = this.pred.iterator();
                while (iterator.hasNext()) {
                    graphNode = (GraphNode)iterator.next();
                    graphNode.doVisitPredecessors(visitor, object, object2, set);
                }
            }
        }

        public Iterator iteratorOverSuccessors() {
            return this.succClosed.iterator();
        }

        public void assertLinkTo(GraphNode graphNode) {
            if (this == graphNode) {
                return;
            }
            this.succ.add(graphNode);
            graphNode.pred.add(this);
            this.clearTripleCache();
        }

        public void retractLinkTo(GraphNode graphNode) {
            if (this == graphNode) {
                return;
            }
            this.succ.remove(graphNode);
            graphNode.pred.remove(this);
            this.clearTripleCache();
        }

        public void assertIndirectLinkTo(GraphNode graphNode) {
            this.succClosed.add(graphNode);
            this.clearTripleCache();
        }

        public void clearTripleCache() {
            this.succClosedTriples = null;
        }

        public void propagateAdd(GraphNode graphNode) {
            Set set = graphNode.succClosed;
            this.visitPredecessors(new Visitor(){

                public void visit(GraphNode graphNode, Object object, Object object2) {
                    Set set = (Set)object;
                    graphNode.succClosed.addAll(set);
                    graphNode.succClosed.add(object2);
                    Iterator iterator = graphNode.succ.iterator();
                    while (iterator.hasNext()) {
                        GraphNode graphNode2 = (GraphNode)iterator.next();
                        if (!set.contains(graphNode2)) continue;
                        iterator.remove();
                        graphNode2.pred.remove(graphNode);
                    }
                }
            }, set, graphNode);
        }

        public void propagateSCC() {
            HashSet<GraphNode> hashSet = new HashSet<GraphNode>();
            hashSet.add(this);
            this.doVisitPredecessors(new Visitor(){

                public void visit(GraphNode graphNode, Object object, Object object2) {
                    Set set = (Set)object;
                    graphNode.succClosed.addAll(set);
                    Iterator iterator = graphNode.succ.iterator();
                    while (iterator.hasNext()) {
                        GraphNode graphNode2 = (GraphNode)iterator.next();
                        if (!set.contains(graphNode2)) continue;
                        iterator.remove();
                        graphNode2.pred.remove(graphNode);
                    }
                }
            }, this.succClosed, null, hashSet);
        }

        public void makeLeadNodeFor(Set set) {
            GraphNode graphNode;
            Object object;
            HashSet hashSet = new HashSet();
            HashSet hashSet2 = new HashSet();
            Object object2 = set.iterator();
            while (object2.hasNext()) {
                object = (GraphNode)object2.next();
                hashSet.addAll(((GraphNode)object).succ);
                hashSet2.addAll(((GraphNode)object).succClosed);
            }
            hashSet.removeAll(set);
            hashSet2.removeAll(set);
            this.succ = hashSet;
            this.succClosed = hashSet2;
            object2 = this.succ.iterator();
            while (object2.hasNext()) {
                object = (GraphNode)object2.next();
                ((GraphNode)object).pred.removeAll(set);
                ((GraphNode)object).pred.add(this);
            }
            object2 = new HashSet();
            object = new HashSet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                graphNode = (GraphNode)iterator.next();
                if (graphNode.aliases instanceof Set) {
                    object.addAll((Set)graphNode.aliases);
                    continue;
                }
                object.add(graphNode);
            }
            this.aliases = object;
            iterator = set.iterator();
            while (iterator.hasNext()) {
                graphNode = (GraphNode)iterator.next();
                if (graphNode == this) continue;
                this.pred.addAll(graphNode.pred);
                graphNode.relocateAllRefTo(this, (Set)object2);
                graphNode.aliases = this;
            }
            this.pred.removeAll(set);
        }

        private void relocateAllRefTo(GraphNode graphNode, Set set) {
            this.visitPredecessors(new Visitor(){

                public void visit(GraphNode graphNode, Object object, Object object2) {
                    if (((Set)object).add(graphNode)) {
                        GraphNode graphNode2 = (GraphNode)object2;
                        Set set = (Set)graphNode2.aliases;
                        int n = graphNode.succ.size();
                        graphNode.succ.removeAll(set);
                        graphNode.succClosed.removeAll(set);
                        graphNode.succClosed.add(graphNode2);
                        if (graphNode.succ.size() != n) {
                            graphNode.succ.add(graphNode2);
                        }
                    }
                }
            }, set, graphNode);
        }

        public ExtendedIterator listTriples(boolean bl, TransitiveGraphCache transitiveGraphCache) {
            if (transitiveGraphCache.cacheTriples) {
                return WrappedIterator.create(this.leadNode().triplesForSuccessors(this.rdfNode, bl, transitiveGraphCache).iterator());
            }
            return WrappedIterator.create(this.leadNode().triplesForSuccessors(this.rdfNode, bl, transitiveGraphCache).iterator());
        }

        private List triplesForSuccessors(Node node, boolean bl, TransitiveGraphCache transitiveGraphCache) {
            Set set = bl ? this.succClosed : this.succ;
            ArrayList<Triple> arrayList = new ArrayList<Triple>(set.size() + 10);
            arrayList.add(new Triple(node, transitiveGraphCache.closedPredicate, node));
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                GraphNode graphNode = (GraphNode)iterator.next();
                arrayList.add(new Triple(node, transitiveGraphCache.closedPredicate, graphNode.rdfNode));
                if (!(graphNode.aliases instanceof Set)) continue;
                Iterator iterator2 = ((Set)graphNode.aliases).iterator();
                while (iterator2.hasNext()) {
                    arrayList.add(new Triple(node, transitiveGraphCache.closedPredicate, ((GraphNode)iterator2.next()).rdfNode));
                }
            }
            if (this.aliases instanceof Set) {
                iterator = ((Set)this.aliases).iterator();
                while (iterator.hasNext()) {
                    arrayList.add(new Triple(node, transitiveGraphCache.closedPredicate, ((GraphNode)iterator.next()).rdfNode));
                }
            }
            return arrayList;
        }

        public ExtendedIterator listPredecessorTriples(boolean bl, TransitiveGraphCache transitiveGraphCache) {
            return new GraphWalker(this.leadNode(), this.rdfNode, bl, transitiveGraphCache.closedPredicate);
        }

        public String toString() {
            return "[" + this.rdfNode.getLocalName() + "]";
        }

        public String dump() {
            String string = this.rdfNode.getLocalName();
            if (this.aliases != null) {
                string = this.aliases instanceof GraphNode ? string + " leader=" + this.aliases + ", " : string + " SCC=" + this.dumpSet((Set)this.aliases) + ", ";
            }
            return string + " succ=" + this.dumpSet(this.succ) + ", succClose=" + this.dumpSet(this.succClosed) + ", pred=" + this.dumpSet(this.pred);
        }

        private String dumpSet(Set set) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{");
            boolean bl = false;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                stringBuffer.append(iterator.next().toString());
            }
            stringBuffer.append("}");
            return stringBuffer.toString();
        }
    }

    static interface Visitor {
        public void visit(GraphNode var1, Object var2, Object var3);
    }
}

