/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.transitiveReasoner;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.FGraph;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.FinderUtil;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveGraphCache;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveReasoner;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.HashSet;

public class TransitiveEngine {
    protected TransitiveGraphCache subClassCache;
    protected TransitiveGraphCache subPropertyCache;
    protected Finder data;
    protected boolean isPrepared = false;
    protected static HashSet subClassAliases;
    protected static HashSet subPropertyAliases;
    private static final int NOT_RELEVANT = 1;
    private static final int SUBCLASS = 2;
    private static final int SUBPROPERTY = 4;
    private static final int UPDATE_MASK = 6;
    private static final int REBUILD_SUBCLASS = 8;
    private static final int REBUILD_SUBPROPERTY = 16;
    public static Node directSubPropertyOf;
    public static Node directSubClassOf;
    public static Node subPropertyOf;
    public static Node subClassOf;

    public TransitiveEngine(TransitiveGraphCache transitiveGraphCache, TransitiveGraphCache transitiveGraphCache2) {
        this.subClassCache = transitiveGraphCache;
        this.subPropertyCache = transitiveGraphCache2;
    }

    public TransitiveEngine(TransitiveEngine transitiveEngine) {
        this.subClassCache = transitiveEngine.getSubClassCache().deepCopy();
        this.subPropertyCache = transitiveEngine.getSubPropertyCache().deepCopy();
    }

    public Finder insert(Finder finder, FGraph fGraph) {
        Graph graph = fGraph.getGraph();
        this.data = finder != null ? FinderUtil.cascade(finder, fGraph) : fGraph;
        if (TransitiveEngine.checkOccuranceUtility(subPropertyOf, graph, this.subPropertyCache) || TransitiveEngine.checkOccuranceUtility(subClassOf, graph, this.subPropertyCache)) {
            this.subClassCache = new TransitiveGraphCache(directSubClassOf, subClassOf);
            this.subPropertyCache = new TransitiveGraphCache(directSubPropertyOf, subPropertyOf);
            TransitiveEngine.cacheSubPropUtility(this.data, this.subPropertyCache);
            TransitiveEngine.cacheSubClassUtility(this.data, this.subPropertyCache, this.subClassCache);
        }
        return this.data;
    }

    public TransitiveGraphCache getSubClassCache() {
        return this.subClassCache;
    }

    public TransitiveGraphCache getSubPropertyCache() {
        return this.subPropertyCache;
    }

    public void setCaching(boolean bl, boolean bl2) {
        this.subPropertyCache.setCaching(bl);
        this.subClassCache.setCaching(bl2);
    }

    private void prepare() {
        if (this.isPrepared) {
            return;
        }
        subClassAliases = new HashSet();
        subClassAliases.add(subClassOf);
        subClassAliases.add(directSubClassOf);
        subPropertyAliases = new HashSet();
        subPropertyAliases.add(subPropertyOf);
        subPropertyAliases.add(directSubPropertyOf);
        ExtendedIterator extendedIterator = this.subPropertyCache.find(new TriplePattern(null, subPropertyOf, subPropertyOf));
        while (extendedIterator.hasNext()) {
            Triple triple = (Triple)extendedIterator.next();
            Node node = triple.getSubject();
            subPropertyAliases.add(node);
            ExtendedIterator extendedIterator2 = this.subPropertyCache.find(new TriplePattern(null, node, subClassOf));
            while (extendedIterator2.hasNext()) {
                subClassAliases.add(((Triple)extendedIterator2.next()).getObject());
            }
        }
        this.isPrepared = true;
    }

    private int triage(Triple triple) {
        Node node;
        if (!this.isPrepared) {
            this.prepare();
        }
        if (subClassAliases.contains(node = triple.getPredicate())) {
            return 2;
        }
        if (subPropertyAliases.contains(node)) {
            Node node2 = triple.getObject();
            if (subClassAliases.contains(node2)) {
                return 12;
            }
            if (subPropertyAliases.contains(node2)) {
                return 24;
            }
            return 4;
        }
        return 1;
    }

    public Finder getFinder(TriplePattern triplePattern, Finder finder) {
        Node node;
        if (!this.isPrepared) {
            this.prepare();
        }
        if ((node = triplePattern.getPredicate()).isVariable()) {
            return FinderUtil.cascade(this.subPropertyCache, this.subClassCache, finder);
        }
        if (subPropertyAliases.contains(node)) {
            return this.subPropertyCache;
        }
        if (subClassAliases.contains(node)) {
            return this.subClassCache;
        }
        return finder;
    }

    public synchronized boolean add(Triple triple) {
        int n = this.triage(triple);
        switch (n & 6) {
            case 2: {
                this.subClassCache.addRelation(triple);
                break;
            }
            case 4: {
                this.subPropertyCache.addRelation(triple);
                break;
            }
            case 1: {
                return false;
            }
        }
        if ((n & 0x10) != 0) {
            TransitiveEngine.cacheSubPropUtility(this.data, this.subPropertyCache);
            this.isPrepared = false;
        }
        if ((n & 8) != 0) {
            TransitiveEngine.cacheSubClassUtility(this.data, this.subPropertyCache, this.subClassCache);
            this.isPrepared = false;
        }
        return true;
    }

    public synchronized boolean delete(Triple triple) {
        int n = this.triage(triple);
        switch (n & 6) {
            case 2: {
                this.subClassCache.removeRelation(triple);
                break;
            }
            case 4: {
                this.subPropertyCache.removeRelation(triple);
                break;
            }
            case 1: {
                return false;
            }
        }
        if ((n & 0x10) != 0) {
            this.subPropertyCache.clear();
            TransitiveEngine.cacheSubPropUtility(this.data, this.subPropertyCache);
            this.isPrepared = false;
        }
        if ((n & 8) != 0) {
            this.subClassCache.clear();
            TransitiveEngine.cacheSubClassUtility(this.data, this.subPropertyCache, this.subClassCache);
            this.isPrepared = false;
        }
        return true;
    }

    public boolean checkOccurance(Node node, Graph graph) {
        return TransitiveEngine.checkOccuranceUtility(node, graph, this.subPropertyCache);
    }

    public static boolean cacheSubClassUtility(Finder finder, TransitiveGraphCache transitiveGraphCache, TransitiveGraphCache transitiveGraphCache2) {
        if (finder == null) {
            return false;
        }
        transitiveGraphCache2.cacheAll(finder, TransitiveReasoner.subClassOf);
        boolean bl = false;
        ExtendedIterator extendedIterator = transitiveGraphCache.find(new TriplePattern(null, TransitiveReasoner.subPropertyOf, TransitiveReasoner.subClassOf));
        while (extendedIterator.hasNext()) {
            bl = true;
            Triple triple = (Triple)extendedIterator.next();
            Node node = triple.getSubject();
            if (node.equals(TransitiveReasoner.subClassOf)) continue;
            transitiveGraphCache2.cacheAll(finder, node);
        }
        return bl;
    }

    public static boolean checkOccuranceUtility(Node node, Graph graph, TransitiveGraphCache transitiveGraphCache) {
        boolean bl = false;
        ExtendedIterator extendedIterator = graph.find(null, node, null);
        bl = extendedIterator.hasNext();
        extendedIterator.close();
        if (bl) {
            return bl;
        }
        ExtendedIterator extendedIterator2 = transitiveGraphCache.find(new TriplePattern(null, TransitiveReasoner.subPropertyOf, node));
        while (extendedIterator2.hasNext() && !bl) {
            Triple triple = (Triple)extendedIterator2.next();
            Node node2 = triple.getSubject();
            extendedIterator = graph.find(null, node2, null);
            bl = extendedIterator.hasNext();
            extendedIterator.close();
        }
        extendedIterator2.close();
        return bl;
    }

    public static boolean cacheSubPropUtility(Finder finder, TransitiveGraphCache transitiveGraphCache) {
        if (finder == null) {
            return false;
        }
        transitiveGraphCache.cacheAll(finder, TransitiveReasoner.subPropertyOf);
        boolean bl = false;
        boolean bl2 = false;
        HashSet<Node> hashSet = new HashSet<Node>();
        do {
            ExtendedIterator extendedIterator = transitiveGraphCache.find(new TriplePattern(null, TransitiveReasoner.subPropertyOf, TransitiveReasoner.subPropertyOf));
            while (extendedIterator.hasNext()) {
                bl2 = false;
                Triple triple = (Triple)extendedIterator.next();
                Node node = triple.getSubject();
                if (node.equals(TransitiveReasoner.subPropertyOf) || hashSet.contains(node)) continue;
                bl = true;
                hashSet.add(node);
                transitiveGraphCache.cacheAll(finder, node);
                bl2 = true;
            }
        } while (bl2);
        return bl;
    }

    static {
        directSubPropertyOf = TransitiveReasoner.directSubPropertyOf;
        directSubClassOf = TransitiveReasoner.directSubClassOf;
        subPropertyOf = RDFS.subPropertyOf.getNode();
        subClassOf = RDFS.subClassOf.getNode();
    }
}

