/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.rdfsReasoner1.RDFSReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.RDFSFBRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.RDFSRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.test.ReasonerTester;
import com.hp.hpl.jena.util.ModelLoader;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.IOException;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestRDFSRules
extends TestCase {
    public static final String NAMESPACE = "http://www.hpl.hp.com/semweb/2003/query_tester/";
    protected static Log logger = LogFactory.getLog((Class)TestRDFSRules.class);

    public TestRDFSRules(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestRDFSRules.class);
    }

    public void hiddenTestRDFSReasonerDebug() throws IOException {
        ReasonerTester reasonerTester = new ReasonerTester("rdfs/manifest-nodirect-noresource.rdf");
        ReasonerFactory reasonerFactory = RDFSRuleReasonerFactory.theInstance();
        TestRDFSRules.assertTrue((String)"RDFS hybrid-tgc reasoner test", (boolean)reasonerTester.runTest("http://www.hpl.hp.com/semweb/2003/query_tester/rdfs/test11", reasonerFactory, this, null));
    }

    public void testRDFSFBReasoner() throws IOException {
        ReasonerTester reasonerTester = new ReasonerTester("rdfs/manifest-nodirect-noresource.rdf");
        ReasonerFactory reasonerFactory = RDFSFBRuleReasonerFactory.theInstance();
        TestRDFSRules.assertTrue((String)"RDFS hybrid reasoner tests", (boolean)reasonerTester.runTests(reasonerFactory, this, null));
    }

    public void testRDFSExptReasoner() throws IOException {
        ReasonerTester reasonerTester = new ReasonerTester("rdfs/manifest-nodirect-noresource.rdf");
        ReasonerFactory reasonerFactory = RDFSRuleReasonerFactory.theInstance();
        TestRDFSRules.assertTrue((String)"RDFS experimental (hybrid+tgc) reasoner tests", (boolean)reasonerTester.runTests(reasonerFactory, this, null));
    }

    public void testRDFSDescription() {
        ReasonerFactory reasonerFactory = RDFSFBRuleReasonerFactory.theInstance();
        Reasoner reasoner = reasonerFactory.create(null);
        TestRDFSRules.assertTrue((boolean)reasoner.supportsProperty(RDFS.subClassOf));
        TestRDFSRules.assertTrue((boolean)reasoner.supportsProperty(RDFS.domain));
        TestRDFSRules.assertTrue((!reasoner.supportsProperty(OWL.allValuesFrom) ? 1 : 0) != 0);
    }

    private static void doTiming(Reasoner reasoner, Model model, Model model2, String string, int n) {
        Resource resource = ResourceFactory.createResource("http://www.hpl.hp.com/semweb/2003/eg#C1");
        Resource resource2 = ResourceFactory.createResource("http://www.hpl.hp.com/semweb/2003/eg#C2");
        long l = System.currentTimeMillis();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Model model3 = ModelFactory.createModelForGraph(reasoner.bindSchema(model.getGraph()).bind(model2.getGraph()));
            n2 = 0;
            StmtIterator stmtIterator = model3.listStatements(null, RDF.type, resource);
            while (stmtIterator.hasNext()) {
                ++n2;
                stmtIterator.next();
            }
        }
        long l2 = System.currentTimeMillis();
        long l3 = (l2 - l) * 10L / (long)n;
        long l4 = l3 / 10L;
        long l5 = l3 - l4 * 10L;
        System.out.println(string + ": " + n2 + " results in " + l4 + "." + l5 + "ms");
    }

    public static void main(String[] stringArray) {
        try {
            Model model = ModelLoader.loadModel("testing/reasoners/rdfs/timing-tbox.rdf");
            Model model2 = ModelLoader.loadModel("testing/reasoners/rdfs/timing-data.rdf");
            Reasoner reasoner = RDFSFBRuleReasonerFactory.theInstance().create(null);
            Reasoner reasoner2 = RDFSReasonerFactory.theInstance().create(null);
            Reasoner reasoner3 = RDFSRuleReasonerFactory.theInstance().create(null);
            TestRDFSRules.doTiming(reasoner2, model, model2, "RDFS1", 1);
            TestRDFSRules.doTiming(reasoner, model, model2, "RDFS FB rule", 1);
            TestRDFSRules.doTiming(reasoner3, model, model2, "RDFS final rule", 1);
            TestRDFSRules.doTiming(reasoner2, model, model2, "RDFS1", 50);
            TestRDFSRules.doTiming(reasoner, model, model2, "RDFS FB rule", 50);
            TestRDFSRules.doTiming(reasoner3, model, model2, "RDFS final rule", 50);
        }
        catch (Exception exception) {
            System.out.println("Problem: " + exception.toString());
            exception.printStackTrace();
        }
    }
}

