/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.daml.DAMLModel;
import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.reasoner.ValidityReport;
import com.hp.hpl.jena.reasoner.rulesys.DAMLMicroReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.test.TestUtil;
import com.hp.hpl.jena.util.ModelLoader;
import com.hp.hpl.jena.util.PrintUtil;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.ByteArrayInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestBugs
extends TestCase {
    public static final String INPUT_SUBCLASS = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><rdf:RDF    xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"    xmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\"    xmlns:daml=\"http://www.daml.org/2001/03/daml+oil#\"    xmlns:ex=\"http://localhost:8080/axis/daml/a.daml#\"    xml:base=\"http://localhost:8080/axis/daml/a.daml\">     <daml:Ontology rdf:about=\"\">        <daml:imports rdf:resource=\"http://www.daml.org/2001/03/daml+oil\"/>    </daml:Ontology>     <daml:Class rdf:ID=\"cls1\"/>    <daml:Class rdf:ID=\"cls2\">        <daml:subClassOf rdf:resource=\"#cls1\"/>    </daml:Class>    <ex:cls2 rdf:ID=\"test\"/></rdf:RDF>";
    public static final String INPUT_SUBPROPERTY = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><rdf:RDF    xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"    xmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\"    xmlns:daml=\"http://www.daml.org/2001/03/daml+oil#\"    xmlns=\"urn:x-hp-jena:test#\"    xml:base=\"urn:x-hp-jena:test\">     <daml:Ontology rdf:about=\"\">        <daml:imports rdf:resource=\"http://www.daml.org/2001/03/daml+oil\"/>    </daml:Ontology>     <daml:Class rdf:ID=\"A\"/>    <daml:ObjectProperty rdf:ID=\"p\" />    <daml:ObjectProperty rdf:ID=\"q\">        <daml:subPropertyOf rdf:resource=\"#p\"/>    </daml:ObjectProperty>    <A rdf:ID=\"a0\"/>    <A rdf:ID=\"a1\">       <q rdf:resource=\"#a0\" />    </A></rdf:RDF>";

    public TestBugs(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestBugs.class);
    }

    public void setUp() {
        OntDocumentManager.getInstance().reset(true);
    }

    public void testIntersectionNPE() {
        Model model = ModelFactory.createDefaultModel();
        model.read("file:testing/reasoners/bugs/bad-intersection.owl");
        boolean bl = false;
        try {
            InfGraph infGraph = ReasonerRegistry.getOWLReasoner().bind(model.getGraph());
            ExtendedIterator extendedIterator = infGraph.find(null, RDF.Nodes.type, OWL.Class.asNode());
            extendedIterator.close();
        }
        catch (ReasonerException reasonerException) {
            bl = true;
        }
        TestBugs.assertTrue((String)"Correctly detected the illegal list", (boolean)bl);
    }

    public void testCardinality1() {
        Model model = ModelFactory.createDefaultModel();
        model.read("file:testing/reasoners/bugs/cardFPTest.owl");
        InfModel infModel = ModelFactory.createInfModel(ReasonerRegistry.getOWLReasoner(), model);
        String string = "urn:foo#";
        Resource resource = infModel.getResource(string + "aDocument");
        Resource resource2 = infModel.getResource(string + "Document");
        TestBugs.assertTrue((String)"Cardinality-based classification", (boolean)infModel.contains(resource, RDF.type, resource2));
    }

    public void testFunctorCCE() {
        Model model = ModelFactory.createDefaultModel();
        model.read("file:testing/reasoners/bugs/cceTest.owl");
        InfModel infModel = ModelFactory.createInfModel(ReasonerRegistry.getOWLReasoner(), model);
        boolean bl = this.anyInstancesOfNothing(infModel);
        ResIterator resIterator = infModel.listSubjects();
        while (resIterator.hasNext()) {
            Resource resource = resIterator.nextResource();
        }
    }

    private boolean anyInstancesOfNothing(Model model) {
        boolean bl = false;
        try {
            StmtIterator stmtIterator = model.listStatements(null, RDF.type, OWL.Nothing);
            bl = stmtIterator.hasNext();
            stmtIterator.close();
        }
        catch (ConversionException conversionException) {
            bl = false;
        }
        return bl;
    }

    public void testDAMLCCE() {
        DAMLModel dAMLModel = ModelFactory.createDAMLModel();
        dAMLModel.getDocumentManager().setMetadataSearchPath("file:etc/ont-policy-test.rdf", true);
        dAMLModel.read("file:testing/reasoners/bugs/literalLeak.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        ResIterator resIterator = dAMLModel.listSubjects();
        while (resIterator.hasNext()) {
            Resource resource = resIterator.nextResource();
            if (!resource.getNode().isLiteral()) continue;
            TestBugs.assertTrue((String)("Error in resource " + resource), (boolean)false);
        }
    }

    public void testSubClass() {
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.DAML_MEM_RDFS_INF, null);
        ontModel.getDocumentManager().setMetadataSearchPath("file:etc/ont-policy-test.rdf", true);
        String string = "http://localhost:8080/axis/daml/a.daml#";
        ontModel.read(new ByteArrayInputStream(INPUT_SUBCLASS.getBytes()), string);
        OntResource ontResource = (OntResource)ontModel.getResource(string + "test").as(OntResource.class);
        OntClass ontClass = (OntClass)ontModel.getResource(string + "cls1").as(OntClass.class);
        OntClass ontClass2 = (OntClass)ontModel.getResource(string + "cls2").as(OntClass.class);
        TestBugs.assertTrue((String)"cls2 should be a super-class of cls1", (boolean)ontClass2.hasSuperClass(ontClass));
        TestBugs.assertTrue((String)"res should have rdf:type cls1", (boolean)ontResource.hasRDFType(ontClass));
        TestBugs.assertTrue((String)"res should have rdf:type cls2", (boolean)ontResource.hasRDFType(ontClass2));
    }

    public void testSubProperty() {
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.DAML_MEM_RDFS_INF, null);
        String string = "urn:x-hp-jena:test#";
        ontModel.read(new ByteArrayInputStream(INPUT_SUBPROPERTY.getBytes()), string);
        OntResource ontResource = (OntResource)ontModel.getResource(string + "a0").as(OntResource.class);
        OntResource ontResource2 = (OntResource)ontModel.getResource(string + "a1").as(OntResource.class);
        ObjectProperty objectProperty = ontModel.getObjectProperty(string + "p");
        ObjectProperty objectProperty2 = ontModel.getObjectProperty(string + "q");
        TestBugs.assertTrue((String)"subProp relation present", (boolean)objectProperty2.hasProperty(RDFS.subPropertyOf, objectProperty));
        TestBugs.assertTrue((String)"a1 q a0", (boolean)ontResource2.hasProperty((Property)objectProperty2, ontResource));
        TestBugs.assertTrue((String)"a1 p a0", (boolean)ontResource2.hasProperty((Property)objectProperty, ontResource));
    }

    public void testEquivalentClass1() {
        Model model = ModelFactory.createDefaultModel();
        model.read("file:testing/reasoners/bugs/equivalentClassTest.owl");
        InfModel infModel = ModelFactory.createInfModel(ReasonerRegistry.getOWLReasoner(), model);
        String string = "urn:foo#";
        Resource resource = infModel.getResource(string + "A");
        Resource resource2 = infModel.getResource(string + "B");
        TestBugs.assertTrue((String)"hasValue equiv deduction", (boolean)infModel.contains(resource, OWL.equivalentClass, resource2));
    }

    public void testOWLPropertyAxioms() {
        Model model = ModelFactory.createDefaultModel();
        Resource resource = model.createResource("urn:x-hp:eg/fp");
        Resource resource2 = model.createResource("urn:x-hp:eg/ifp");
        Resource resource3 = model.createResource("urn:x-hp:eg/tp");
        Resource resource4 = model.createResource("urn:x-hp:eg/sp");
        model.add(resource, RDF.type, OWL.FunctionalProperty);
        model.add(resource2, RDF.type, OWL.InverseFunctionalProperty);
        model.add(resource3, RDF.type, OWL.TransitiveProperty);
        model.add(resource4, RDF.type, OWL.SymmetricProperty);
        InfModel infModel = ModelFactory.createInfModel(ReasonerRegistry.getOWLReasoner(), model);
        TestBugs.assertTrue((String)"property class axioms", (boolean)infModel.contains(resource, RDF.type, RDF.Property));
        TestBugs.assertTrue((String)"property class axioms", (boolean)infModel.contains(resource2, RDF.type, RDF.Property));
        TestBugs.assertTrue((String)"property class axioms", (boolean)infModel.contains(resource3, RDF.type, RDF.Property));
        TestBugs.assertTrue((String)"property class axioms", (boolean)infModel.contains(resource4, RDF.type, RDF.Property));
        TestBugs.assertTrue((String)"property class axioms", (boolean)infModel.contains(resource2, RDF.type, OWL.ObjectProperty));
        TestBugs.assertTrue((String)"property class axioms", (boolean)infModel.contains(resource3, RDF.type, OWL.ObjectProperty));
        TestBugs.assertTrue((String)"property class axioms", (boolean)infModel.contains(resource4, RDF.type, OWL.ObjectProperty));
    }

    public void testDeleteBug() {
        Model model = ModelFactory.createDefaultModel();
        model.read("file:testing/reasoners/bugs/deleteBug.owl");
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM_RULE_INF, model);
        Individual individual = ontModel.getIndividual("http://decsai.ugr.es/~ontoserver/bacarex2.owl#JS");
        individual.remove();
        StmtIterator stmtIterator = ontModel.listStatements((Resource)individual, null, (RDFNode)null);
        boolean bl = !stmtIterator.hasNext();
        stmtIterator.close();
        TestBugs.assertTrue((boolean)bl);
    }

    public void hiddenTestOWLLoop() {
        Model model = ModelLoader.loadModel("file:testing/reasoners/bugs/loop.owl");
        InfModel infModel = ModelFactory.createInfModel(ReasonerRegistry.getOWLReasoner(), model);
        ((FBRuleInfGraph)infModel.getGraph()).setTraceOn(true);
        String string = "http://jena.hpl.hp.com/eg#";
        Resource resource = infModel.getResource(string + "C");
        Resource resource2 = infModel.getResource(string + "i");
        Property property = infModel.getProperty(string, "R");
        System.out.println("Check that the instance does have an R property");
        Statement statement = resource2.getProperty(property);
        System.out.println(" - " + statement);
        System.out.println("And that the type of the R property is C");
        Statement statement2 = ((Resource)statement.getObject()).getProperty(RDF.type);
        System.out.println(" - " + statement2);
        System.out.println("But does that have an R property?");
        Statement statement3 = ((Resource)statement.getObject()).getProperty(property);
        System.out.println(" - " + statement3);
        System.out.println("List all instances of C");
        int n = 0;
        StmtIterator stmtIterator = infModel.listStatements(null, RDF.type, resource);
        while (stmtIterator.hasNext()) {
            Statement statement4 = (Statement)stmtIterator.next();
            System.out.println(" - " + statement4);
            ++n;
        }
        System.out.println("OK");
    }

    public void testRangeBug() {
        Model model = ModelLoader.loadModel("file:testing/reasoners/bugs/rangeBug.owl");
        Model model2 = ModelFactory.createDefaultModel();
        Reasoner reasoner = ReasonerRegistry.getOWLReasoner();
        InfModel infModel = ModelFactory.createInfModel(reasoner, model);
        String string = "http://decsai.ugr.es/~ontoserver/bacarex2.owl#";
        Resource resource = infModel.getResource(string + "JS");
        Resource resource2 = infModel.getResource(string + "surname");
        Statement statement = infModel.createStatement(resource2, RDFS.range, OWL.Nothing);
        TestBugs.assertTrue((!infModel.contains(statement) ? 1 : 0) != 0);
    }

    public void testLiteralBug() {
        Model model = ModelLoader.loadModel("file:testing/reasoners/bugs/dtValidation.owl");
        Model model2 = ModelFactory.createDefaultModel();
        Reasoner reasoner = ReasonerRegistry.getOWLReasoner();
        InfModel infModel = ModelFactory.createInfModel(reasoner, model);
        ValidityReport validityReport = infModel.validate();
        TestBugs.assertTrue((boolean)validityReport.isValid());
    }

    public void testHide() {
        String string = "http://jena.hpl.hp.com/bugs#";
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM_RULE_INF, null);
        OntClass ontClass = ontModel.createClass(string + "C");
        Individual individual = ontModel.createIndividual(ontClass);
        StmtIterator stmtIterator = ontModel.listStatements(null, RDF.type, ontClass);
        TestUtil.assertIteratorValues(this, stmtIterator, new Statement[]{ontModel.createStatement((Resource)individual, RDF.type, ontClass)});
    }

    public void testBindSchemaValidate() {
        Reasoner reasoner = ReasonerRegistry.getOWLReasoner();
        Model model = ModelLoader.loadModel("file:testing/reasoners/bugs/sbug.owl");
        Model model2 = ModelLoader.loadModel("file:testing/reasoners/bugs/sbug.rdf");
        InfModel infModel = ModelFactory.createInfModel(reasoner, model2.union(model));
        ValidityReport validityReport = infModel.validate();
        TestBugs.assertTrue((!validityReport.isValid() ? 1 : 0) != 0);
        InfModel infModel2 = ModelFactory.createInfModel(reasoner.bindSchema(model), model2);
        validityReport = infModel2.validate();
        TestBugs.assertTrue((!validityReport.isValid() ? 1 : 0) != 0);
    }

    public void testGenericDeleteBug() {
        Model model = ModelFactory.createDefaultModel();
        String string = "urn:x-hp:eg/";
        Property property = model.createProperty(string, "p");
        Resource resource = model.createResource(string + "x");
        Resource resource2 = model.createResource(string + "y");
        Statement statement = model.createStatement(resource2, property, "foo");
        model.add(statement);
        model.add(resource, property, "foo");
        String string2 = "[(?x eg:p ?m) (?y eg:p ?m) -> (?x eg:same ?y) (?y eg:same ?x)]";
        GenericRuleReasoner genericRuleReasoner = (GenericRuleReasoner)GenericRuleReasonerFactory.theInstance().create(null);
        genericRuleReasoner.setMode(GenericRuleReasoner.FORWARD_RETE);
        genericRuleReasoner.setRules(Rule.parseRules(string2));
        InfModel infModel = ModelFactory.createInfModel(genericRuleReasoner, model);
        TestUtil.assertIteratorLength(infModel.listStatements(resource2, null, (RDFNode)null), 3);
        infModel.remove(statement);
        TestUtil.assertIteratorLength(infModel.listStatements(resource2, null, (RDFNode)null), 0);
    }

    public void testRETEInc() {
        String string = "(?x ?p ?y) -> (?p rdf:type rdf:Property) .";
        GenericRuleReasoner genericRuleReasoner = new GenericRuleReasoner(Rule.parseRules(string));
        InfModel infModel = ModelFactory.createInfModel(genericRuleReasoner, ModelFactory.createDefaultModel());
        Resource resource = infModel.createResource("urn:alfie:testResource");
        Property property = infModel.createProperty("urn:alfie:testProperty");
        Statement statement = infModel.createStatement(resource, property, "value1");
        Statement statement2 = infModel.createStatement(resource, property, "value2");
        infModel.add(statement);
        this.assertIsProperty(infModel, property);
        infModel.add(statement2);
        infModel.remove(statement);
        this.assertIsProperty(infModel, property);
    }

    public void testRETEDec() {
        String string = "(?x ?p ?y) -> (?p rdf:type rdf:Property) .";
        GenericRuleReasoner genericRuleReasoner = new GenericRuleReasoner(Rule.parseRules(string));
        InfModel infModel = ModelFactory.createInfModel(genericRuleReasoner, ModelFactory.createDefaultModel());
        Resource resource = infModel.createResource("urn:alfie:testResource");
        Property property = infModel.createProperty("urn:alfie:testProperty");
        Statement statement = infModel.createStatement(resource, property, "value1");
        Statement statement2 = infModel.createStatement(resource, property, "value2");
        infModel.add((Resource)property, RDF.type, RDF.Property);
        infModel.add(statement);
        infModel.prepare();
        infModel.remove(statement);
        this.assertIsProperty(infModel, property);
    }

    private void assertIsProperty(Model model, Property property) {
        TestBugs.assertTrue((boolean)model.contains((Resource)property, RDF.type, RDF.Property));
    }

    public void testHideOnOWLThing() {
        Reasoner reasoner = ReasonerRegistry.getOWLReasoner();
        Model model = ModelFactory.createDefaultModel();
        InfModel infModel = ModelFactory.createInfModel(reasoner, model);
        StmtIterator stmtIterator = infModel.listStatements(null, RDF.type, OWL.Thing);
        TestUtil.assertIteratorLength(stmtIterator, 0);
    }

    public void testSomeDatatype() throws IOException {
        String string = "http://www.daml.org/2001/03/daml+oil-ex-dt";
        String string2 = "testing/xsd/daml+oil-ex-dt.xsd";
        TypeMapper typeMapper = TypeMapper.getInstance();
        XSDDatatype.loadUserDefined(string, new FileReader(string2), null, typeMapper);
        Model model = ModelFactory.createDefaultModel();
        model.read("file:testing/reasoners/bugs/userDatatypes.owl");
        InfModel infModel = ModelFactory.createInfModel(ReasonerRegistry.getOWLReasoner(), model);
        String string3 = "http://jena.hpl.hp.com/eg#";
        Resource resource = infModel.getResource(string3 + "me");
        Resource resource2 = infModel.getResource(string3 + "Test");
        TestBugs.assertTrue((String)"somevalues inf for datatypes", (boolean)infModel.contains(resource, RDF.type, resource2));
        Resource resource3 = infModel.getResource(string3 + "Test2");
        Resource resource4 = infModel.getResource(string3 + "me2");
        TestBugs.assertTrue((String)"somevalues inf for datatypes", (boolean)infModel.contains(resource4, RDF.type, resource3));
        TestBugs.assertTrue((String)"somevalues inf for user datatypes", (boolean)infModel.contains(resource, RDF.type, resource3));
    }

    public void testDAMLMicroReasonerSupports() {
        Reasoner reasoner = DAMLMicroReasonerFactory.theInstance().create(null);
        TestBugs.assertTrue((String)"Should support daml:subClassOf", (boolean)reasoner.supportsProperty(DAML_OIL.subClassOf));
        TestBugs.assertTrue((String)"Should support daml:subPropertyOf", (boolean)reasoner.supportsProperty(DAML_OIL.subPropertyOf));
        TestBugs.assertTrue((String)"Should support daml:domain", (boolean)reasoner.supportsProperty(DAML_OIL.domain));
        TestBugs.assertTrue((String)"Should support daml:range", (boolean)reasoner.supportsProperty(DAML_OIL.range));
    }

    public static Model modelFromN3(String string) {
        String string2 = "@prefix owl: <http://www.w3.org/2002/07/owl#> .\n@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .\n@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> .\n@prefix eg: <http://jena.hpl.hp.com/eg#> .\n@prefix : <#> .\n" + string + "\n";
        Model model = ModelFactory.createDefaultModel();
        model.read(new StringReader(string2), "", "N3");
        return model;
    }

    private void tempList(Model model, Resource resource, Property property, RDFNode rDFNode) {
        System.out.println("Listing of " + PrintUtil.print(resource) + " " + PrintUtil.print(property) + " " + PrintUtil.print(rDFNode));
        StmtIterator stmtIterator = model.listStatements(resource, property, rDFNode);
        while (stmtIterator.hasNext()) {
            System.out.println(" - " + stmtIterator.next());
        }
    }

    public static void main(String[] stringArray) {
        TestBugs testBugs = new TestBugs("test");
    }
}

