/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.OWLFBRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.OWLMicroReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.OWLMiniReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.test.OWLWGTester;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class OWLUnitTest
extends TestCase {
    public static ReasonerFactory[] reasonerFactories = new ReasonerFactory[]{OWLFBRuleReasonerFactory.theInstance(), OWLMicroReasonerFactory.theInstance(), OWLMiniReasonerFactory.theInstance()};
    public static final int FB = 1;
    public static final int MINI = 2;
    public static final int MICRO = 4;
    public static TestDef[] testDefs = new TestDef[]{new TestDef("localtests/ManifestSubclass001.rdf", 7), new TestDef("equivalentClass/Manifest001.rdf", 7), new TestDef("equivalentClass/Manifest002.rdf", 7), new TestDef("equivalentClass/Manifest003.rdf", 7), new TestDef("equivalentClass/Manifest004.rdf", 3), new TestDef("equivalentClass/Manifest005.rdf", 7), new TestDef("localtests/ManifestRestriction001.rdf", 7), new TestDef("intersectionOf/Manifest001.rdf", 7), new TestDef("localtests/Manifest001.rdf", 7), new TestDef("localtests/Manifest002.rdf", 7), new TestDef("unionOf/Manifest001.rdf", 6), new TestDef("SymmetricProperty/Manifest001.rdf", 7), new TestDef("SymmetricProperty/Manifest001.rdf", 7), new TestDef("inverseOf/Manifest001.rdf", 7), new TestDef("TransitiveProperty/Manifest001.rdf", 7), new TestDef("localtests/Manifest005.rdf", 7), new TestDef("FunctionalProperty/Manifest001.rdf", 3), new TestDef("FunctionalProperty/Manifest002.rdf", 3), new TestDef("FunctionalProperty/Manifest003.rdf", 7), new TestDef("InverseFunctionalProperty/Manifest001.rdf", 3), new TestDef("InverseFunctionalProperty/Manifest002.rdf", 3), new TestDef("InverseFunctionalProperty/Manifest003.rdf", 7), new TestDef("I5.1/Manifest001.rdf", 3), new TestDef("rdf-charmod-uris/Manifest.rdf", 7), new TestDef("I4.6/Manifest003.rdf", 7), new TestDef("I5.5/Manifest001.rdf", 7), new TestDef("I5.5/Manifest002.rdf", 7), new TestDef("I5.5/Manifest003.rdf", 7), new TestDef("I5.5/Manifest004.rdf", 7), new TestDef("inverseOf/Manifest001.rdf", 7), new TestDef("TransitiveProperty/Manifest001.rdf", 7), new TestDef("equivalentProperty/Manifest001.rdf", 7), new TestDef("equivalentProperty/Manifest002.rdf", 7), new TestDef("equivalentProperty/Manifest003.rdf", 7), new TestDef("I5.24/Manifest001.rdf", 7), new TestDef("I5.24/Manifest002-mod.rdf", 7), new TestDef("equivalentProperty/Manifest006.rdf", 7), new TestDef("I5.2/Manifest002.rdf", 3), new TestDef("differentFrom/Manifest001.rdf", 7), new TestDef("disjointWith/Manifest001.rdf", 7), new TestDef("disjointWith/Manifest002.rdf", 7), new TestDef("AllDifferent/Manifest001.rdf", 7), new TestDef("allValuesFrom/Manifest001.rdf", 3), new TestDef("allValuesFrom/Manifest002.rdf", 7), new TestDef("someValuesFrom/Manifest002.rdf", 7), new TestDef("maxCardinality/Manifest001.rdf", 7), new TestDef("maxCardinality/Manifest002.rdf", 7), new TestDef("FunctionalProperty/Manifest005-mod.rdf", 7), new TestDef("I5.24/Manifest004-mod.rdf", 3), new TestDef("cardinality/Manifest001-mod.rdf", 3), new TestDef("cardinality/Manifest002-mod.rdf", 3), new TestDef("cardinality/Manifest003-mod.rdf", 3), new TestDef("cardinality/Manifest004-mod.rdf", 3), new TestDef("I5.24/Manifest003-mod.rdf", 7), new TestDef("cardinality/Manifest005-mod.rdf", 3), new TestDef("cardinality/Manifest006-mod.rdf", 3), new TestDef("someValuesFrom/Manifest001.rdf", 1), new TestDef("localtests/Manifest003.rdf", 7), new TestDef("localtests/Manifest004.rdf", 3), new TestDef("localtests/Manifest006.rdf", 1)};
    protected String manifest;
    protected ReasonerFactory reasonerFactory;

    public OWLUnitTest(String string, ReasonerFactory reasonerFactory) {
        super(string);
        this.manifest = string;
        this.reasonerFactory = reasonerFactory;
    }

    public static TestSuite suite() {
        TestSuite testSuite = new TestSuite();
        for (int i = 0; i < reasonerFactories.length; ++i) {
            OWLUnitTest.mergeSuite(testSuite, OWLUnitTest.suite(reasonerFactories[i]));
        }
        return testSuite;
    }

    public static TestSuite mergeSuite(TestSuite testSuite, TestSuite testSuite2) {
        int n = testSuite2.testCount();
        for (int i = 0; i < n; ++i) {
            testSuite.addTest(testSuite2.testAt(i));
        }
        return testSuite;
    }

    public static TestSuite suite(ReasonerFactory reasonerFactory) {
        TestSuite testSuite = new TestSuite();
        for (int i = 0; i < testDefs.length; ++i) {
            TestDef testDef = testDefs[i];
            if (!testDef.applicableTo(reasonerFactory)) continue;
            testSuite.addTest((Test)testDef.getTestCase(reasonerFactory));
        }
        return testSuite;
    }

    protected void runTest() throws IOException {
        OWLWGTester oWLWGTester = new OWLWGTester(this.reasonerFactory, this, null);
        oWLWGTester.runTests(this.manifest, false, false);
    }

    static class TestDef {
        public String manifest;
        public int validFor;

        public TestDef(String string, int n) {
            this.manifest = string;
            this.validFor = n;
        }

        public int flagFor(ReasonerFactory reasonerFactory) {
            if (reasonerFactory.equals(OWLFBRuleReasonerFactory.theInstance())) {
                return 1;
            }
            if (reasonerFactory.equals(OWLMiniReasonerFactory.theInstance())) {
                return 2;
            }
            if (reasonerFactory.equals(OWLMicroReasonerFactory.theInstance())) {
                return 4;
            }
            throw new ReasonerException("Unrecognized OWL reasoner config in unit test");
        }

        public boolean applicableTo(ReasonerFactory reasonerFactory) {
            return (this.validFor & this.flagFor(reasonerFactory)) != 0;
        }

        public TestCase getTestCase(ReasonerFactory reasonerFactory) {
            return new OWLUnitTest(this.manifest, reasonerFactory);
        }
    }
}

