/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl.oldCode;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.BasicForwardRuleInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.BasicForwardRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.ClauseEntry;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.Util;
import com.hp.hpl.jena.reasoner.rulesys.impl.oldCode.OWLRuleReasonerFactory;
import com.hp.hpl.jena.shared.WrappedIOException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OWLRuleReasoner
extends BasicForwardRuleReasoner {
    protected static final String RULE_FILE = "etc/owl.rules";
    protected static List ruleSet;
    protected static Log logger;
    protected static long nRulesFired;
    protected static long timeCost;

    public OWLRuleReasoner() {
        super(OWLRuleReasoner.loadRules(), OWLRuleReasonerFactory.theInstance());
    }

    private OWLRuleReasoner(List list, InfGraph infGraph) {
        super(list, OWLRuleReasonerFactory.theInstance());
        this.rules = list;
        this.schemaGraph = infGraph;
    }

    public static List loadRules() {
        if (ruleSet == null) {
            try {
                ruleSet = Rule.parseRules(Util.loadResourceFile(RULE_FILE));
            }
            catch (WrappedIOException wrappedIOException) {
                throw new ReasonerException("Can't load rules file: etc/owl.rules", wrappedIOException);
            }
        }
        return ruleSet;
    }

    public Reasoner bindSchema(Graph graph) throws ReasonerException {
        BasicForwardRuleInfGraph basicForwardRuleInfGraph = new BasicForwardRuleInfGraph(this, this.rules, graph);
        ExtendedIterator extendedIterator = graph.find(null, OWL.intersectionOf.asNode(), null);
        ArrayList arrayList = (ArrayList)ruleSet;
        if (extendedIterator.hasNext()) {
            arrayList = (ArrayList)arrayList.clone();
            while (extendedIterator.hasNext()) {
                this.translateIntersectionOf((Triple)extendedIterator.next(), arrayList, graph);
            }
        }
        return new OWLRuleReasoner((List)arrayList, basicForwardRuleInfGraph);
    }

    public InfGraph bind(Graph graph) throws ReasonerException {
        long l = System.currentTimeMillis();
        ExtendedIterator extendedIterator = graph.find(null, OWL.intersectionOf.asNode(), null);
        ArrayList arrayList = (ArrayList)ruleSet;
        if (extendedIterator.hasNext()) {
            arrayList = (ArrayList)arrayList.clone();
            while (extendedIterator.hasNext()) {
                this.translateIntersectionOf((Triple)extendedIterator.next(), arrayList, graph);
            }
        }
        BasicForwardRuleInfGraph basicForwardRuleInfGraph = new BasicForwardRuleInfGraph(this, arrayList, this.schemaGraph);
        basicForwardRuleInfGraph.setDerivationLogging(this.recordDerivations);
        basicForwardRuleInfGraph.setTraceOn(this.traceOn);
        basicForwardRuleInfGraph.rebind(graph);
        long l2 = System.currentTimeMillis();
        timeCost = (long)((double)timeCost + (double)(l2 - l));
        nRulesFired += basicForwardRuleInfGraph.getNRulesFired();
        return basicForwardRuleInfGraph;
    }

    public static void printStats() {
        logger.info((Object)("Fired " + nRulesFired + " over " + (double)timeCost / 1000.0 + " s = " + nRulesFired * 1000L / timeCost + " r/s"));
    }

    private void translateIntersectionOf(Triple triple, List list, Graph graph) {
        Object object;
        Node node = triple.getSubject();
        ArrayList arrayList = new ArrayList();
        this.translateIntersectionList(triple.getObject(), graph, arrayList);
        ArrayList<TriplePattern> arrayList2 = new ArrayList<TriplePattern>();
        Node_RuleVariable node_RuleVariable = new Node_RuleVariable("?x", 0);
        Object object2 = arrayList.iterator();
        while (object2.hasNext()) {
            object = (Node)object2.next();
            Rule rule = new Rule("intersectionImplication", new ClauseEntry[]{new TriplePattern(node, RDFS.subClassOf.asNode(), (Node)object)}, new ClauseEntry[0]);
            list.add(rule);
            arrayList2.add(new TriplePattern(node_RuleVariable, RDF.type.asNode(), (Node)object));
        }
        object2 = new ArrayList(1);
        object2.add(new TriplePattern(node_RuleVariable, RDF.type.asNode(), node));
        object = new Rule("intersectionRecognition", (List)object2, arrayList2);
        list.add(object);
    }

    private void translateIntersectionList(Node node, Graph graph, List list) {
        Node node2;
        if (node.equals(RDF.nil.asNode())) {
            return;
        }
        Node node3 = Util.getPropValue(node, RDF.first.asNode(), graph);
        if (graph.contains(node3, RDF.type.asNode(), OWL.Restriction.asNode())) {
            node2 = Util.getPropValue(node3, OWL.onProperty.asNode(), graph);
            Node node4 = Util.getPropValue(node3, OWL.allValuesFrom.asNode(), graph);
            if (node4 != null) {
                list.add(Functor.makeFunctorNode("all", new Node[]{node2, node4}));
            } else {
                node4 = Util.getPropValue(node3, OWL.someValuesFrom.asNode(), graph);
                if (node4 != null) {
                    list.add(Functor.makeFunctorNode("some", new Node[]{node2, node4}));
                } else {
                    node4 = Util.getPropValue(node3, OWL.minCardinality.asNode(), graph);
                    if (node4 != null) {
                        list.add(Functor.makeFunctorNode("min", new Node[]{node2, node4}));
                    } else {
                        node4 = Util.getPropValue(node3, OWL.maxCardinality.asNode(), graph);
                        if (node4 != null) {
                            list.add(Functor.makeFunctorNode("max", new Node[]{node2, node4}));
                        } else {
                            node4 = Util.getPropValue(node3, OWL.cardinality.asNode(), graph);
                            if (node4 != null) {
                                list.add(Functor.makeFunctorNode("max", new Node[]{node2, node4}));
                                list.add(Functor.makeFunctorNode("min", new Node[]{node2, node4}));
                            }
                        }
                    }
                }
            }
        } else {
            list.add(node3);
        }
        node2 = Util.getPropValue(node, RDF.rest.asNode(), graph);
        this.translateIntersectionList(node2, graph, list);
    }

    static {
        logger = LogFactory.getLog((Class)OWLRuleReasoner.class);
        nRulesFired = 0L;
        timeCost = 0L;
    }
}

