/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import com.hp.hpl.jena.reasoner.rulesys.impl.Generator;
import com.hp.hpl.jena.reasoner.rulesys.impl.GenericTripleMatchFrame;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPAgendaEntry;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPInterpreter;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPInterpreterContext;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPInterpreterState;
import com.hp.hpl.jena.reasoner.rulesys.impl.StateFlag;
import java.util.List;

public class ConsumerChoicePointFrame
extends GenericTripleMatchFrame
implements LPAgendaEntry,
LPInterpreterState {
    protected Generator generator;
    protected int resultIndex;
    protected Node[] pVars;
    protected Node_RuleVariable[] trailVars;
    protected Node[] trailValues;
    protected int trailLength;
    protected LPInterpreterContext context;

    public ConsumerChoicePointFrame(LPInterpreter lPInterpreter) {
        this.init(lPInterpreter);
    }

    public void init(LPInterpreter lPInterpreter) {
        super.init(lPInterpreter);
        this.context = lPInterpreter.getContext();
        this.generator = lPInterpreter.getEngine().generatorFor(this.goal);
        this.generator.addConsumer(this);
        this.resultIndex = 0;
    }

    public void preserveState(List list) {
        int n = list.size();
        if (n > this.trailLength) {
            this.trailValues = new Node[n];
            this.trailVars = new Node_RuleVariable[n];
        }
        this.trailLength = n;
        for (int i = 0; i < n; ++i) {
            Node_RuleVariable node_RuleVariable;
            this.trailVars[i] = node_RuleVariable = (Node_RuleVariable)list.get(i);
            this.trailValues[i] = node_RuleVariable.getRawBoundValue();
        }
        Node[] nodeArray = this.envFrame.pVars;
        if (nodeArray != null) {
            if (this.pVars == null || this.pVars.length < nodeArray.length) {
                this.pVars = new Node[nodeArray.length];
            }
            System.arraycopy(nodeArray, 0, this.pVars, 0, nodeArray.length);
        }
    }

    public void restoreState(LPInterpreter lPInterpreter) {
        lPInterpreter.unwindTrail(0);
        for (int i = 0; i < this.trailLength; ++i) {
            lPInterpreter.bind(this.trailVars[i], this.trailValues[i]);
        }
        if (this.pVars != null) {
            System.arraycopy(this.pVars, 0, this.envFrame.pVars, 0, this.pVars.length);
        }
    }

    public synchronized StateFlag nextMatch(LPInterpreter lPInterpreter) {
        while (this.resultIndex < this.generator.results.size()) {
            Triple triple;
            if (!this.bindResult(triple = (Triple)this.generator.results.get(this.resultIndex++), lPInterpreter)) continue;
            return StateFlag.SATISFIED;
        }
        if (this.generator.isComplete()) {
            this.setFinished();
            return StateFlag.FAIL;
        }
        return StateFlag.SUSPEND;
    }

    public boolean isReady() {
        return this.generator.numResults() > this.resultIndex;
    }

    public void setReady() {
        this.context.setReady(this);
    }

    public void setFinished() {
        this.context.notifyFinished(this);
    }

    public void pump() {
        if (this.context instanceof Generator) {
            ((Generator)this.context).pump(this);
        }
    }

    public Generator getGenerator() {
        return this.generator;
    }

    public LPInterpreterContext getConsumingContext() {
        return this.context;
    }
}

