/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.OWLMicroReasoner;
import com.hp.hpl.jena.reasoner.rulesys.Util;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveReasoner;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;

public class OWLMicroReasonerFactory
implements ReasonerFactory {
    private static ReasonerFactory theInstance = new OWLMicroReasonerFactory();
    public static final String URI = "http://jena.hpl.hp.com/2003/OWLMicroFBRuleReasoner";
    protected Model capabilities;

    public static ReasonerFactory theInstance() {
        return theInstance;
    }

    public Reasoner create(Resource resource) {
        OWLMicroReasoner oWLMicroReasoner = new OWLMicroReasoner(this);
        if (resource != null) {
            Boolean bl;
            Boolean bl2 = Util.checkBinaryPredicate(ReasonerVocabulary.PROPderivationLogging, resource);
            if (bl2 != null) {
                oWLMicroReasoner.setDerivationLogging(bl2);
            }
            if ((bl = Util.checkBinaryPredicate(ReasonerVocabulary.PROPtraceOn, resource)) != null) {
                oWLMicroReasoner.setTraceOn(bl);
            }
        }
        return oWLMicroReasoner;
    }

    public Model getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = ModelFactory.createDefaultModel();
            Resource resource = this.capabilities.createResource(this.getURI());
            resource.addProperty(ReasonerVocabulary.nameP, "OWL Mini Reasoner").addProperty(ReasonerVocabulary.descriptionP, "Experimental mini OWL reasoner.\nCan separate tbox and abox data if desired to reuse tbox caching or mix them.").addProperty(ReasonerVocabulary.supportsP, RDFS.subClassOf).addProperty(ReasonerVocabulary.supportsP, RDFS.subPropertyOf).addProperty(ReasonerVocabulary.supportsP, RDFS.member).addProperty(ReasonerVocabulary.supportsP, RDFS.range).addProperty(ReasonerVocabulary.supportsP, RDFS.domain).addProperty(ReasonerVocabulary.supportsP, TransitiveReasoner.directSubClassOf).addProperty(ReasonerVocabulary.supportsP, TransitiveReasoner.directSubPropertyOf).addProperty(ReasonerVocabulary.versionP, "0.1");
        }
        return this.capabilities;
    }

    public String getURI() {
        return URI;
    }
}

