/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.BaseInfGraph;
import com.hp.hpl.jena.reasoner.IllegalParameterException;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.BasicForwardRuleInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.LPBackwardRuleInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.RETERuleInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.RulePreprocessHook;
import com.hp.hpl.jena.reasoner.rulesys.Util;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPRuleStore;
import com.hp.hpl.jena.reasoner.rulesys.impl.OWLRuleTranslationHook;
import com.hp.hpl.jena.vocabulary.JMS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class GenericRuleReasoner
extends FBRuleReasoner {
    protected LPRuleStore bRuleStore;
    protected RuleMode mode = HYBRID;
    protected static final boolean cachePreload = true;
    protected boolean enableTGCCaching = false;
    protected boolean enableOWLTranslation = false;
    protected HashSet preprocessorHooks;
    public boolean filterFunctors = true;
    private static final OWLRuleTranslationHook owlTranslator = new OWLRuleTranslationHook();
    public static final RuleMode FORWARD = new RuleMode("forward");
    public static final RuleMode FORWARD_RETE = new RuleMode("forwardRETE");
    public static final RuleMode BACKWARD = new RuleMode("backward");
    public static final RuleMode HYBRID = new RuleMode("hybrid");

    public GenericRuleReasoner(List list) {
        super(list);
    }

    public GenericRuleReasoner(ReasonerFactory reasonerFactory, Resource resource) {
        super(reasonerFactory, resource);
    }

    public GenericRuleReasoner(List list, ReasonerFactory reasonerFactory) {
        super(list, reasonerFactory);
    }

    protected GenericRuleReasoner(List list, Graph graph, ReasonerFactory reasonerFactory, RuleMode ruleMode) {
        this(list, reasonerFactory);
        this.schemaGraph = graph;
        this.mode = ruleMode;
    }

    public void setMode(RuleMode ruleMode) {
        if (this.schemaGraph != null) {
            throw new ReasonerException("Can't change mode of a reasoner bound to a schema");
        }
        this.mode = ruleMode;
        this.preload = null;
        this.bRuleStore = null;
    }

    public void setRules(List list) {
        super.setRules(list);
    }

    public void setOWLTranslation(boolean bl) {
        if (bl && this.mode != HYBRID) {
            throw new ReasonerException("Can only enable OWL rule translation in HYBRID mode");
        }
        this.enableOWLTranslation = bl;
        if (bl) {
            this.addPreprocessingHook(owlTranslator);
        } else {
            this.removePreprocessingHook(owlTranslator);
        }
    }

    public void setTransitiveClosureCaching(boolean bl) {
        this.enableTGCCaching = bl;
    }

    public void setFunctorFiltering(boolean bl) {
        this.filterFunctors = bl;
    }

    public void addPreprocessingHook(RulePreprocessHook rulePreprocessHook) {
        if (this.preprocessorHooks == null) {
            this.preprocessorHooks = new HashSet();
        }
        this.preprocessorHooks.add(rulePreprocessHook);
    }

    public void removePreprocessingHook(RulePreprocessHook rulePreprocessHook) {
        if (this.preprocessorHooks != null) {
            this.preprocessorHooks.remove(rulePreprocessHook);
        }
    }

    protected boolean doSetResourceParameter(Property property, Resource resource) {
        if (property.equals(JMS.ruleSetURL)) {
            this.addRules(Rule.rulesFromURL(resource.getURI()));
        } else if (property.equals(JMS.ruleSet)) {
            StmtIterator stmtIterator = resource.listProperties(JMS.ruleSetURL);
            while (stmtIterator.hasNext()) {
                this.addRules(Rule.rulesFromURL(stmtIterator.nextStatement().getResource().getURI()));
            }
            StmtIterator stmtIterator2 = resource.listProperties(JMS.hasRule);
            while (stmtIterator2.hasNext()) {
                this.addRules(Rule.parseRules(stmtIterator2.nextStatement().getString()));
            }
        } else {
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean doSetParameter(Property property, Object object) {
        if (property.equals(ReasonerVocabulary.PROPderivationLogging)) {
            this.recordDerivations = Util.convertBooleanPredicateArg(property, object);
            return true;
        } else if (property.equals(ReasonerVocabulary.PROPtraceOn)) {
            this.traceOn = Util.convertBooleanPredicateArg(property, object);
            return true;
        } else if (property.equals(ReasonerVocabulary.PROPenableFunctorFiltering)) {
            this.filterFunctors = Util.convertBooleanPredicateArg(property, object);
            return true;
        } else if (property.equals(ReasonerVocabulary.PROPenableOWLTranslation)) {
            this.enableOWLTranslation = Util.convertBooleanPredicateArg(property, object);
            if (this.enableOWLTranslation) {
                this.addPreprocessingHook(owlTranslator);
                return true;
            } else {
                this.removePreprocessingHook(owlTranslator);
            }
            return true;
        } else if (property.equals(ReasonerVocabulary.PROPenableTGCCaching)) {
            this.enableTGCCaching = Util.convertBooleanPredicateArg(property, object);
            return true;
        } else if (property.equals(ReasonerVocabulary.PROPruleMode)) {
            if (object.equals(GenericRuleReasoner.FORWARD.name)) {
                this.mode = FORWARD;
                return true;
            } else if (object.equals(GenericRuleReasoner.FORWARD_RETE.name)) {
                this.mode = FORWARD_RETE;
                return true;
            } else if (object.equals(GenericRuleReasoner.BACKWARD.name)) {
                this.mode = BACKWARD;
                return true;
            } else {
                if (!object.equals(GenericRuleReasoner.HYBRID.name)) throw new IllegalParameterException("PROPruleMode can only be 'forward'm 'forwardRETE', 'backward', 'hybrid', not " + object);
                this.mode = HYBRID;
            }
            return true;
        } else {
            if (!property.equals(ReasonerVocabulary.PROPruleSet)) return false;
            if (!(object instanceof String)) throw new IllegalParameterException("PROPruleSet value should be a URI string. Was a " + object.getClass());
            this.setRules(GenericRuleReasoner.loadRules((String)object));
        }
        return true;
    }

    public Reasoner bindSchema(Graph graph) throws ReasonerException {
        Object object;
        if (this.schemaGraph != null) {
            throw new ReasonerException("Can only bind one schema at a time to a GenericRuleReasoner");
        }
        Graph graph2 = null;
        if (this.mode == FORWARD) {
            graph2 = new BasicForwardRuleInfGraph(this, this.rules, null, graph);
            ((InfGraph)graph2).prepare();
        } else if (this.mode == FORWARD_RETE) {
            graph2 = new RETERuleInfGraph(this, this.rules, null, graph);
            ((InfGraph)graph2).prepare();
        } else if (this.mode == BACKWARD) {
            graph2 = graph;
        } else {
            object = this.rules;
            graph2 = new FBRuleInfGraph(this, (List)object, this.getPreload(), graph);
            if (this.enableTGCCaching) {
                ((FBRuleInfGraph)graph2).setUseTGCCache();
            }
            ((FBRuleInfGraph)graph2).prepare();
        }
        object = new GenericRuleReasoner(this.rules, graph2, this.factory, this.mode);
        ((FBRuleReasoner)object).setDerivationLogging(this.recordDerivations);
        ((FBRuleReasoner)object).setTraceOn(this.traceOn);
        ((GenericRuleReasoner)object).setTransitiveClosureCaching(this.enableTGCCaching);
        ((GenericRuleReasoner)object).setFunctorFiltering(this.filterFunctors);
        if (this.preprocessorHooks != null) {
            Iterator iterator = this.preprocessorHooks.iterator();
            while (iterator.hasNext()) {
                ((GenericRuleReasoner)object).addPreprocessingHook((RulePreprocessHook)iterator.next());
            }
        }
        return object;
    }

    public InfGraph bind(Graph graph) throws ReasonerException {
        Graph graph2 = this.schemaGraph == null ? this.getPreload() : this.schemaGraph;
        BaseInfGraph baseInfGraph = null;
        if (this.mode == FORWARD) {
            baseInfGraph = new BasicForwardRuleInfGraph(this, this.rules, graph2);
            ((BasicForwardRuleInfGraph)baseInfGraph).setTraceOn(this.traceOn);
        } else if (this.mode == FORWARD_RETE) {
            baseInfGraph = new RETERuleInfGraph(this, this.rules, graph2);
            ((BasicForwardRuleInfGraph)baseInfGraph).setTraceOn(this.traceOn);
        } else if (this.mode == BACKWARD) {
            baseInfGraph = new LPBackwardRuleInfGraph(this, this.getBruleStore(), graph, graph2);
            ((LPBackwardRuleInfGraph)baseInfGraph).setTraceOn(this.traceOn);
        } else {
            List list = ((FBRuleInfGraph)graph2).getRules();
            FBRuleInfGraph fBRuleInfGraph = new FBRuleInfGraph(this, list, graph2);
            baseInfGraph = fBRuleInfGraph;
            if (this.enableTGCCaching) {
                fBRuleInfGraph.setUseTGCCache();
            }
            fBRuleInfGraph.setTraceOn(this.traceOn);
            fBRuleInfGraph.setFunctorFiltering(this.filterFunctors);
            if (this.preprocessorHooks != null) {
                Iterator iterator = this.preprocessorHooks.iterator();
                while (iterator.hasNext()) {
                    fBRuleInfGraph.addPreprocessingHook((RulePreprocessHook)iterator.next());
                }
            }
        }
        baseInfGraph.setDerivationLogging(this.recordDerivations);
        baseInfGraph.rebind(graph);
        return baseInfGraph;
    }

    protected synchronized InfGraph getPreload() {
        if (this.preload == null && this.mode == HYBRID) {
            if (this.mode == HYBRID) {
                this.preload = new FBRuleInfGraph(this, this.rules, null);
                if (this.enableTGCCaching) {
                    ((FBRuleInfGraph)this.preload).setUseTGCCache();
                }
            } else if (this.mode == FORWARD) {
                this.preload = new BasicForwardRuleInfGraph(this, this.rules, null);
            } else if (this.mode == FORWARD_RETE) {
                this.preload = new RETERuleInfGraph(this, this.rules, null);
            }
            this.preload.prepare();
        }
        return this.preload;
    }

    protected LPRuleStore getBruleStore() {
        if (this.bRuleStore == null) {
            this.bRuleStore = new LPRuleStore(this.rules);
        }
        return this.bRuleStore;
    }

    public static class RuleMode {
        String name;

        protected RuleMode(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }
}

