/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys;

import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.BaseInfGraph;
import com.hp.hpl.jena.reasoner.IllegalParameterException;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.ClauseEntry;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.RuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.Util;
import com.hp.hpl.jena.shared.WrappedIOException;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.util.ArrayList;
import java.util.List;

public class FBRuleReasoner
implements RuleReasoner {
    protected ReasonerFactory factory;
    protected List rules = new ArrayList();
    protected Graph schemaGraph;
    protected boolean recordDerivations = false;
    boolean traceOn = false;
    protected static final boolean cachePreload = true;
    protected InfGraph preload;
    protected Resource configuration;
    protected Capabilities capabilities;

    public FBRuleReasoner(List list) {
        if (list == null) {
            throw new NullPointerException("null rules");
        }
        this.rules = list;
    }

    public FBRuleReasoner(ReasonerFactory reasonerFactory) {
        this(new ArrayList(), reasonerFactory);
    }

    public FBRuleReasoner(ReasonerFactory reasonerFactory, Resource resource) {
        this(new ArrayList(), reasonerFactory);
        this.configuration = resource;
        if (resource != null) {
            this.loadConfiguration(resource);
        }
    }

    protected void loadConfiguration(Resource resource) {
        StmtIterator stmtIterator = resource.listProperties();
        while (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            this.doSetRDFNodeParameter(statement.getPredicate(), statement.getObject());
        }
    }

    public FBRuleReasoner(List list, ReasonerFactory reasonerFactory) {
        this(list);
        this.factory = reasonerFactory;
    }

    protected FBRuleReasoner(List list, Graph graph, ReasonerFactory reasonerFactory) {
        this(list, reasonerFactory);
        this.schemaGraph = graph;
    }

    public FBRuleReasoner addRules(List list) {
        ArrayList arrayList = new ArrayList(this.rules);
        arrayList.addAll(list);
        this.setRules(arrayList);
        return this;
    }

    public Model getReasonerCapabilities() {
        if (this.factory != null) {
            return this.factory.getCapabilities();
        }
        return null;
    }

    public void addDescription(Model model, Resource resource) {
        if (this.configuration != null) {
            StmtIterator stmtIterator = this.configuration.listProperties();
            while (stmtIterator.hasNext()) {
                Statement statement = stmtIterator.nextStatement();
                model.add(resource, statement.getPredicate(), statement.getObject());
            }
        }
    }

    public boolean supportsProperty(Property property) {
        if (this.factory == null) {
            return false;
        }
        Model model = this.factory.getCapabilities();
        Resource resource = model.getResource(this.factory.getURI());
        return model.contains(resource, ReasonerVocabulary.supportsP, property);
    }

    public Reasoner bindSchema(Graph graph) throws ReasonerException {
        if (this.schemaGraph != null) {
            throw new ReasonerException("Can only bind one schema at a time to an OWLRuleReasoner");
        }
        FBRuleInfGraph fBRuleInfGraph = new FBRuleInfGraph(this, this.rules, this.getPreload(), graph);
        fBRuleInfGraph.prepare();
        FBRuleReasoner fBRuleReasoner = new FBRuleReasoner(this.rules, fBRuleInfGraph, this.factory);
        fBRuleReasoner.setDerivationLogging(this.recordDerivations);
        fBRuleReasoner.setTraceOn(this.traceOn);
        return fBRuleReasoner;
    }

    public Reasoner bindSchema(Model model) throws ReasonerException {
        return this.bindSchema(model.getGraph());
    }

    public InfGraph bind(Graph graph) throws ReasonerException {
        InfGraph infGraph = this.schemaGraph == null ? this.getPreload() : (FBRuleInfGraph)this.schemaGraph;
        FBRuleInfGraph fBRuleInfGraph = new FBRuleInfGraph(this, this.rules, infGraph);
        fBRuleInfGraph.setDerivationLogging(this.recordDerivations);
        fBRuleInfGraph.setTraceOn(this.traceOn);
        fBRuleInfGraph.rebind(graph);
        return fBRuleInfGraph;
    }

    public void setRules(List list) {
        this.rules = list;
        this.preload = null;
    }

    public List getRules() {
        return this.rules;
    }

    public static List loadRules(String string) {
        try {
            return Rule.parseRules(Util.loadResourceFile(string));
        }
        catch (WrappedIOException wrappedIOException) {
            throw new ReasonerException("Can't load rules file: " + string, wrappedIOException.getCause());
        }
    }

    public synchronized void tablePredicate(Node node) {
        Rule rule = new Rule("", new ClauseEntry[]{new Functor("table", new Node[]{node})}, new ClauseEntry[0]);
        this.rules.add(rule);
    }

    protected synchronized InfGraph getPreload() {
        if (this.preload == null) {
            this.preload = new FBRuleInfGraph(this, this.rules, null);
            this.preload.prepare();
        }
        return this.preload;
    }

    public void setDerivationLogging(boolean bl) {
        this.recordDerivations = bl;
    }

    public void setTraceOn(boolean bl) {
        this.traceOn = bl;
    }

    public boolean isTraceOn() {
        return this.traceOn;
    }

    public void setParameter(Property property, Object object) {
        if (!this.doSetParameter(property, object)) {
            throw new IllegalParameterException("RuleReasoner does not recognize configuration parameter " + property);
        }
        if (this.configuration == null) {
            Model model = ModelFactory.createDefaultModel();
            this.configuration = model.createResource();
        }
        Util.updateParameter(this.configuration, property, object);
    }

    protected boolean doSetRDFNodeParameter(Property property, RDFNode rDFNode) {
        return rDFNode instanceof Resource && this.doSetResourceParameter(property, (Resource)rDFNode) || this.doSetParameter(property, ((Object)rDFNode).toString());
    }

    protected boolean doSetResourceParameter(Property property, Resource resource) {
        return false;
    }

    protected boolean doSetParameter(Property property, Object object) {
        if (property.equals(ReasonerVocabulary.PROPderivationLogging)) {
            this.recordDerivations = Util.convertBooleanPredicateArg(property, object);
            return true;
        }
        if (property.equals(ReasonerVocabulary.PROPtraceOn)) {
            this.traceOn = Util.convertBooleanPredicateArg(property, object);
            return true;
        }
        return false;
    }

    public Capabilities getGraphCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new BaseInfGraph.InfCapabilities();
        }
        return this.capabilities;
    }
}

