/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.reasoner.FGraph;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.FinderUtil;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.StandardValidityReport;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.ValidityReport;
import com.hp.hpl.jena.reasoner.rulesys.BackwardRuleInfGraphI;
import com.hp.hpl.jena.reasoner.rulesys.BasicForwardRuleInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;
import com.hp.hpl.jena.reasoner.rulesys.ClauseEntry;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.RulePreprocessHook;
import com.hp.hpl.jena.reasoner.rulesys.impl.BBRuleContext;
import com.hp.hpl.jena.reasoner.rulesys.impl.FRuleEngine;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPBRuleEngine;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPRuleStore;
import com.hp.hpl.jena.reasoner.rulesys.impl.RETEEngine;
import com.hp.hpl.jena.reasoner.rulesys.impl.TempNodeCache;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveEngine;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveGraphCache;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveReasoner;
import com.hp.hpl.jena.shared.impl.JenaParameters;
import com.hp.hpl.jena.util.OneToManyMap;
import com.hp.hpl.jena.util.PrintUtil;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.UniqueExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FBRuleInfGraph
extends BasicForwardRuleInfGraph
implements BackwardRuleInfGraphI,
Filter {
    protected BBRuleContext context;
    protected Finder dataFind;
    protected LPBRuleEngine bEngine;
    protected List rawRules;
    protected List rules;
    public static boolean useRETE = true;
    protected boolean useTGCCaching = false;
    public boolean filterFunctors = true;
    protected TransitiveEngine transitiveEngine;
    protected List preprocessorHooks;
    protected TempNodeCache tempNodecache;
    protected Set hiddenNodes;
    static Log logger = LogFactory.getLog((Class)FBRuleInfGraph.class);

    public FBRuleInfGraph(Reasoner reasoner, Graph graph) {
        super(reasoner, graph);
        this.constructorInit(graph);
    }

    public FBRuleInfGraph(Reasoner reasoner, List list, Graph graph) {
        super(reasoner, list, graph);
        this.rawRules = list;
        this.constructorInit(graph);
    }

    public FBRuleInfGraph(Reasoner reasoner, List list, Graph graph, Graph graph2) {
        super(reasoner, list, graph, graph2);
        this.rawRules = list;
        this.constructorInit(graph);
    }

    private void constructorInit(Graph graph) {
        this.initLP(graph);
        this.tempNodecache = new TempNodeCache(this);
        if (JenaParameters.enableFilteringOfHiddenInfNodes) {
            this.hiddenNodes = new HashSet();
            if (graph != null && graph instanceof FBRuleInfGraph) {
                this.hiddenNodes.addAll(((FBRuleInfGraph)graph).hiddenNodes);
            }
        }
    }

    protected void instantiateRuleEngine(List list) {
        this.engine = list != null ? (useRETE ? new RETEEngine(this, list) : new FRuleEngine(this, list)) : (useRETE ? new RETEEngine(this) : new FRuleEngine(this));
    }

    private void initLP(Graph graph) {
        if (graph != null && graph instanceof FBRuleInfGraph) {
            LPRuleStore lPRuleStore = new LPRuleStore();
            lPRuleStore.addAll(((FBRuleInfGraph)graph).bEngine.getRuleStore());
            this.bEngine = new LPBRuleEngine(this, lPRuleStore);
        } else {
            this.bEngine = new LPBRuleEngine(this);
        }
    }

    public void setUseTGCCache() {
        this.useTGCCaching = true;
        this.transitiveEngine = this.schemaGraph != null ? new TransitiveEngine(((FBRuleInfGraph)this.schemaGraph).transitiveEngine) : new TransitiveEngine(new TransitiveGraphCache(ReasonerVocabulary.directSubClassOf.asNode(), RDFS.subClassOf.asNode()), new TransitiveGraphCache(ReasonerVocabulary.directSubPropertyOf.asNode(), RDFS.subPropertyOf.asNode()));
    }

    public ExtendedIterator findDataMatches(Node node, Node node2, Node node3) {
        return this.dataFind.find(new TriplePattern(node, node2, node3));
    }

    public ExtendedIterator findDataMatches(TriplePattern triplePattern) {
        return this.dataFind.find(triplePattern);
    }

    public boolean processBuiltin(ClauseEntry clauseEntry, Rule rule, BindingEnvironment bindingEnvironment) {
        throw new ReasonerException("Internal error in FBLP rule engine, incorrect invocation of building in rule " + rule);
    }

    public void addBRule(Rule rule) {
        logger.debug((Object)("Adding rule " + rule));
        this.bEngine.addRule(rule);
        this.bEngine.reset();
    }

    public void deleteBRule(Rule rule) {
        logger.debug((Object)("Deleting rule " + rule));
        this.bEngine.deleteRule(rule);
        this.bEngine.reset();
    }

    public void addBRules(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Rule rule = (Rule)iterator.next();
            this.bEngine.addRule(rule);
        }
        this.bEngine.reset();
    }

    public List getBRules() {
        return this.bEngine.getAllRules();
    }

    public List getRules() {
        return this.rules;
    }

    public void setTabled(Node node) {
        this.bEngine.tablePredicate(node);
        if (this.traceOn) {
            logger.info((Object)("LP TABLE " + node));
        }
    }

    private Object getForwardRuleStore() {
        return this.engine.getRuleStore();
    }

    public void addDeduction(Triple triple) {
        this.getDeductionsGraph().add(triple);
        if (this.useTGCCaching) {
            this.transitiveEngine.add(triple);
        }
    }

    public Node getTemp(Node node, Node node2, Node node3) {
        return this.tempNodecache.getTemp(node, node2, node3);
    }

    public void addRuleDuringPrepare(Rule rule) {
        if (this.rules == this.rawRules) {
            this.rules = this.rawRules instanceof ArrayList ? (ArrayList)((ArrayList)this.rawRules).clone() : new ArrayList(this.rawRules);
            this.instantiateRuleEngine(this.rules);
        }
        this.rules.add(rule);
    }

    public void addPreprocessingHook(RulePreprocessHook rulePreprocessHook) {
        if (this.preprocessorHooks == null) {
            this.preprocessorHooks = new ArrayList();
        }
        this.preprocessorHooks.add(rulePreprocessHook);
    }

    public void prepare() {
        if (!this.isPrepared) {
            Object object;
            Object object2;
            this.isPrepared = true;
            this.rules = this.rawRules;
            Graph graph = null;
            if (this.fdata != null) {
                graph = this.fdata.getGraph();
            }
            this.fdeductions = new FGraph(new GraphMem());
            this.dataFind = graph == null ? this.fdeductions : FinderUtil.cascade(this.fdeductions, this.fdata);
            Finder finder = this.fdata;
            if (this.useTGCCaching) {
                if (this.schemaGraph != null) {
                    if (this.transitiveEngine.checkOccurance(TransitiveReasoner.subPropertyOf, graph) || this.transitiveEngine.checkOccurance(TransitiveReasoner.subClassOf, graph) || this.transitiveEngine.checkOccurance(RDFS.domain.asNode(), graph) || this.transitiveEngine.checkOccurance(RDFS.range.asNode(), graph)) {
                        this.transitiveEngine.insert(((FBRuleInfGraph)this.schemaGraph).fdata, this.fdata);
                    }
                } else if (graph != null) {
                    this.transitiveEngine.insert(null, this.fdata);
                }
                object2 = this.rules.iterator();
                while (object2.hasNext()) {
                    object = (Rule)object2.next();
                    if (((Rule)object).bodyLength() != 0) continue;
                    for (int i = 0; i < ((Rule)object).headLength(); ++i) {
                        ClauseEntry clauseEntry = ((Rule)object).getHeadElement(i);
                        if (!(clauseEntry instanceof TriplePattern)) continue;
                        TriplePattern triplePattern = (TriplePattern)clauseEntry;
                        this.transitiveEngine.add(triplePattern.asTriple());
                    }
                }
                this.transitiveEngine.setCaching(true, true);
                this.dataFind = FinderUtil.cascade(this.dataFind, this.transitiveEngine.getSubClassCache(), this.transitiveEngine.getSubPropertyCache());
                finder = FinderUtil.cascade(finder, this.transitiveEngine.getSubClassCache(), this.transitiveEngine.getSubPropertyCache());
            }
            if (this.preprocessorHooks != null && this.preprocessorHooks.size() > 0) {
                object2 = new GraphMem();
                object = this.preprocessorHooks.iterator();
                while (object.hasNext()) {
                    RulePreprocessHook rulePreprocessHook = (RulePreprocessHook)object.next();
                    rulePreprocessHook.run(this, this.dataFind, (Graph)object2);
                }
                if (object2.size() > 0) {
                    object = new FGraph((Graph)object2);
                    finder = FinderUtil.cascade(this.fdata, (Finder)object);
                    this.dataFind = FinderUtil.cascade(this.dataFind, (Finder)object);
                }
            }
            boolean bl = false;
            if (this.schemaGraph != null) {
                object = ((InfGraph)this.schemaGraph).getRawGraph();
                if (object != null) {
                    this.dataFind = FinderUtil.cascade(this.dataFind, new FGraph((Graph)object));
                }
                bl = this.preloadDeductions(this.schemaGraph);
            }
            if (bl) {
                this.engine.fastInit(finder);
            } else {
                this.addBRules(FBRuleInfGraph.extractPureBackwardRules(this.rules));
                this.engine.init(true, finder);
            }
            this.context = new BBRuleContext(this);
        }
    }

    public void rebind() {
        if (this.bEngine != null) {
            this.bEngine.reset();
        }
        this.isPrepared = false;
    }

    public void setTraceOn(boolean bl) {
        super.setTraceOn(bl);
        this.bEngine.setTraceOn(bl);
    }

    public void setDerivationLogging(boolean bl) {
        this.recordDerivations = bl;
        this.engine.setDerivationLogging(bl);
        this.bEngine.setDerivationLogging(bl);
        this.derivations = bl ? new OneToManyMap() : null;
    }

    public void setFunctorFiltering(boolean bl) {
        this.filterFunctors = bl;
    }

    public long getNRulesFired() {
        return this.engine.getNRulesFired();
    }

    public ExtendedIterator findWithContinuation(TriplePattern triplePattern, Finder finder) {
        this.checkOpen();
        if (!this.isPrepared) {
            this.prepare();
        }
        ExtendedIterator extendedIterator = new UniqueExtendedIterator(this.bEngine.find(triplePattern));
        if (finder != null) {
            extendedIterator = extendedIterator.andThen(finder.find(triplePattern));
        }
        if (this.filterFunctors) {
            return extendedIterator.filterDrop(this);
        }
        return extendedIterator;
    }

    public ExtendedIterator findFull(TriplePattern triplePattern) {
        this.checkOpen();
        if (!this.isPrepared) {
            this.prepare();
        }
        return new UniqueExtendedIterator(this.bEngine.find(triplePattern));
    }

    public ExtendedIterator graphBaseFind(Node node, Node node2, Node node3) {
        return this.findWithContinuation(new TriplePattern(node, node2, node3), null);
    }

    public ExtendedIterator find(TriplePattern triplePattern) {
        return this.findWithContinuation(triplePattern, null);
    }

    public void reset() {
        this.bEngine.reset();
        this.isPrepared = false;
    }

    public synchronized void performAdd(Triple triple) {
        this.fdata.getGraph().add(triple);
        if (this.useTGCCaching && this.transitiveEngine.add(triple)) {
            this.isPrepared = false;
        }
        if (this.isPrepared) {
            this.engine.add(triple);
        }
        this.bEngine.reset();
    }

    public void performDelete(Triple triple) {
        boolean bl = this.fdata.getGraph().contains(triple);
        this.fdata.getGraph().delete(triple);
        if (this.useTGCCaching && this.transitiveEngine.delete(triple)) {
            if (this.isPrepared) {
                this.bEngine.deleteAllRules();
            }
            this.isPrepared = false;
        }
        if (this.isPrepared) {
            this.bEngine.deleteAllRules();
            this.isPrepared = false;
        }
        this.bEngine.reset();
    }

    public InfGraph cloneWithPremises(Graph graph) {
        this.prepare();
        FBRuleInfGraph fBRuleInfGraph = new FBRuleInfGraph(this.getReasoner(), this.rawRules, this);
        if (this.useTGCCaching) {
            fBRuleInfGraph.setUseTGCCache();
        }
        fBRuleInfGraph.setDerivationLogging(this.recordDerivations);
        fBRuleInfGraph.setTraceOn(this.traceOn);
        fBRuleInfGraph.rebind(graph);
        return fBRuleInfGraph;
    }

    public void close() {
        if (!this.closed) {
            this.bEngine.halt();
            this.bEngine = null;
            this.transitiveEngine = null;
            super.close();
        }
    }

    public ValidityReport validate() {
        this.checkOpen();
        StandardValidityReport standardValidityReport = new StandardValidityReport();
        Triple triple = new Triple(Node.createAnon(), ReasonerVocabulary.RB_VALIDATION.asNode(), Functor.makeFunctorNode("on", new Node[0]));
        if (!this.isPrepared) {
            this.prepare();
        }
        this.engine.add(triple);
        TriplePattern triplePattern = new TriplePattern(null, ReasonerVocabulary.RB_VALIDATION_REPORT.asNode(), null);
        ExtendedIterator extendedIterator = this.findFull(triplePattern);
        while (extendedIterator.hasNext()) {
            Object object;
            Triple triple2 = (Triple)extendedIterator.next();
            Node node = triple2.getObject();
            boolean bl = false;
            if (!node.isLiteral() || !((object = node.getLiteral().getValue()) instanceof Functor)) continue;
            Functor functor = (Functor)object;
            bl = true;
            StringBuffer stringBuffer = new StringBuffer();
            String string = functor.getName();
            String string2 = functor.getArgs()[0].toString();
            String string3 = functor.getArgs()[1].toString();
            stringBuffer.append(string3 + "\n");
            stringBuffer.append("Culprit = " + PrintUtil.print(triple2.getSubject()) + "\n");
            for (int i = 2; i < functor.getArgLength(); ++i) {
                stringBuffer.append("Implicated node: " + PrintUtil.print(functor.getArgs()[i]) + "\n");
            }
            standardValidityReport.add(string.equalsIgnoreCase("error"), string2, stringBuffer.toString());
        }
        return standardValidityReport;
    }

    private static List extractPureBackwardRules(List list) {
        ArrayList<Rule> arrayList = new ArrayList<Rule>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Rule rule = (Rule)iterator.next();
            if (!rule.isBackward() || rule.bodyLength() <= 0) continue;
            arrayList.add(rule);
        }
        return arrayList;
    }

    protected boolean preloadDeductions(Graph graph) {
        Graph graph2 = this.fdeductions.getGraph();
        FBRuleInfGraph fBRuleInfGraph = (FBRuleInfGraph)graph;
        if (fBRuleInfGraph.rules == this.rules) {
            ExtendedIterator extendedIterator = fBRuleInfGraph.getDeductionsGraph().find(null, null, null);
            while (extendedIterator.hasNext()) {
                graph2.add((Triple)extendedIterator.next());
            }
            this.addBRules(fBRuleInfGraph.getBRules());
            this.engine.setRuleStore(fBRuleInfGraph.getForwardRuleStore());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hideNode(Node node) {
        if (!JenaParameters.enableFilteringOfHiddenInfNodes) {
            return;
        }
        if (this.hiddenNodes == null) {
            this.hiddenNodes = new HashSet();
        }
        Set set = this.hiddenNodes;
        synchronized (set) {
            this.hiddenNodes.add(node);
        }
    }

    public void resetLPProfile(boolean bl) {
        this.bEngine.resetProfile(bl);
    }

    public void printLPProfile() {
        this.bEngine.printProfile();
    }

    public boolean accept(Object object) {
        Triple triple = (Triple)object;
        if (triple.getSubject().isLiteral()) {
            return true;
        }
        if (JenaParameters.enableFilteringOfHiddenInfNodes && this.hiddenNodes != null && (this.hiddenNodes.contains(triple.getSubject()) || this.hiddenNodes.contains(triple.getObject()))) {
            return true;
        }
        return this.filterFunctors && Functor.isFunctor(triple.getObject());
    }

    public static class RuleStore {
        protected List rawRules;
        protected Object fRuleStore;
        protected List bRules;

        public RuleStore(List list, Object object, List list2) {
            this.rawRules = list;
            this.fRuleStore = object;
            this.bRules = list2;
        }
    }
}

