/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.dig.test;

import com.hp.hpl.jena.ontology.EnumeratedClass;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.reasoner.dig.DIGAdapter;
import com.hp.hpl.jena.reasoner.dig.DIGConnection;
import com.hp.hpl.jena.reasoner.dig.DIGReasoner;
import com.hp.hpl.jena.reasoner.dig.DIGReasonerFactory;
import com.hp.hpl.jena.reasoner.test.TestUtil;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestDigReasoner
extends TestCase {
    protected Model m_base;

    public TestDigReasoner(String string) {
        super(string);
    }

    public static TestSuite suite() {
        TestSuite testSuite = new TestSuite("TestDigReasoner");
        TestDigReasoner.buildConceptLangSuite("testing/ontology/dig/owl/cl", OntModelSpec.OWL_MEM, testSuite);
        TestDigReasoner.buildBasicQuerySuite("testing/ontology/dig/owl/basicq", OntModelSpec.OWL_MEM, testSuite);
        testSuite.addTestSuite(TestDigReasoner.class);
        return testSuite;
    }

    public void setUp() {
        OntDocumentManager.getInstance().reset(true);
    }

    public void testAxioms() {
        String string = "http://example.org/foo#";
        DIGReasoner dIGReasoner = ReasonerRegistry.getDIGReasoner();
        DIGReasoner dIGReasoner2 = ReasonerRegistry.getDIGReasoner(OWL.NAMESPACE, null);
        DIGReasoner dIGReasoner3 = ReasonerRegistry.getDIGReasoner(DAML_OIL.NAMESPACE_DAML, null);
        DIGReasoner dIGReasoner4 = ReasonerRegistry.getDIGReasoner(OWL.NAMESPACE, true, null);
        DIGReasoner dIGReasoner5 = ReasonerRegistry.getDIGReasoner(DAML_OIL.NAMESPACE_DAML, true, null);
        this.axiomTestAux(dIGReasoner, OntModelSpec.OWL_MEM, false, false);
        this.axiomTestAux(dIGReasoner2, OntModelSpec.OWL_MEM, false, false);
        this.axiomTestAux(dIGReasoner3, OntModelSpec.DAML_MEM, false, false);
        this.axiomTestAux(dIGReasoner4, OntModelSpec.OWL_MEM, true, false);
        this.axiomTestAux(dIGReasoner5, OntModelSpec.DAML_MEM, false, true);
    }

    private void axiomTestAux(DIGReasoner dIGReasoner, OntModelSpec ontModelSpec, boolean bl, boolean bl2) {
        OntModelSpec ontModelSpec2 = new OntModelSpec(ontModelSpec);
        ontModelSpec2.setReasoner(dIGReasoner);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec2, null);
        TestDigReasoner.assertEquals((String)"Result for owl:ObjectProperty", (boolean)bl, (boolean)ontModel.contains(OWL.ObjectProperty, RDF.type, RDFS.Class));
        TestDigReasoner.assertEquals((String)"Result for daml:ObjectProperty", (boolean)bl2, (boolean)ontModel.contains(DAML_OIL.ObjectProperty, RDF.type, RDFS.Class));
    }

    public void testQueryAllConcepts() {
        String string = "http://example.org/foo#";
        DIGReasoner dIGReasoner = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        ontModelSpec.setReasoner(dIGReasoner);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, null);
        ontModel.read("file:testing/ontology/dig/owl/test1.xml");
        TestUtil.assertIteratorValues(this, ontModel.listClasses(), new Resource[]{ontModel.getResource(string + "A"), ontModel.getResource(string + "B"), ontModel.getResource(string + "C"), ontModel.getResource(string + "D"), ontModel.getResource(string + "E"), ontModel.getResource(string + "BB"), ontModel.getResource(string + "F0"), ontModel.getResource(string + "F1"), ontModel.getResource(string + "F2")}, 2);
    }

    public void testQuerySubsumes1() {
        String string = "http://example.org/foo#";
        DIGReasoner dIGReasoner = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        ontModelSpec.setReasoner(dIGReasoner);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, null);
        ontModel.read("file:testing/ontology/dig/owl/test1.xml");
        OntClass ontClass = ontModel.getOntClass(string + "A");
        OntClass ontClass2 = ontModel.getOntClass(string + "B");
        TestDigReasoner.assertTrue((String)"A should be a sub-class of B", (boolean)ontClass.hasSuperClass(ontClass2));
    }

    public void testQuerySubsumes2() {
        String string = "http://example.org/foo#";
        DIGReasoner dIGReasoner = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        ontModelSpec.setReasoner(dIGReasoner);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, null);
        ontModel.read("file:testing/ontology/dig/owl/test1.xml");
        OntClass ontClass = ontModel.getOntClass(string + "C");
        OntClass ontClass2 = ontModel.getOntClass(string + "D");
        TestDigReasoner.assertTrue((String)"D should be a sub-class of C", (boolean)ontClass2.hasSuperClass(ontClass));
    }

    public void testQuerySubsumes3() {
        String string = "http://example.org/foo#";
        DIGReasoner dIGReasoner = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        ontModelSpec.setReasoner(dIGReasoner);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, null);
        ontModel.read("file:testing/ontology/dig/owl/test1.xml");
        OntClass ontClass = ontModel.getOntClass(string + "A");
        OntClass ontClass2 = ontModel.getOntClass(string + "C");
        TestDigReasoner.assertFalse((String)"A should not be a super-class of C", (boolean)ontClass2.hasSuperClass(ontClass));
        TestDigReasoner.assertFalse((String)"C should not be a super-class of A", (boolean)ontClass.hasSuperClass(ontClass2));
    }

    public void testAncestors() {
        String string = "http://example.org/foo#";
        DIGReasoner dIGReasoner = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        ontModelSpec.setReasoner(dIGReasoner);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, null);
        ontModel.read("file:testing/ontology/dig/owl/test1.xml");
        OntClass ontClass = ontModel.getOntClass(string + "A");
        OntClass ontClass2 = ontModel.getOntClass(string + "B");
        OntClass ontClass3 = ontModel.getOntClass(string + "BB");
        TestUtil.assertIteratorValues(this, ontClass.listSuperClasses(), new Resource[]{ontClass2, ontClass3});
    }

    public void testDescendants() {
        String string = "http://example.org/foo#";
        DIGReasoner dIGReasoner = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        ontModelSpec.setReasoner(dIGReasoner);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, null);
        ontModel.read("file:testing/ontology/dig/owl/test1.xml");
        OntClass ontClass = ontModel.getOntClass(string + "A");
        OntClass ontClass2 = ontModel.getOntClass(string + "B");
        OntClass ontClass3 = ontModel.getOntClass(string + "BB");
        TestUtil.assertIteratorValues(this, ontClass3.listSubClasses(), new Resource[]{ontClass2, ontClass});
    }

    public void testAllClassHierarchy() {
        String string = "http://example.org/foo#";
        DIGReasoner dIGReasoner = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        ontModelSpec.setReasoner(dIGReasoner);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, null);
        ontModel.read("file:testing/ontology/dig/owl/test1.xml");
        OntClass ontClass = ontModel.getOntClass(string + "A");
        OntClass ontClass2 = ontModel.getOntClass(string + "B");
        OntClass ontClass3 = ontModel.getOntClass(string + "BB");
        OntClass ontClass4 = ontModel.getOntClass(string + "C");
        OntClass ontClass5 = ontModel.getOntClass(string + "D");
        OntClass ontClass6 = ontModel.getOntClass(string + "E");
        OntClass ontClass7 = ontModel.getOntClass(string + "F0");
        OntClass ontClass8 = ontModel.getOntClass(string + "F1");
        OntClass ontClass9 = ontModel.getOntClass(string + "F2");
        TestUtil.assertIteratorValues(this, ontModel.listStatements(null, RDFS.subClassOf, (RDFNode)null), new Statement[]{ontModel.createStatement((Resource)ontClass, RDFS.subClassOf, ontClass), ontModel.createStatement((Resource)ontClass, RDFS.subClassOf, ontClass2), ontModel.createStatement((Resource)ontClass, RDFS.subClassOf, ontClass3), ontModel.createStatement((Resource)ontClass2, RDFS.subClassOf, ontClass2), ontModel.createStatement((Resource)ontClass2, RDFS.subClassOf, ontClass3), ontModel.createStatement((Resource)ontClass3, RDFS.subClassOf, ontClass3), ontModel.createStatement((Resource)ontClass4, RDFS.subClassOf, ontClass4), ontModel.createStatement((Resource)ontClass5, RDFS.subClassOf, ontClass5), ontModel.createStatement((Resource)ontClass5, RDFS.subClassOf, ontClass4), ontModel.createStatement((Resource)ontClass6, RDFS.subClassOf, ontClass4), ontModel.createStatement((Resource)ontClass6, RDFS.subClassOf, ontClass6), ontModel.createStatement((Resource)ontClass7, RDFS.subClassOf, ontClass7), ontModel.createStatement((Resource)ontClass8, RDFS.subClassOf, ontClass8), ontModel.createStatement((Resource)ontClass9, RDFS.subClassOf, ontClass9)}, 2);
    }

    public void testQueryDisjoint1() {
        String string = "http://example.org/foo#";
        DIGReasoner dIGReasoner = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        ontModelSpec.setReasoner(dIGReasoner);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, null);
        ontModel.read("file:testing/ontology/dig/owl/test1.xml");
        OntClass ontClass = ontModel.getOntClass(string + "A");
        OntClass ontClass2 = ontModel.getOntClass(string + "C");
        TestDigReasoner.assertTrue((String)"A should be disjoint with C", (boolean)ontClass.isDisjointWith(ontClass2));
        TestDigReasoner.assertTrue((String)"C should be disjoint with A", (boolean)ontClass2.isDisjointWith(ontClass));
    }

    public void testQueryDisjoint2() {
        String string = "http://example.org/foo#";
        DIGReasoner dIGReasoner = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        ontModelSpec.setReasoner(dIGReasoner);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, null);
        ontModel.read("file:testing/ontology/dig/owl/test1.xml");
        OntClass ontClass = ontModel.getOntClass(string + "F0");
        OntClass ontClass2 = ontModel.getOntClass(string + "F1");
        TestDigReasoner.assertTrue((String)"F0 should be disjoint with F1", (boolean)ontClass.isDisjointWith(ontClass2));
        TestDigReasoner.assertTrue((String)"F1 should be disjoint with F0", (boolean)ontClass2.isDisjointWith(ontClass));
    }

    public void testParents() {
        String string = "http://example.org/foo#";
        DIGReasoner dIGReasoner = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        ontModelSpec.setReasoner(dIGReasoner);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, null);
        ontModel.read("file:testing/ontology/dig/owl/test1.xml");
        OntClass ontClass = ontModel.getOntClass(string + "A");
        OntClass ontClass2 = ontModel.getOntClass(string + "B");
        TestUtil.assertIteratorValues(this, ontClass.listSuperClasses(true), new Resource[]{ontClass2});
    }

    public void testChildren() {
        String string = "http://example.org/foo#";
        DIGReasoner dIGReasoner = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        ontModelSpec.setReasoner(dIGReasoner);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, null);
        ontModel.read("file:testing/ontology/dig/owl/test1.xml");
        OntClass ontClass = ontModel.getOntClass(string + "B");
        OntClass ontClass2 = ontModel.getOntClass(string + "BB");
        TestUtil.assertIteratorValues(this, ontClass2.listSubClasses(true), new Resource[]{ontClass});
    }

    public void testEquivalents() {
        String string = "http://example.org/foo#";
        DIGReasoner dIGReasoner = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        ontModelSpec.setReasoner(dIGReasoner);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, null);
        ontModel.read("file:testing/ontology/dig/owl/test1.xml");
        OntClass ontClass = ontModel.getOntClass(string + "F0");
        OntClass ontClass2 = ontModel.getOntClass(string + "F2");
        OntClass ontClass3 = ontModel.getOntClass(string + "F1");
        TestUtil.assertIteratorValues(this, ontClass.listEquivalentClasses(), new Resource[]{ontClass2, ontClass}, 1);
        TestUtil.assertIteratorValues(this, ontClass2.listEquivalentClasses(), new Resource[]{ontClass, ontClass2}, 1);
        TestUtil.assertIteratorValues(this, ontClass3.listEquivalentClasses(), new Resource[]{ontClass3}, 1);
    }

    public void testIsEquivalent() {
        String string = "http://example.org/foo#";
        DIGReasoner dIGReasoner = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        ontModelSpec.setReasoner(dIGReasoner);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, null);
        ontModel.read("file:testing/ontology/dig/owl/test1.xml");
        OntClass ontClass = ontModel.getOntClass(string + "F0");
        OntClass ontClass2 = ontModel.getOntClass(string + "F2");
        OntClass ontClass3 = ontModel.getOntClass(string + "F1");
        TestDigReasoner.assertTrue((String)"F0 should be equivalent to F2", (boolean)ontClass.hasEquivalentClass(ontClass2));
        TestDigReasoner.assertFalse((String)"F0 should not be equivalent to F1", (boolean)ontClass3.hasEquivalentClass(ontClass));
    }

    public void testRAncestors() {
        String string = "http://example.org/foo#";
        DIGReasoner dIGReasoner = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        ontModelSpec.setReasoner(dIGReasoner);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, null);
        ontModel.read("file:testing/ontology/dig/owl/test1.xml");
        ObjectProperty objectProperty = ontModel.getObjectProperty(string + "p0");
        ObjectProperty objectProperty2 = ontModel.getObjectProperty(string + "p1");
        ObjectProperty objectProperty3 = ontModel.getObjectProperty(string + "p2");
        TestUtil.assertIteratorValues(this, objectProperty.listSuperProperties(), new Resource[]{objectProperty2, objectProperty3, objectProperty});
    }

    public void testRDescendants() {
        String string = "http://example.org/foo#";
        DIGReasoner dIGReasoner = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        ontModelSpec.setReasoner(dIGReasoner);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, null);
        ontModel.read("file:testing/ontology/dig/owl/test1.xml");
        ObjectProperty objectProperty = ontModel.getObjectProperty(string + "p0");
        ObjectProperty objectProperty2 = ontModel.getObjectProperty(string + "p1");
        ObjectProperty objectProperty3 = ontModel.getObjectProperty(string + "p2");
        TestUtil.assertIteratorValues(this, objectProperty3.listSubProperties(), new Resource[]{objectProperty2, objectProperty, objectProperty3});
    }

    public void testRParents() {
        String string = "http://example.org/foo#";
        DIGReasoner dIGReasoner = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        ontModelSpec.setReasoner(dIGReasoner);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, null);
        ontModel.read("file:testing/ontology/dig/owl/test1.xml");
        ObjectProperty objectProperty = ontModel.getObjectProperty(string + "p0");
        ObjectProperty objectProperty2 = ontModel.getObjectProperty(string + "p1");
        TestUtil.assertIteratorValues(this, objectProperty.listSuperProperties(true), new Resource[]{objectProperty2});
    }

    public void testRChildren() {
        String string = "http://example.org/foo#";
        DIGReasoner dIGReasoner = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        ontModelSpec.setReasoner(dIGReasoner);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, null);
        ontModel.read("file:testing/ontology/dig/owl/test1.xml");
        ObjectProperty objectProperty = ontModel.getObjectProperty(string + "p1");
        ObjectProperty objectProperty2 = ontModel.getObjectProperty(string + "p2");
        TestUtil.assertIteratorValues(this, objectProperty2.listSubProperties(true), new Resource[]{objectProperty});
    }

    public void testInstances() {
        String string = "http://example.org/foo#";
        DIGReasoner dIGReasoner = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        ontModelSpec.setReasoner(dIGReasoner);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, null);
        ontModel.read("file:testing/ontology/dig/owl/test1.xml");
        OntClass ontClass = ontModel.getOntClass(string + "F0");
        Resource resource = ontModel.getResource(string + "i0");
        Resource resource2 = ontModel.getResource(string + "i1");
        Resource resource3 = ontModel.getResource(string + "i2");
        Resource resource4 = ontModel.getResource(string + "q0");
        Resource resource5 = ontModel.getResource(string + "q1");
        Resource resource6 = ontModel.getResource(string + "q2");
        TestUtil.assertIteratorValues(this, ontClass.listInstances(), new Resource[]{resource, resource2, resource3, resource4, resource6, resource5});
    }

    public void testTypes() {
        String string = "http://example.org/foo#";
        DIGReasoner dIGReasoner = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        ontModelSpec.setReasoner(dIGReasoner);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, null);
        ontModel.read("file:testing/ontology/dig/owl/test1.xml");
        OntClass ontClass = ontModel.getOntClass(string + "F0");
        OntClass ontClass2 = ontModel.getOntClass(string + "F2");
        Individual individual = ontModel.getIndividual(string + "i0");
        TestUtil.assertIteratorValues(this, individual.listRDFTypes(false), new Resource[]{ontClass, ontClass2}, 1);
    }

    public void testInstance() {
        String string = "http://example.org/foo#";
        DIGReasoner dIGReasoner = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        ontModelSpec.setReasoner(dIGReasoner);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, null);
        ontModel.read("file:testing/ontology/dig/owl/test1.xml");
        OntClass ontClass = ontModel.getOntClass(string + "F0");
        OntClass ontClass2 = ontModel.getOntClass(string + "F1");
        Individual individual = ontModel.getIndividual(string + "i0");
        TestDigReasoner.assertTrue((String)"i0 should be an instance of F0", (boolean)individual.hasRDFType(ontClass));
        TestDigReasoner.assertFalse((String)"i0 should not be an instance of F1", (boolean)individual.hasRDFType(ontClass2));
    }

    public void testRoleFillers() {
        String string = "http://example.org/foo#";
        DIGReasoner dIGReasoner = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        ontModelSpec.setReasoner(dIGReasoner);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, null);
        ontModel.read("file:testing/ontology/dig/owl/test1.xml");
        Individual individual = ontModel.getIndividual(string + "q0");
        Individual individual2 = ontModel.getIndividual(string + "q1");
        Individual individual3 = ontModel.getIndividual(string + "q2");
        Property property = ontModel.getProperty(string + "q");
        TestUtil.assertIteratorValues(this, individual.listPropertyValues(property), new Resource[]{individual2, individual3}, 0);
    }

    public void testIncrementalAdd() {
        String string = "http://example.org/foo#";
        DIGReasoner dIGReasoner = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        ontModelSpec.setReasoner(dIGReasoner);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, null);
        OntClass ontClass = ontModel.createClass(string + "F0");
        OntClass ontClass2 = ontModel.createClass(string + "F1");
        OntClass ontClass3 = ontModel.createClass(string + "F2");
        Individual individual = ontModel.createIndividual(string + "i0", ontClass);
        TestDigReasoner.assertFalse((String)"i0 is not an F2", (boolean)individual.hasRDFType(ontClass3));
        ontClass.addSuperClass(ontClass2);
        ontClass2.addSuperClass(ontClass3);
        TestDigReasoner.assertTrue((String)"i0 should now be an F2", (boolean)individual.hasRDFType(ontClass3));
    }

    public void testIncrementalRemove() {
        String string = "http://example.org/foo#";
        DIGReasoner dIGReasoner = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        ontModelSpec.setReasoner(dIGReasoner);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, null);
        OntClass ontClass = ontModel.createClass(string + "F0");
        OntClass ontClass2 = ontModel.createClass(string + "F1");
        OntClass ontClass3 = ontModel.createClass(string + "F2");
        Individual individual = ontModel.createIndividual(string + "i0", ontClass);
        ontClass.addSuperClass(ontClass2);
        ontClass2.addSuperClass(ontClass3);
        TestDigReasoner.assertTrue((String)"i0 is an F2", (boolean)individual.hasRDFType(ontClass3));
        ontClass.removeSuperClass(ontClass2);
        TestDigReasoner.assertFalse((String)"i0 should now not be an F2", (boolean)individual.hasRDFType(ontClass3));
    }

    public void test_bug_codebaker_01() {
        String string = "http://www.owl-ontologies.com/pizza.owl#";
        DIGReasoner dIGReasoner = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        ontModelSpec.setReasoner(dIGReasoner);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, null);
        ontModel.read("file:testing/ontology/bugs/test_codebaker_01.owl");
        OntClass ontClass = ontModel.getOntClass(string + "MargheritaPizza");
        OntClass ontClass2 = ontModel.getOntClass(string + "CheesyPizza");
        TestDigReasoner.assertTrue((String)"MargheritaPizza should be cheesy", (boolean)ontClass.hasSuperClass(ontClass2));
    }

    public void test_bug_koala_01() {
        Model model = ModelFactory.createDefaultModel();
        Resource resource = model.createResource();
        resource.addProperty(ReasonerVocabulary.EXT_REASONER_URL, model.createResource("http://localhost:8081"));
        DIGReasonerFactory dIGReasonerFactory = (DIGReasonerFactory)ReasonerRegistry.theRegistry().getFactory("http://jena.hpl.hp.com/2003/DIGReasoner");
        DIGReasoner dIGReasoner = (DIGReasoner)dIGReasonerFactory.create(resource);
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        ontModelSpec.setReasoner(dIGReasoner);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, null);
        ontModel.getDocumentManager().addAltEntry("http://protege.stanford.edu/plugins/owl/owl-library/koala.owl", "file:testing/ontology/bugs/koala.owl");
        ontModel.read("http://protege.stanford.edu/plugins/owl/owl-library/koala.owl");
        StmtIterator stmtIterator = ontModel.listStatements(null, OWL.equivalentClass, OWL.Nothing);
        int n = 0;
        while (stmtIterator.hasNext()) {
            Resource resource2 = stmtIterator.nextStatement().getSubject();
            ++n;
        }
        TestDigReasoner.assertEquals((String)"Should be 4 unsatisfiable classes", (int)4, (int)n);
    }

    public void test_bug_mo_1() {
        String string = "http://example.org/foo#";
        DIGReasoner dIGReasoner = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        ontModelSpec.setReasoner(dIGReasoner);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, null);
        OntClass ontClass = ontModel.createClass(string + "A");
        Individual individual = ontModel.createIndividual(string + "i0", ontClass);
        int n = 0;
        int n2 = 0;
        StmtIterator stmtIterator = ontModel.listStatements(null, RDF.type, ontModel.getResource(string + "A"));
        while (stmtIterator.hasNext()) {
            if (stmtIterator.nextStatement().getSubject().getURI().equals(string + "i0")) {
                ++n;
                continue;
            }
            ++n2;
        }
        TestDigReasoner.assertEquals((String)"Should be no non i0's", (int)0, (int)n2);
        TestDigReasoner.assertEquals((String)"Should be only one i0", (int)1, (int)n);
    }

    public void xxtestDebug1() {
        String string = "http://example.org/foo#";
        OntModel ontModel = ModelFactory.createOntologyModel(OntModelSpec.OWL_DL_MEM, null);
        Individual individual = ontModel.createIndividual(string + "a", OWL.Thing);
        Individual individual2 = ontModel.createIndividual(string + "b", OWL.Thing);
        EnumeratedClass enumeratedClass = ontModel.createEnumeratedClass(string + "A", ontModel.createList(new Resource[]{individual, individual2}));
        DIGReasoner dIGReasoner = (DIGReasoner)ReasonerRegistry.theRegistry().create("http://jena.hpl.hp.com/2003/DIGReasoner", null);
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        ontModelSpec.setReasoner(dIGReasoner);
        OntModel ontModel2 = ModelFactory.createOntologyModel(ontModelSpec, ontModel);
        ExtendedIterator extendedIterator = ontModel2.listClasses();
        while (extendedIterator.hasNext()) {
            System.err.println("concept " + extendedIterator.next());
        }
    }

    public void xxtestDebug() {
        String string = "http://example.org/foo#";
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_DL_MEM_RULE_INF);
        OntModel ontModel = ModelFactory.createOntologyModel(ontModelSpec, null);
        ontModel.read("file:testing/ontology/dig/owl/test1.xml");
        ObjectProperty objectProperty = ontModel.getObjectProperty(string + "p2");
        StmtIterator stmtIterator = ontModel.listStatements(null, RDFS.subPropertyOf, objectProperty);
        while (stmtIterator.hasNext()) {
            System.err.println("p2 has sub prop " + stmtIterator.next());
        }
    }

    private static void buildConceptLangSuite(String string, OntModelSpec ontModelSpec, TestSuite testSuite) {
        int n = 0;
        while (true) {
            File file = new File(string + "/test_" + n + ".source.xml");
            File file2 = new File(string + "/test_" + n + ".xml");
            if (!file.exists()) break;
            ++n;
            testSuite.addTest((Test)new DigTranslationTest(file, file2, ontModelSpec));
        }
    }

    private static void buildBasicQuerySuite(String string, OntModelSpec ontModelSpec, TestSuite testSuite) {
        int n = 0;
        while (true) {
            File file = new File(string + "/test_" + n + ".source.xml");
            File file2 = new File(string + "/test_" + n + ".query.xml");
            File file3 = new File(string + "/test_" + n + ".result.xml");
            if (!file.exists()) break;
            ++n;
            testSuite.addTest((Test)new DigBasicQueryTest(file, file3, file2, ontModelSpec));
        }
    }

    private static class DigBasicQueryTest
    extends AbstractDigTest {
        private File m_source;
        private File m_target;
        private File m_query;
        private OntModelSpec m_spec;

        DigBasicQueryTest(File file, File file2, File file3, OntModelSpec ontModelSpec) {
            super("BasicQueryTest " + file.getName());
            this.m_source = file;
            this.m_target = file2;
            this.m_query = file3;
            this.m_spec = ontModelSpec;
        }

        public void runTest() throws Exception {
            Object object;
            boolean bl;
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Model model = ModelFactory.createDefaultModel();
            model.read(new FileInputStream(this.m_source), null);
            DIGAdapter dIGAdapter = new DIGAdapter(this.m_spec, model.getGraph());
            dIGAdapter.resetKB();
            boolean bl2 = bl = !dIGAdapter.uploadKB();
            if (bl) {
                System.err.println("00 Warning!");
                object = dIGAdapter.getConnection().getWarnings();
                while (object.hasNext()) {
                    System.err.println(object.next());
                }
                DigBasicQueryTest.assertFalse((String)"Should not be upload warnings", (boolean)bl);
            }
            object = documentBuilder.parse(this.m_query);
            Document document = documentBuilder.parse(this.m_target);
            LogFactory.getLog(((Object)((Object)this)).getClass()).debug((Object)("DIG test " + this.m_source.getPath()));
            Document document2 = dIGAdapter.getConnection().sendDigVerb((Document)object, dIGAdapter.getProfile());
            dIGAdapter.getConnection().errorCheck(document2);
            DigBasicQueryTest.assertFalse((String)"Should not be warnings", (boolean)dIGAdapter.getConnection().warningCheck(document2));
            dIGAdapter.close();
            this.xmlEqualityTest(document2, document);
        }
    }

    private static class DigTranslationTest
    extends AbstractDigTest {
        private File m_source;
        private File m_target;
        private OntModelSpec m_spec;

        DigTranslationTest(File file, File file2, OntModelSpec ontModelSpec) {
            super("DigTranslationTest " + file.getName());
            this.m_source = file;
            this.m_target = file2;
            this.m_spec = ontModelSpec;
        }

        public void runTest() throws Exception {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Model model = ModelFactory.createDefaultModel();
            model.read(new FileInputStream(this.m_source), null);
            DIGAdapter dIGAdapter = new DIGAdapter(this.m_spec, model.getGraph());
            Document document = documentBuilder.parse(this.m_target);
            Document document2 = dIGAdapter.translateKbToDig();
            this.xmlEqualityTest(document2, document);
        }
    }

    private static class AbstractDigTest
    extends TestCase {
        private boolean debug = true;

        public AbstractDigTest(String string) {
            super(string);
        }

        protected void xmlEqualityTest(Document document, Document document2) {
            PrintWriter printWriter;
            boolean bl = this.xmlEqualityTest(document.getDocumentElement(), document2.getDocumentElement());
            if (this.debug && !bl) {
                printWriter = new PrintWriter(System.err);
                printWriter.println(this.getName() + " expected:");
                new DIGConnection().serialiseDocument(document2, printWriter);
                printWriter.println();
                printWriter.println("Saw:");
                new DIGConnection().serialiseDocument(document, printWriter);
                printWriter.println();
            }
            AbstractDigTest.assertTrue((String)"Failed to match source to target documents", (boolean)bl);
            bl = this.xmlEqualityTest(document2.getDocumentElement(), document.getDocumentElement());
            if (this.debug && !bl) {
                printWriter = new PrintWriter(System.err);
                printWriter.println(this.getName() + " expected:");
                new DIGConnection().serialiseDocument(document, printWriter);
                printWriter.println();
                printWriter.println("Saw:");
                new DIGConnection().serialiseDocument(document2, printWriter);
                printWriter.println();
            }
            AbstractDigTest.assertTrue((String)"Failed to match target to source documents", (boolean)bl);
        }

        private boolean xmlEqualityTest(Element element, Element element2) {
            boolean bl = element.getNodeName().equals(element2.getNodeName());
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; bl && i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                bl = this.findElementMatch((Element)node, element2);
            }
            NamedNodeMap namedNodeMap = element.getAttributes();
            for (int i = 0; bl && i < namedNodeMap.getLength(); ++i) {
                bl = this.findAttributeMatch((Attr)namedNodeMap.item(i), element2);
            }
            return bl;
        }

        private boolean findElementMatch(Element element, Element element2) {
            boolean bl = false;
            NodeList nodeList = element2.getElementsByTagName(element.getNodeName());
            for (int i = 0; !bl && i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element) || !element.getNodeName().equals(node.getNodeName())) continue;
                bl = this.xmlEqualityTest(element, (Element)node);
            }
            return bl;
        }

        private boolean findAttributeMatch(Attr attr, Element element) {
            String string = attr.getValue();
            String string2 = element.getAttribute(attr.getName());
            return string.startsWith("anon:") && string2.startsWith("anon:") || string.equals(string2);
        }
    }
}

