/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.dig;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.dig.DIGAdapter;
import com.hp.hpl.jena.reasoner.dig.DIGConnection;
import com.hp.hpl.jena.reasoner.dig.DIGQueryTranslator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DIGQueryRoleFillersTranslator
extends DIGQueryTranslator {
    public DIGQueryRoleFillersTranslator() {
        super(null, null, "*");
    }

    public Document translatePattern(TriplePattern triplePattern, DIGAdapter dIGAdapter) {
        DIGConnection dIGConnection = dIGAdapter.getConnection();
        Document document = dIGConnection.createDigVerb("asks", dIGAdapter.getProfile());
        Element element = dIGAdapter.createQueryElement(document, "roleFillers");
        dIGAdapter.addNamedElement(element, "individual", dIGAdapter.getNodeID(triplePattern.getSubject()));
        dIGAdapter.addNamedElement(element, "ratom", dIGAdapter.getNodeID(triplePattern.getPredicate()));
        return document;
    }

    public ExtendedIterator translateResponse(Document document, TriplePattern triplePattern, DIGAdapter dIGAdapter) {
        return this.translateIndividualSetResponse(document, triplePattern, true);
    }

    public Document translatePattern(TriplePattern triplePattern, DIGAdapter dIGAdapter, Model model) {
        return null;
    }

    public boolean checkSubject(Node node, DIGAdapter dIGAdapter, Model model) {
        return node.isConcrete() && dIGAdapter.isIndividual(node);
    }

    public boolean checkPredicate(Node node, DIGAdapter dIGAdapter, Model model) {
        if (node.isConcrete()) {
            Resource resource = (Resource)dIGAdapter.m_sourceData.getRDFNode(node);
            return !dIGAdapter.m_sourceData.contains(resource, RDF.type, dIGAdapter.m_sourceData.getProfile().DATATYPE_PROPERTY());
        }
        return false;
    }
}

