/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.dig;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.dig.DIGAdapter;
import com.hp.hpl.jena.reasoner.dig.DIGConnection;
import com.hp.hpl.jena.reasoner.dig.DIGQueryTranslator;
import com.hp.hpl.jena.reasoner.dig.DIGValueToNodeMapper;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import com.hp.hpl.jena.util.xml.SimpleXMLPath;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DIGQueryRoleFillerTranslator
extends DIGQueryTranslator {
    public DIGQueryRoleFillerTranslator() {
        super(null, null, null);
    }

    public Document translatePattern(TriplePattern triplePattern, DIGAdapter dIGAdapter) {
        DIGConnection dIGConnection = dIGAdapter.getConnection();
        Document document = dIGConnection.createDigVerb("asks", dIGAdapter.getProfile());
        Element element = dIGAdapter.createQueryElement(document, "roleFillers");
        dIGAdapter.addNamedElement(element, "individual", dIGAdapter.getNodeID(triplePattern.getSubject()));
        dIGAdapter.addNamedElement(element, "ratom", dIGAdapter.getNodeID(triplePattern.getPredicate()));
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtendedIterator translateResponse(Document document, TriplePattern triplePattern, DIGAdapter dIGAdapter) {
        SimpleXMLPath simpleXMLPath = new SimpleXMLPath(true);
        simpleXMLPath.appendElementPath("individualSet");
        simpleXMLPath.appendElementPath("individual");
        simpleXMLPath.appendAttrPath("name");
        ArrayList<Triple> arrayList = new ArrayList<Triple>();
        ExtendedIterator extendedIterator = simpleXMLPath.getAll(document).mapWith(new DIGValueToNodeMapper());
        try {
            while (extendedIterator.hasNext()) {
                Node node = (Node)extendedIterator.next();
                if (!node.equals(triplePattern.getObject())) continue;
                arrayList.add(triplePattern.asTriple());
                break;
            }
        }
        finally {
            extendedIterator.close();
        }
        return WrappedIterator.create(arrayList.iterator());
    }

    public Document translatePattern(TriplePattern triplePattern, DIGAdapter dIGAdapter, Model model) {
        return this.translatePattern(triplePattern, dIGAdapter);
    }

    public boolean checkSubject(Node node, DIGAdapter dIGAdapter, Model model) {
        return node.isConcrete() && dIGAdapter.isIndividual(node);
    }

    public boolean checkObject(Node node, DIGAdapter dIGAdapter, Model model) {
        return node.isConcrete() && dIGAdapter.isIndividual(node);
    }

    public boolean checkPredicate(Node node, DIGAdapter dIGAdapter, Model model) {
        if (node.isConcrete()) {
            Resource resource = (Resource)dIGAdapter.m_sourceData.getRDFNode(node);
            return !dIGAdapter.m_sourceData.contains(resource, RDF.type, dIGAdapter.m_sourceData.getProfile().DATATYPE_PROPERTY());
        }
        return false;
    }
}

