/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.dig;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.dig.DIGAdapter;
import com.hp.hpl.jena.reasoner.dig.DIGConnection;
import com.hp.hpl.jena.reasoner.dig.DIGQueryTranslator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import com.hp.hpl.jena.util.iterator.SingletonIterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DIGQueryInstanceTranslator
extends DIGQueryTranslator {
    public DIGQueryInstanceTranslator(String string) {
        super(null, string, null);
    }

    public Document translatePattern(TriplePattern triplePattern, DIGAdapter dIGAdapter) {
        DIGConnection dIGConnection = dIGAdapter.getConnection();
        Document document = dIGConnection.createDigVerb("asks", dIGAdapter.getProfile());
        Element element = dIGAdapter.createQueryElement(document, "instance");
        dIGAdapter.addNamedElement(element, "individual", dIGAdapter.getNodeID(triplePattern.getSubject()));
        dIGAdapter.addClassDescription(element, triplePattern.getObject());
        return document;
    }

    public Document translatePattern(TriplePattern triplePattern, DIGAdapter dIGAdapter, Model model) {
        DIGConnection dIGConnection = dIGAdapter.getConnection();
        Document document = dIGConnection.createDigVerb("asks", dIGAdapter.getProfile());
        Element element = dIGAdapter.createQueryElement(document, "instance");
        dIGAdapter.addNamedElement(element, "individual", dIGAdapter.getNodeID(triplePattern.getSubject()));
        if (triplePattern.getObject().isBlank()) {
            dIGAdapter.addClassDescription(element, triplePattern.getObject(), model);
        } else {
            dIGAdapter.addClassDescription(element, triplePattern.getObject());
        }
        return document;
    }

    public ExtendedIterator translateResponse(Document document, TriplePattern triplePattern, DIGAdapter dIGAdapter) {
        return this.isFalse(document) ? NullIterator.instance : new SingletonIterator(triplePattern.asTriple());
    }

    public boolean checkObject(Node node, DIGAdapter dIGAdapter, Model model) {
        return dIGAdapter.isConcept(node, model);
    }
}

