/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryEngine;
import com.hp.hpl.jena.rdql.QueryException;
import com.hp.hpl.jena.rdql.QueryExecution;
import com.hp.hpl.jena.rdql.QueryResults;
import com.hp.hpl.jena.rdql.QueryResultsFormatter;
import com.hp.hpl.jena.rdql.QueryResultsMem;
import com.hp.hpl.jena.rdql.test.TestItem;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.FileUtils;
import java.io.IOException;
import java.io.PrintWriter;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryTestScripts
extends TestSuite {
    static final String testSetName = "RDQL - Query - Scripts";
    static final String directory = "testing/RDQL/";
    FileManager fm = null;
    public String basename = null;
    public static boolean printDetails = false;
    public static boolean displayTime = false;
    protected static Log log = LogFactory.getLog((Class)QueryTestScripts.class);
    static PrintWriter out = FileUtils.asPrintWriterUTF8(System.out);
    static int testCounter = 0;

    public static TestSuite suite() {
        return new QueryTestScripts(testSetName);
    }

    public QueryTestScripts(String string) {
        super(string);
        FileManager fileManager = new FileManager();
        fileManager.addLocatorFile(directory);
    }

    public void addTest(TestItem testItem) {
        this.addTest("BRQL-test-" + ++testCounter, testItem);
    }

    public void addTest(String string, TestItem testItem) {
        this.addTest(string, null, testItem);
    }

    public void addTest(String string, String string2, TestItem testItem) {
        this.addTest(null, string, string2, testItem);
    }

    public void addTest(Model model, String string, String string2, TestItem testItem) {
        RDQLTest rDQLTest = new RDQLTest(model, string, this.fm, testItem);
        this.addTest((Test)rDQLTest);
    }

    public static void emptyModel(Model model) {
        if (model == null) {
            return;
        }
        try {
            StmtIterator stmtIterator = model.listStatements();
            while (stmtIterator.hasNext()) {
                stmtIterator.nextStatement();
                stmtIterator.remove();
            }
            stmtIterator.close();
        }
        catch (JenaException jenaException) {
            log.error((Object)"Failed to empty model (com.hp.hpl.jena.rdf.query.Test.QueryTest.emptyModel)", (Throwable)jenaException);
        }
    }

    static String convertFilename(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("file:")) {
            string = string.substring("file:".length());
        }
        if (string2 != null && !string.startsWith("/")) {
            string = string2 + "/" + string;
        }
        return string;
    }

    static String formatlong(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Long.toString(l));
        for (int i = stringBuffer.length(); i < 4; ++i) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    private static class RDQLTest
    extends TestCase {
        static int testCounter = 1;
        static boolean printModelsOnFailure = false;
        Model model;
        int testNumber = testCounter++;
        TestItem testItem;
        FileManager fileManager;

        RDQLTest(Model model, String string, FileManager fileManager, TestItem testItem) {
            super(string);
            this.model = model;
            this.fileManager = fileManager;
            this.testItem = testItem;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void runTest() throws Throwable {
            Query query = null;
            try {
                if (printDetails) {
                    if (this.testNumber != 1) {
                        out.println();
                        out.println("------------------------------------------------------------------------");
                        out.println();
                    }
                    out.println("Test " + this.testNumber + " :: QueryFile=" + this.testItem.getQueryFile() + ", DataFile=" + this.testItem.getDataFile() + ", ResultsFile=" + this.testItem.getResultFile());
                }
                String string = this.fileManager.readWholeFileAsUTF8(this.testItem.getQueryFile());
                if (printDetails) {
                    out.println("Query:");
                    out.println(string);
                    if (!string.endsWith("\n")) {
                        out.println();
                    }
                    out.flush();
                }
                long l = System.currentTimeMillis();
                try {
                    query = new Query(string);
                }
                catch (QueryException queryException) {
                    query = null;
                    out.flush();
                    RDQLTest.assertFalse((String)("Parse failure: " + queryException.getMessage()), (boolean)true);
                    throw queryException;
                }
                if (printDetails) {
                    out.println("Parsed query:");
                    out.println(query.toString());
                    out.flush();
                }
                if (this.model == null) {
                    if (this.testItem.getDataFile() != null && !this.testItem.getDataFile().equals("")) {
                        long l2 = System.currentTimeMillis();
                        Model model = this.fileManager.loadModel(this.testItem.getDataFile());
                        query.setSource(model);
                        query.loadTime = System.currentTimeMillis() - l2;
                    }
                } else {
                    QueryTestScripts.emptyModel(this.model);
                    String string2 = null;
                    if (this.testItem.getDataFile() != null && !this.testItem.getDataFile().equals("")) {
                        string2 = this.testItem.getDataFile();
                    }
                    if (string2 == null) {
                        string2 = query.getSourceURL();
                    }
                    try {
                        long l3 = System.currentTimeMillis();
                        query.setSource(this.fileManager.readModel(this.model, string2));
                        query.loadTime = System.currentTimeMillis() - l3;
                    }
                    catch (JenaException jenaException) {
                        log.warn((Object)("Problems loading data for: " + string2));
                    }
                }
                QueryEngine queryEngine = new QueryEngine(query);
                queryEngine.init();
                this.runTestSelect(query, queryEngine, l);
            }
            catch (IOException iOException) {
                out.println("IOException: " + iOException);
                iOException.printStackTrace(out);
                out.flush();
            }
            catch (Exception exception) {
                out.println("Exception: " + exception);
                exception.printStackTrace(out);
                out.flush();
                Assert.assertTrue((String)("Exception: " + this.testItem.getQueryFile()), (boolean)false);
            }
            finally {
                if (this.model == null && query != null && query.getSource() != null) {
                    query.getSource().close();
                }
                out.flush();
            }
        }

        void runTestSelect(Query query, QueryExecution queryExecution, long l) throws Exception {
            Object object;
            boolean bl;
            QueryResults queryResults = queryExecution.exec();
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            QueryResultsMem queryResultsMem = new QueryResultsMem(queryResults);
            queryResults.close();
            queryResults = null;
            boolean bl2 = bl = this.testItem.getResultFile() != null && !this.testItem.getResultFile().equals("");
            if (printDetails) {
                object = new QueryResultsFormatter(queryResultsMem);
                ((QueryResultsFormatter)object).printAll(out);
                out.println();
                ((QueryResultsFormatter)object).close();
            }
            if (printDetails && displayTime) {
                out.println();
                out.println("Query parse:     " + QueryTestScripts.formatlong(query.parseTime) + " ms");
                out.println("Query build:     " + QueryTestScripts.formatlong(query.buildTime) + " ms");
                out.println("Data load time:  " + QueryTestScripts.formatlong(query.loadTime) + " ms");
                out.println("Query execute:   " + QueryTestScripts.formatlong(query.executeTime) + " ms");
                out.println("Query misc:      " + QueryTestScripts.formatlong(l3 - query.parseTime - query.buildTime - query.loadTime - query.executeTime) + " ms");
                out.println("Query total:     " + QueryTestScripts.formatlong(l3) + " ms");
                out.flush();
            }
            if (bl) {
                try {
                    object = this.fileManager.loadModel(this.testItem.getResultFile());
                    QueryResultsMem queryResultsMem2 = new QueryResultsMem((QueryResults)queryResultsMem);
                    QueryResultsMem queryResultsMem3 = new QueryResultsMem((Model)object);
                    if (!RDQLTest.resultSetEquivalent(queryResultsMem2, queryResultsMem3)) {
                        out.println();
                        out.println("=======================================");
                        out.println("Failure: " + this.testItem.getQueryFile());
                        out.println("Got: " + queryResultsMem2.size() + " ----------------------------------");
                        queryResultsMem2.reset();
                        QueryResultsFormatter queryResultsFormatter = new QueryResultsFormatter(queryResultsMem2);
                        queryResultsFormatter.dump(out, false);
                        queryResultsMem2.reset();
                        if (printModelsOnFailure) {
                            out.println("---------------------------------------");
                            queryResultsFormatter.toModel().write(out, "N3");
                            queryResultsMem2.reset();
                        }
                        out.flush();
                        QueryResultsFormatter queryResultsFormatter2 = new QueryResultsFormatter(queryResultsMem3);
                        out.println("Expected: " + queryResultsMem3.size() + " -----------------------------");
                        queryResultsMem3.reset();
                        queryResultsFormatter2.dump(out, false);
                        queryResultsMem3.reset();
                        if (printModelsOnFailure) {
                            out.println("---------------------------------------");
                            queryResultsFormatter2.toModel().write(out, "N3");
                            queryResultsMem3.reset();
                        }
                        out.println();
                        out.flush();
                        queryResultsFormatter.close();
                        queryResultsFormatter2.close();
                        queryResultsMem2.close();
                        queryResultsMem3.close();
                        Assert.assertTrue((String)("Results do not match: " + this.testItem.getQueryFile()), (boolean)false);
                    }
                }
                catch (Exception exception) {
                    log.warn((Object)"Exception in result testing", (Throwable)exception);
                    Assert.fail((String)("Exception in result testing: " + exception));
                }
            }
            queryResultsMem.close();
        }

        public static boolean resultSetEquivalent(QueryResults queryResults, QueryResults queryResults2) {
            QueryResultsFormatter queryResultsFormatter = new QueryResultsFormatter(queryResults);
            Model model = queryResultsFormatter.toModel();
            QueryResultsFormatter queryResultsFormatter2 = new QueryResultsFormatter(queryResults2);
            Model model2 = queryResultsFormatter2.toModel();
            return model.isIsomorphicWith(model2);
        }

        void runTestConstruct(Query query, QueryExecution queryExecution, long l) throws Exception {
        }

        void runTestDescribe(Query query, QueryExecution queryExecution, long l) throws Exception {
        }

        void runTestAsk(Query query, QueryExecution queryExecution, long l) throws Exception {
        }
    }
}

