/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.ResourceRequiredException;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import junit.framework.TestSuite;

public class TestResourceImpl
extends ModelTestBase {
    public TestResourceImpl(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestResourceImpl.class);
    }

    public void testCannotAsNonLiteral() {
        Model model = ModelFactory.createDefaultModel();
        TestResourceImpl.resource(model, "plumPie").as(Resource.class);
    }

    public void testAsLiteral() {
        Model model = ModelFactory.createDefaultModel();
        try {
            TestResourceImpl.literal(model, "17").as(Resource.class);
            TestResourceImpl.fail((String)"literals cannot be resources");
        }
        catch (ResourceRequiredException resourceRequiredException) {
            TestResourceImpl.pass();
        }
    }

    public void testNameSpace() {
        TestResourceImpl.assertEquals((String)"eg:x", (String)TestResourceImpl.resource("eg:xyz").getNameSpace());
        TestResourceImpl.assertEquals((String)"http://d/", (String)TestResourceImpl.resource("http://d/stuff").getNameSpace());
        TestResourceImpl.assertEquals((String)"ftp://dd.com/12345", (String)TestResourceImpl.resource("ftp://dd.com/12345").getNameSpace());
        TestResourceImpl.assertEquals((String)"http://domain/spoo#", (String)TestResourceImpl.resource("http://domain/spoo#anchor").getNameSpace());
        TestResourceImpl.assertEquals((String)"ftp://abd/def#ghi#", (String)TestResourceImpl.resource("ftp://abd/def#ghi#e11-2").getNameSpace());
    }

    public void testLocalName() {
        TestResourceImpl.assertEquals((String)"yz", (String)TestResourceImpl.resource("eg:xyz").getLocalName());
    }

    public void testHasURI() {
        TestResourceImpl.assertTrue((boolean)TestResourceImpl.resource("eg:xyz").hasURI("eg:xyz"));
        TestResourceImpl.assertFalse((boolean)TestResourceImpl.resource("eg:xyz").hasURI("eg:1yz"));
        TestResourceImpl.assertFalse((boolean)ResourceFactory.createResource().hasURI("42"));
    }
}

