/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.graph.impl.FileGraphMaker;
import com.hp.hpl.jena.graph.impl.SimpleGraphMaker;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.rdf.model.ModelMakerCreator;
import com.hp.hpl.jena.rdf.model.ModelMakerCreatorRegistry;
import com.hp.hpl.jena.rdf.model.ModelSpec;
import com.hp.hpl.jena.rdf.model.ModelSpecCreator;
import com.hp.hpl.jena.rdf.model.ModelSpecCreatorRegistry;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.ModelSpecImpl;
import com.hp.hpl.jena.rdf.model.impl.PlainModelSpec;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.rdf.model.test.TestModelFactory;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.shared.BadDescriptionException;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.FileUtils;
import com.hp.hpl.jena.vocabulary.JMS;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import junit.framework.TestSuite;

public class TestModelSpec
extends ModelTestBase {
    public TestModelSpec(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestModelSpec.class);
    }

    public void testNotFindMaker() {
        Resource resource = TestModelSpec.resource("jms:xyz");
        TestModelSpec.assertSame(null, (Object)ModelMakerCreatorRegistry.findCreator(resource));
    }

    public void testFindMakerChoice() {
        Resource resource = TestModelSpec.resource("jms:type1");
        Resource resource2 = TestModelSpec.resource("jms:type2");
        ModelMakerCreator modelMakerCreator = new ModelMakerCreator(){

            public ModelMaker create(Model model, Resource resource) {
                return null;
            }
        };
        ModelMakerCreator modelMakerCreator2 = new ModelMakerCreator(){

            public ModelMaker create(Model model, Resource resource) {
                return null;
            }
        };
        ModelMakerCreatorRegistry.register(resource, modelMakerCreator);
        ModelMakerCreatorRegistry.register(resource2, modelMakerCreator2);
        TestModelSpec.assertSame((Object)modelMakerCreator, (Object)ModelMakerCreatorRegistry.findCreator(resource));
        TestModelSpec.assertSame((Object)modelMakerCreator2, (Object)ModelMakerCreatorRegistry.findCreator(resource2));
    }

    public void testFindStandardMakers() {
        TestModelSpec.assertNotNull((Object)ModelMakerCreatorRegistry.findCreator(JMS.FileMakerSpec));
        TestModelSpec.assertNotNull((Object)ModelMakerCreatorRegistry.findCreator(JMS.MemMakerSpec));
        TestModelSpec.assertNotNull((Object)ModelMakerCreatorRegistry.findCreator(JMS.RDBMakerSpec));
    }

    public void testDefaultMaker() {
        Model model = TestModelSpec.modelWithStatements("_x jms:maker _y; _y jms:reificationMode jms:rsMinimal");
        ModelSpec modelSpec = ModelFactory.createSpec(model);
        Model model2 = ModelFactory.createModel(modelSpec);
        TestModelSpec.assertTrue((boolean)(model2.getGraph() instanceof GraphMem));
    }

    public void testAbsentDefaultMaker() {
        Model model = TestModelSpec.modelWithStatements("_x rdf:type jms:DefaultModelSpec");
        ModelSpec modelSpec = ModelFactory.createSpec(model);
        Model model2 = ModelFactory.createModel(modelSpec);
        TestModelSpec.assertTrue((boolean)(model2.getGraph() instanceof GraphMem));
    }

    public void testNotFindCreator() {
        Resource resource = TestModelSpec.resource("jms:SomeType");
        TestModelSpec.assertSame(null, (Object)ModelSpecCreatorRegistry.findCreator(resource));
    }

    public void testFindCreator() {
        Resource resource = TestModelSpec.resource("jms:SomeType");
        ModelSpecCreator modelSpecCreator = new ModelSpecCreator(){

            public ModelSpec create(Resource resource, Model model) {
                return null;
            }
        };
        ModelSpecCreatorRegistry.register(resource, modelSpecCreator);
        TestModelSpec.assertSame((Object)modelSpecCreator, (Object)ModelSpecCreatorRegistry.findCreator(resource));
    }

    public void testFindCreatorChoice() {
        Resource resource = TestModelSpec.resource("jms:SomeType1");
        Resource resource2 = TestModelSpec.resource("jms:SomeType2");
        ModelSpecCreator modelSpecCreator = new ModelSpecCreator(){

            public ModelSpec create(Resource resource, Model model) {
                return null;
            }
        };
        ModelSpecCreator modelSpecCreator2 = new ModelSpecCreator(){

            public ModelSpec create(Resource resource, Model model) {
                return null;
            }
        };
        ModelSpecCreatorRegistry.register(resource, modelSpecCreator);
        ModelSpecCreatorRegistry.register(resource2, modelSpecCreator2);
        TestModelSpec.assertSame((Object)modelSpecCreator, (Object)ModelSpecCreatorRegistry.findCreator(resource));
        TestModelSpec.assertSame((Object)modelSpecCreator2, (Object)ModelSpecCreatorRegistry.findCreator(resource2));
    }

    public void testHasStandardCreators() {
        TestModelSpec.assertNotNull((Object)ModelSpecCreatorRegistry.findCreator(JMS.InfModelSpec));
        TestModelSpec.assertNotNull((Object)ModelSpecCreatorRegistry.findCreator(JMS.PlainModelSpec));
        TestModelSpec.assertNotNull((Object)ModelSpecCreatorRegistry.findCreator(JMS.OntModelSpec));
    }

    public void testNamedCreatePlain() {
        ModelSpec modelSpec = ModelSpecImpl.create(TestModelSpec.createPlainModelDesc());
        Model model = modelSpec.createModelOver("aName");
        TestModelSpec.assertTrue((boolean)(model.getGraph() instanceof GraphMem));
    }

    public void testNamedCreateInf() {
        String string = "http://jena.hpl.hp.com/2003/DAMLMicroReasonerFactory";
        ModelSpec modelSpec = ModelSpecImpl.create(TestModelSpec.createInfModelDesc(string));
        Model model = modelSpec.createModelOver("iName");
        TestModelSpec.assertTrue((boolean)(model.getGraph() instanceof InfGraph));
    }

    public void testDetectRootAmbiguity() {
        Model model = TestModelSpec.createPlainModelDesc().add(TestModelSpec.createPlainModelDesc());
        try {
            ModelSpecImpl.create(model);
            TestModelSpec.fail((String)"must trap ambiguous description");
        }
        catch (BadDescriptionException badDescriptionException) {
            TestModelSpec.pass();
        }
    }

    public void testCreateByName() {
        Resource resource = TestModelSpec.resource();
        Model model = TestModelSpec.createPlainModelDesc(resource);
        ModelSpec modelSpec = ModelSpecImpl.create(resource, model);
        TestModelSpec.assertTrue((boolean)(modelSpec.createModel().getGraph() instanceof GraphMem));
    }

    public void testCreateByNameChoice() {
        Resource resource = TestModelSpec.resource();
        Resource resource2 = TestModelSpec.resource();
        String string = "http://jena.hpl.hp.com/2003/DAMLMicroReasonerFactory";
        Model model = TestModelSpec.createPlainModelDesc(resource).add(TestModelSpec.createInfModelDesc(resource2, string));
        ModelSpec modelSpec = ModelSpecImpl.create(resource, model);
        TestModelSpec.assertTrue((boolean)(modelSpec.createModel().getGraph() instanceof GraphMem));
    }

    public void testOntModeSpecIsaModelSpec() {
        TestModelSpec.assertTrue((boolean)(OntModelSpec.DAML_MEM_RULE_INF instanceof ModelSpec));
    }

    public void testOntModelSpecCreatesOntModels() {
        Model model = OntModelSpec.DAML_MEM_RULE_INF.createModel();
        TestModelSpec.assertTrue((boolean)(model instanceof OntModel));
    }

    public void testOntModelSpecDescription() {
        OntModelSpec ontModelSpec = OntModelSpec.DAML_MEM_RULE_INF;
        Model model = ontModelSpec.getDescription();
        TestModelSpec.assertTrue((String)"", (boolean)model.contains(null, JMS.ontLanguage, TestModelFactory.DAMLLangResource));
        StmtIterator stmtIterator = model.listStatements(null, JMS.docManager, (RDFNode)null);
        Resource resource = stmtIterator.nextStatement().getResource();
        TestModelSpec.assertSame((Object)ontModelSpec.getDocumentManager(), (Object)ModelSpecImpl.getValue(resource));
    }

    public void testOntModelSpecMaker() {
        OntModelSpec ontModelSpec = OntModelSpec.DAML_MEM_RULE_INF;
        Model model = ontModelSpec.getDescription();
        Statement statement = model.getRequiredProperty(null, JMS.importMaker);
        Model model2 = ontModelSpec.getImportModelMaker().getDescription();
        TestModelSpec.assertNotNull((Object)statement);
        this.assertIsoModels(model2, this.subModel(model, statement.getObject()));
    }

    public void testOntModelReasoner() {
        OntModelSpec ontModelSpec = OntModelSpec.DAML_MEM_RULE_INF;
        Model model = ontModelSpec.getDescription();
        Resource resource = model.createResource(ontModelSpec.getReasonerFactory().getURI());
        Statement statement = model.getRequiredProperty(null, JMS.reasonsWith);
        Model model2 = ModelFactory.createDefaultModel().add(model.createResource(), JMS.reasoner, resource);
        this.assertIsoModels(model2, this.subModel(model, statement.getObject()));
    }

    public Model subModel(Model model, RDFNode rDFNode) {
        Model model2 = ModelFactory.createDefaultModel();
        if (rDFNode instanceof Resource) {
            model2.add(model.listStatements((Resource)rDFNode, null, (RDFNode)null));
        }
        return model2;
    }

    public void testCreateOntSpec() {
        OntModelSpec ontModelSpec = OntModelSpec.OWL_MEM_RULE_INF;
        Model model = ModelFactory.createDefaultModel();
        Resource resource = model.createResource(ontModelSpec.getLanguage());
        Resource resource2 = TestModelSpec.resource();
        Resource resource3 = model.createResource(ontModelSpec.getReasonerFactory().getURI());
        model.add(resource2, JMS.ontLanguage, resource);
        Resource resource4 = model.createResource();
        model.add(resource4, JMS.reasoner, resource3);
        model.add(resource2, JMS.reasonsWith, resource4);
        Resource resource5 = model.createResource();
        Model model2 = ModelFactory.createDefaultModel();
        model2.add(resource5, RDF.type, JMS.MemMakerSpec);
        model2.add(resource5, JMS.reificationMode, JMS.rsStandard);
        model.add(resource2, JMS.importMaker, resource5);
        model.add(model2);
        OntDocumentManager ontDocumentManager = ontModelSpec.getDocumentManager();
        Resource resource6 = ModelSpecImpl.createValue(ontDocumentManager);
        model.add(resource2, JMS.docManager, resource6);
        OntModelSpec ontModelSpec2 = new OntModelSpec(model);
        TestModelSpec.assertEquals((String)resource.getURI(), (String)ontModelSpec2.getLanguage());
        TestModelSpec.assertEquals((String)resource3.getURI(), (String)ontModelSpec2.getReasonerFactory().getURI());
        this.assertIsoModels(model2, ontModelSpec2.getImportModelMaker().getDescription());
        TestModelSpec.assertSame((Object)ontDocumentManager, (Object)ontModelSpec2.getDocumentManager());
    }

    public void testCreateOntSpecWithoutMaker() {
        OntModelSpec ontModelSpec = OntModelSpec.OWL_MEM_RULE_INF;
        Model model = ModelFactory.createDefaultModel();
        Resource resource = model.createResource(ontModelSpec.getLanguage());
        Resource resource2 = TestModelSpec.resource();
        Resource resource3 = model.createResource(ontModelSpec.getReasonerFactory().getURI());
        model.add(resource2, JMS.ontLanguage, resource);
        Resource resource4 = model.createResource();
        model.add(resource4, JMS.reasoner, resource3);
        model.add(resource2, JMS.reasonsWith, resource4);
        OntDocumentManager ontDocumentManager = ontModelSpec.getDocumentManager();
        Resource resource5 = ModelSpecImpl.createValue(ontDocumentManager);
        model.add(resource2, JMS.docManager, resource5);
        OntModelSpec ontModelSpec2 = new OntModelSpec(model);
        TestModelSpec.assertEquals((String)resource.getURI(), (String)ontModelSpec2.getLanguage());
        TestModelSpec.assertEquals((String)resource3.getURI(), (String)ontModelSpec2.getReasonerFactory().getURI());
        TestModelSpec.assertSame((Object)ontDocumentManager, (Object)ontModelSpec2.getDocumentManager());
    }

    public void testCreateOntSpecWithoutDocmanager() {
        OntModelSpec ontModelSpec = OntModelSpec.OWL_MEM_RULE_INF;
        Model model = ModelFactory.createDefaultModel();
        Resource resource = model.createResource(ontModelSpec.getLanguage());
        Resource resource2 = TestModelSpec.resource();
        Resource resource3 = model.createResource(ontModelSpec.getReasonerFactory().getURI());
        model.add(resource2, JMS.ontLanguage, resource);
        Resource resource4 = model.createResource();
        model.add(resource4, JMS.reasoner, resource3);
        model.add(resource2, JMS.reasonsWith, resource4);
        Resource resource5 = model.createResource();
        Model model2 = ModelFactory.createDefaultModel();
        model2.add(resource5, RDF.type, JMS.MemMakerSpec);
        model2.add(resource5, JMS.reificationMode, JMS.rsStandard);
        model.add(resource2, JMS.importMaker, resource5);
        model.add(model2);
        OntModelSpec ontModelSpec2 = new OntModelSpec(model);
        TestModelSpec.assertEquals((String)resource.getURI(), (String)ontModelSpec2.getLanguage());
        TestModelSpec.assertEquals((String)resource3.getURI(), (String)ontModelSpec2.getReasonerFactory().getURI());
        this.assertIsoModels(model2, ontModelSpec2.getImportModelMaker().getDescription());
    }

    public void testCreateOntSpecWithoutReasoner() {
        OntModelSpec ontModelSpec = OntModelSpec.OWL_MEM_RULE_INF;
        Model model = ModelFactory.createDefaultModel();
        Resource resource = model.createResource(ontModelSpec.getLanguage());
        Resource resource2 = TestModelSpec.resource();
        model.add(resource2, JMS.ontLanguage, resource);
        Resource resource3 = model.createResource();
        Model model2 = ModelFactory.createDefaultModel();
        model2.add(resource3, RDF.type, JMS.MemMakerSpec);
        model2.add(resource3, JMS.reificationMode, JMS.rsStandard);
        model.add(resource2, JMS.importMaker, resource3);
        model.add(model2);
        OntDocumentManager ontDocumentManager = ontModelSpec.getDocumentManager();
        Resource resource4 = ModelSpecImpl.createValue(ontDocumentManager);
        model.add(resource2, JMS.docManager, resource4);
        OntModelSpec ontModelSpec2 = new OntModelSpec(model);
        TestModelSpec.assertEquals((String)resource.getURI(), (String)ontModelSpec2.getLanguage());
        this.assertIsoModels(model2, ontModelSpec2.getImportModelMaker().getDescription());
        TestModelSpec.assertSame((Object)ontDocumentManager, (Object)ontModelSpec2.getDocumentManager());
    }

    public void testCreateFailingMaker() {
        try {
            ModelSpecImpl.createMaker(TestModelSpec.modelWithStatements(""));
            TestModelSpec.fail((String)"should generate BadDescriptionException");
        }
        catch (BadDescriptionException badDescriptionException) {
            TestModelSpec.pass();
        }
    }

    public void testCreateFromResource() throws FileNotFoundException, IOException {
        File file = FileUtils.tempFileName("pre", ".rdf");
        Model model = TestModelSpec.createPlainModelDesc();
        TestModelSpec.writeModel(file, model);
        ModelSpec modelSpec = ModelSpecImpl.create(TestModelSpec.resource("file:" + file));
        this.assertIsoModels(model, modelSpec.getDescription());
    }

    public void testCreateRootedFromResource() throws FileNotFoundException, IOException {
        File file = FileUtils.tempFileName("pre", ".rdf");
        Resource resource = TestModelSpec.resource("eh:gibberish");
        Model model = TestModelSpec.createPlainModelDesc(resource);
        TestModelSpec.writeModel(file, model);
        ModelSpec modelSpec = ModelSpecImpl.create(resource, TestModelSpec.resource("file:" + file));
        this.assertIsoModels(model, modelSpec.getDescription(resource));
    }

    protected static void writeModel(File file, Model model) throws FileNotFoundException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        model.write(fileOutputStream);
        fileOutputStream.close();
    }

    public void testCreateMemModelMaker() {
        Resource resource = JMS.MemMakerSpec;
        this.testCreateModelMaker(JMS.rsStandard, resource, SimpleGraphMaker.class);
        this.testCreateModelMaker(JMS.rsMinimal, resource, SimpleGraphMaker.class);
        this.testCreateModelMaker(JMS.rsConvenient, resource, SimpleGraphMaker.class);
    }

    public void testCreateFileModelMaker() {
        Resource resource = JMS.FileMakerSpec;
        this.testCreateModelMaker(JMS.rsStandard, resource, FileGraphMaker.class);
        this.testCreateModelMaker(JMS.rsMinimal, resource, FileGraphMaker.class);
        this.testCreateModelMaker(JMS.rsConvenient, resource, FileGraphMaker.class);
    }

    public void testCreateFileModelMakerRooted() {
        String string = "/somewhere";
        Resource resource = TestModelSpec.resource();
        Model model = ModelFactory.createDefaultModel().add(resource, RDF.type, JMS.FileMakerSpec).add(resource, JMS.fileBase, string);
        ModelMaker modelMaker = ModelSpecImpl.createMaker(model);
        FileGraphMaker fileGraphMaker = (FileGraphMaker)modelMaker.getGraphMaker();
        TestModelSpec.assertEquals((String)string, (String)fileGraphMaker.getFileBase());
        Model model2 = ModelFactory.createModelForGraph(fileGraphMaker.getDescription());
        TestModelSpec.assertTrue((boolean)model2.listStatements(null, JMS.fileBase, string).hasNext());
    }

    public void testCreateModelMaker(Resource resource, Resource resource2, Class clazz) {
        Resource resource3 = TestModelSpec.resource();
        ReificationStyle reificationStyle = JMS.findStyle(resource);
        Model model = TestModelSpec.modelWithStatements("").add(resource3, RDF.type, resource2).add(resource3, JMS.reificationMode, resource);
        ModelMaker modelMaker = ModelSpecImpl.createMaker(model);
        TestModelSpec.assertTrue((boolean)clazz.isInstance(modelMaker.getGraphMaker()));
        TestModelSpec.assertEquals((Object)reificationStyle, (Object)modelMaker.getGraphMaker().getReificationStyle());
    }

    public void testCreatePlainMemModel() {
        Resource resource = TestModelSpec.resource();
        Model model = TestModelSpec.createPlainModelDesc(resource);
        PlainModelSpec plainModelSpec = new PlainModelSpec(resource, model);
        ModelMaker modelMaker = plainModelSpec.getModelMaker();
        Model model2 = modelMaker.getDescription(resource);
        TestModelSpec.assertTrue((boolean)model2.contains(resource, RDF.type, JMS.MemMakerSpec));
        TestModelSpec.assertTrue((boolean)model2.listStatements(null, JMS.reificationMode, JMS.rsMinimal).hasNext());
        TestModelSpec.assertTrue((boolean)(modelMaker.getGraphMaker() instanceof SimpleGraphMaker));
        TestModelSpec.assertEquals((Object)ReificationStyle.Minimal, (Object)modelMaker.getGraphMaker().getReificationStyle());
    }

    public void testCreatePlainFileModel() {
        Resource resource = TestModelSpec.resource();
        Resource resource2 = TestModelSpec.resource();
        Model model = TestModelSpec.createPlainModelDesc(resource, resource2, JMS.FileMakerSpec);
        PlainModelSpec plainModelSpec = new PlainModelSpec(resource, model);
        ModelMaker modelMaker = plainModelSpec.getModelMaker();
        Model model2 = modelMaker.getDescription(resource);
        TestModelSpec.assertTrue((boolean)model2.listStatements(null, RDF.type, JMS.FileMakerSpec).hasNext());
        TestModelSpec.assertTrue((boolean)model2.listStatements(null, JMS.reificationMode, JMS.rsMinimal).hasNext());
        TestModelSpec.assertTrue((boolean)(modelMaker.getGraphMaker() instanceof FileGraphMaker));
        TestModelSpec.assertEquals((Object)ReificationStyle.Minimal, (Object)modelMaker.getGraphMaker().getReificationStyle());
    }

    public static Model createPlainModelDesc() {
        return TestModelSpec.createPlainModelDesc(TestModelSpec.resource());
    }

    public static Model createPlainModelDesc(Resource resource) {
        return TestModelSpec.createPlainModelDesc(resource, TestModelSpec.resource());
    }

    public static Model createPlainModelDesc(Resource resource, Resource resource2) {
        return TestModelSpec.createPlainModelDesc(resource, resource2, JMS.MemMakerSpec);
    }

    public static Model createPlainModelDesc(Resource resource, Resource resource2, Resource resource3) {
        return ModelFactory.createDefaultModel().add(resource, JMS.maker, resource2).add(resource2, RDF.type, resource3).add(resource2, JMS.reificationMode, JMS.rsMinimal);
    }

    public static Model createInfModelDesc(String string) {
        return TestModelSpec.createInfModelDesc(TestModelSpec.resource(), string);
    }

    public static Model createInfModelDesc(Resource resource, String string) {
        Resource resource2 = TestModelSpec.resource();
        Resource resource3 = TestModelSpec.resource();
        Resource resource4 = TestModelSpec.resource(string);
        return ModelFactory.createDefaultModel().add(resource, JMS.reasonsWith, resource3).add(resource3, JMS.reasoner, resource4).add(resource, JMS.maker, resource2).add(resource2, RDF.type, JMS.MemMakerSpec).add(resource2, JMS.reificationMode, JMS.rsMinimal);
    }
}

