/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphExtract;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.TripleBoundary;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelExtract;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StatementBoundary;
import com.hp.hpl.jena.rdf.model.StatementBoundaryBase;
import com.hp.hpl.jena.rdf.model.StatementTripleBoundary;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import junit.framework.TestSuite;

public class TestModelExtract
extends ModelTestBase {
    protected static final StatementBoundary sbTrue = new StatementBoundaryBase(){

        public boolean stopAt(Statement statement) {
            return true;
        }
    };
    protected static final StatementBoundary sbFalse = new StatementBoundaryBase(){

        public boolean stopAt(Statement statement) {
            return false;
        }
    };

    public TestModelExtract(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestModelExtract.class);
    }

    public void testAsTripleBoundary() {
        Model model = ModelFactory.createDefaultModel();
        TestModelExtract.assertTrue((boolean)sbTrue.asTripleBoundary(model).stopAt(TestModelExtract.triple("x R y")));
        TestModelExtract.assertFalse((boolean)sbFalse.asTripleBoundary(model).stopAt(TestModelExtract.triple("x R y")));
    }

    public void testStatementTripleBoundaryAnon() {
        TripleBoundary tripleBoundary = TripleBoundary.stopAtAnonObject;
        TestModelExtract.assertSame((Object)tripleBoundary, (Object)new StatementTripleBoundary(tripleBoundary).asTripleBoundary(null));
        TestModelExtract.assertFalse((boolean)new StatementTripleBoundary(tripleBoundary).stopAt(TestModelExtract.statement("s P o")));
        TestModelExtract.assertTrue((boolean)new StatementTripleBoundary(tripleBoundary).stopAt(TestModelExtract.statement("s P _o")));
    }

    public void testStatementContinueWith() {
        StatementBoundaryBase statementBoundaryBase = new StatementBoundaryBase(){

            public boolean continueWith(Statement statement) {
                return false;
            }
        };
        TestModelExtract.assertTrue((boolean)statementBoundaryBase.stopAt(TestModelExtract.statement("x pings y")));
    }

    public void testStatementTripleBoundaryNowhere() {
        TripleBoundary tripleBoundary = TripleBoundary.stopNowhere;
        TestModelExtract.assertSame((Object)tripleBoundary, (Object)new StatementTripleBoundary(tripleBoundary).asTripleBoundary(null));
        TestModelExtract.assertFalse((boolean)new StatementTripleBoundary(tripleBoundary).stopAt(TestModelExtract.statement("s P _o")));
        TestModelExtract.assertFalse((boolean)new StatementTripleBoundary(tripleBoundary).stopAt(TestModelExtract.statement("s P o")));
    }

    public void testRemembersBoundary() {
        TestModelExtract.assertSame((Object)sbTrue, (Object)new MockModelExtract(sbTrue).getStatementBoundary());
        TestModelExtract.assertSame((Object)sbFalse, (Object)new MockModelExtract(sbFalse).getStatementBoundary());
    }

    public void testInvokesExtract() {
        MockModelExtract mockModelExtract = new MockModelExtract(sbTrue);
        Model model = TestModelExtract.modelWithStatements("a R b");
        Model model2 = mockModelExtract.extract(TestModelExtract.resource("a"), model);
        TestModelExtract.assertEquals((Object)TestModelExtract.node("a"), (Object)mockModelExtract.root);
        TestModelExtract.assertSame((Object)mockModelExtract.result, (Object)model2.getGraph());
        TestModelExtract.assertSame((Object)mockModelExtract.subject, (Object)model.getGraph());
    }

    public boolean stopAt(Statement statement) {
        return false;
    }

    public TripleBoundary asTripleBoundary(Model model) {
        return null;
    }

    static class MockModelExtract
    extends ModelExtract {
        Node root;
        Graph result;
        Graph subject;

        public MockModelExtract(StatementBoundary statementBoundary) {
            super(statementBoundary);
        }

        public StatementBoundary getStatementBoundary() {
            return this.boundary;
        }

        protected GraphExtract getGraphExtract(TripleBoundary tripleBoundary) {
            return new GraphExtract(tripleBoundary){

                public Graph extractInto(Graph graph, Node node, Graph graph2) {
                    MockModelExtract.this.root = node;
                    MockModelExtract.this.subject = graph2;
                    MockModelExtract.this.result = super.extractInto(graph, node, MockModelExtract.this.subject);
                    return MockModelExtract.this.result;
                }
            };
        }
    }
}

