/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import EDU.oswego.cs.dl.util.concurrent.WriterPreferenceReadWriteLock;
import com.hp.hpl.jena.rdf.model.ModelLock;
import com.hp.hpl.jena.shared.JenaException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ModelLockImpl
implements ModelLock {
    static Log log = LogFactory.getLog((Class)ModelLockImpl.class);
    Map threadStates = new HashMap();
    int threadStatesSize = this.threadStates.size();
    WriterPreferenceReadWriteLock lock = new WriterPreferenceReadWriteLock();
    SynchronizedInt activeReadLocks = new SynchronizedInt(0);
    SynchronizedInt activeWriteLocks = new SynchronizedInt(0);

    ModelLockImpl() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("ModelLockImpl() : " + Thread.currentThread().getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enterCriticalSection(boolean bl) {
        ModelLockState modelLockState = this.getLockState();
        if (log.isDebugEnabled()) {
            log.debug((Object)(Thread.currentThread().getName() + " >> enterCS: " + this.report(modelLockState)));
        }
        if (modelLockState.readLocks > 0 && modelLockState.writeLocks == 0 && !bl) {
            ++modelLockState.readLocks;
            this.activeReadLocks.increment();
            if (log.isDebugEnabled()) {
                log.debug((Object)(Thread.currentThread().getName() + " << enterCS: promotion attempt: " + this.report(modelLockState)));
            }
            throw new JenaException("enterCriticalSection: Write lock request while holding read lock - potential deadlock");
        }
        if (modelLockState.writeLocks > 0 && bl) {
            bl = false;
        }
        try {
            if (bl) {
                if (modelLockState.readLocks == 0) {
                    this.lock.readLock().acquire();
                }
                ++modelLockState.readLocks;
                this.activeReadLocks.increment();
            } else {
                if (modelLockState.writeLocks == 0) {
                    this.lock.writeLock().acquire();
                }
                ++modelLockState.writeLocks;
                this.activeWriteLocks.increment();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)(Thread.currentThread().getName() + " << enterCS: " + this.report(modelLockState)));
            }
        }
    }

    public final void leaveCriticalSection() {
        ModelLockState modelLockState = this.getLockState();
        if (log.isDebugEnabled()) {
            log.debug((Object)(Thread.currentThread().getName() + " >> leaveCS: " + this.report(modelLockState)));
        }
        try {
            if (modelLockState.readLocks > 0) {
                --modelLockState.readLocks;
                this.activeReadLocks.decrement();
                if (modelLockState.readLocks == 0) {
                    this.lock.readLock().release();
                }
                modelLockState.clean();
                return;
            }
            if (modelLockState.writeLocks > 0) {
                --modelLockState.writeLocks;
                this.activeWriteLocks.decrement();
                if (modelLockState.writeLocks == 0) {
                    this.lock.writeLock().release();
                }
                modelLockState.clean();
                return;
            }
            throw new JenaException("leaveCriticalSection: No lock held (" + Thread.currentThread().getName() + ")");
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)(Thread.currentThread().getName() + " << leaveCS: " + this.report(modelLockState)));
            }
        }
    }

    private String report(ModelLockState modelLockState) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Thread R/W: ");
        stringBuffer.append(Integer.toString(modelLockState.readLocks));
        stringBuffer.append("/");
        stringBuffer.append(Integer.toString(modelLockState.writeLocks));
        stringBuffer.append(" :: Model R/W: ");
        stringBuffer.append(Integer.toString(this.activeReadLocks.get()));
        stringBuffer.append("/");
        stringBuffer.append(Integer.toString(this.activeWriteLocks.get()));
        stringBuffer.append(" (thread: ");
        stringBuffer.append(modelLockState.thread.getName());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    synchronized ModelLockState getLockState() {
        Thread thread = Thread.currentThread();
        ModelLockState modelLockState = (ModelLockState)this.threadStates.get(thread);
        if (modelLockState == null) {
            modelLockState = new ModelLockState(this);
            this.threadStates.put(thread, modelLockState);
            this.threadStatesSize = this.threadStates.size();
        }
        return modelLockState;
    }

    synchronized void removeLockState(Thread thread) {
        this.threadStates.remove(thread);
    }

    static class ModelLockState {
        int readLocks = 0;
        int writeLocks = 0;
        ModelLockImpl modelLock;
        Thread thread;

        ModelLockState(ModelLockImpl modelLockImpl) {
            this.modelLock = modelLockImpl;
            this.thread = Thread.currentThread();
        }

        void clean() {
            if (this.modelLock.activeReadLocks.get() == 0 && this.modelLock.activeWriteLocks.get() == 0) {
                this.modelLock.removeLockState(this.thread);
            }
        }
    }
}

