/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleBoundary;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelExtract;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StatementBoundary;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.InfModelImpl;
import com.hp.hpl.jena.rdf.model.impl.ModelSpecImpl;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.reasoner.rulesys.impl.WrappedReasonerFactory;
import com.hp.hpl.jena.shared.NoReasonerSuppliedException;
import com.hp.hpl.jena.shared.NoSuchReasonerException;
import com.hp.hpl.jena.vocabulary.JMS;
import junit.framework.Assert;

public class InfModelSpec
extends ModelSpecImpl {
    protected Resource reasonerResource;
    protected Resource reasonerRoot;
    protected ReasonerFactory factory;
    private static final TripleBoundary notJMSTriple = new TripleBoundary(){

        public boolean stopAt(Triple triple) {
            return !triple.getPredicate().getNameSpace().equals("http://jena.hpl.hp.com/2003/08/jms#");
        }
    };
    private static final StatementBoundary notJMS = new StatementBoundary(){

        public boolean stopAt(Statement statement) {
            return notJMSTriple.stopAt(statement.asTriple());
        }

        public TripleBoundary asTripleBoundary(Model model) {
            return notJMSTriple;
        }
    };

    public InfModelSpec(Resource resource, Model model) {
        super(resource, model);
        Statement statement = model.getRequiredProperty(null, JMS.reasoner);
        Statement statement2 = model.listStatements(resource, JMS.reasonsWith, (RDFNode)null).nextStatement();
        this.reasonerRoot = statement.getSubject();
        Resource resource2 = statement2.getResource();
        Assert.assertEquals((Object)this.reasonerRoot, (Object)resource2);
        this.reasonerResource = statement.getResource();
        this.factory = InfModelSpec.getReasonerFactory(statement.getSubject(), model);
    }

    public Model createModel() {
        return this.createModel(this.maker.getGraphMaker().createGraph());
    }

    public Model createModelOver(String string) {
        return this.createModel(this.maker.getGraphMaker().createGraph(string));
    }

    protected Model createModel(Graph graph) {
        Reasoner reasoner = this.factory.create(null);
        return new InfModelImpl(reasoner.bind(graph));
    }

    public Property getMakerProperty() {
        return JMS.maker;
    }

    public Model addDescription(Model model, Resource resource) {
        super.addDescription(model, resource);
        Resource resource2 = this.reasonerRoot;
        model.add(resource, JMS.reasonsWith, resource2);
        model.add(resource2, JMS.reasoner, this.reasonerResource);
        new ModelExtract(notJMS).extractInto(model, resource2, this.description);
        return model;
    }

    public static ReasonerFactory getReasonerFactory(Resource resource, Model model) {
        StmtIterator stmtIterator = model.listStatements(resource, JMS.reasoner, (RDFNode)null);
        if (!stmtIterator.hasNext()) {
            throw new NoReasonerSuppliedException();
        }
        Resource resource2 = stmtIterator.nextStatement().getResource();
        String string = resource2.getURI();
        ReasonerFactory reasonerFactory = ReasonerRegistry.theRegistry().getFactory(string);
        if (reasonerFactory == null) {
            throw new NoSuchReasonerException(string);
        }
        return new WrappedReasonerFactory(reasonerFactory, (Resource)resource.inModel(model));
    }
}

