/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model;

import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelSpec;
import com.hp.hpl.jena.rdf.model.ModelSpecCreator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.impl.InfModelSpec;
import com.hp.hpl.jena.rdf.model.impl.PlainModelSpec;
import com.hp.hpl.jena.vocabulary.JMS;
import java.util.HashMap;
import java.util.Map;

public class ModelSpecCreatorRegistry {
    private static Map creators = new HashMap();

    public static ModelSpecCreator findCreator(Resource resource) {
        return (ModelSpecCreator)creators.get(resource);
    }

    public static void register(Resource resource, ModelSpecCreator modelSpecCreator) {
        creators.put(resource, modelSpecCreator);
    }

    static {
        ModelSpecCreatorRegistry.register(JMS.InfModelSpec, new InfSpecCreator());
        ModelSpecCreatorRegistry.register(JMS.OntModelSpec, new OntSpecCreator());
        ModelSpecCreatorRegistry.register(JMS.PlainModelSpec, new PlainSpecCreator());
        ModelSpecCreatorRegistry.register(JMS.DefaultModelSpec, new PlainSpecCreator());
    }

    static class OntSpecCreator
    implements ModelSpecCreator {
        OntSpecCreator() {
        }

        public ModelSpec create(Resource resource, Model model) {
            return new OntModelSpec(resource, model);
        }
    }

    static class PlainSpecCreator
    implements ModelSpecCreator {
        PlainSpecCreator() {
        }

        public ModelSpec create(Resource resource, Model model) {
            return new PlainModelSpec(resource, model);
        }
    }

    static class InfSpecCreator
    implements ModelSpecCreator {
        InfSpecCreator() {
        }

        public ModelSpec create(Resource resource, Model model) {
            return new InfModelSpec(resource, model);
        }
    }
}

