/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model;

import com.hp.hpl.jena.rdf.model.ModelMakerCreator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.impl.FileMakerCreator;
import com.hp.hpl.jena.rdf.model.impl.MemMakerCreator;
import com.hp.hpl.jena.rdf.model.impl.RDBMakerCreator;
import com.hp.hpl.jena.vocabulary.JMS;
import java.util.HashMap;
import java.util.Map;

public class ModelMakerCreatorRegistry {
    private static Map creators = new HashMap();
    private static final ModelMakerCreator defaultMakerCreator = new MemMakerCreator();

    private ModelMakerCreatorRegistry() {
    }

    public static ModelMakerCreator findCreator(Resource resource) {
        return (ModelMakerCreator)creators.get(resource);
    }

    public static void register(Resource resource, ModelMakerCreator modelMakerCreator) {
        creators.put(resource, modelMakerCreator);
    }

    static {
        ModelMakerCreatorRegistry.register(JMS.MakerSpec, defaultMakerCreator);
        ModelMakerCreatorRegistry.register(JMS.FileMakerSpec, new FileMakerCreator());
        ModelMakerCreatorRegistry.register(JMS.MemMakerSpec, new MemMakerCreator());
        ModelMakerCreatorRegistry.register(JMS.RDBMakerSpec, new RDBMakerCreator());
    }
}

