/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp.test;

import com.hp.hpl.jena.rdf.arp.ALiteral;
import com.hp.hpl.jena.rdf.arp.ARPEventHandler;
import com.hp.hpl.jena.rdf.arp.ARPSaxErrorHandler;
import com.hp.hpl.jena.rdf.arp.AResource;
import com.hp.hpl.jena.rdf.arp.NTriple;
import com.hp.hpl.jena.rdf.arp.test.InFactoryX;
import com.hp.hpl.jena.rdf.arp.test.TestScope;
import com.hp.hpl.jena.rdf.arp.test.WGTestSuite;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.shared.wg.TestInputStreamFactory;
import com.hp.hpl.jena.shared.wg.URI;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import junit.framework.TestSuite;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class NTripleTestSuite
extends WGTestSuite {
    NTripleTestSuite(TestInputStreamFactory testInputStreamFactory, String string, boolean bl) {
        super(testInputStreamFactory, string, bl);
    }

    static TestSuite suite(URI uRI, String string, String string2) {
        return new NTripleTestSuite(new TestInputStreamFactory(uRI, string), string2, true);
    }

    static TestSuite suite(URI uRI, URI uRI2, String string) {
        return new NTripleTestSuite(new TestInputStreamFactory(uRI, uRI2), string, true);
    }

    Model loadRDF(InFactoryX inFactoryX, RDFErrorHandler rDFErrorHandler, String string) throws IOException {
        return NTripleTestSuite.loadRDFx(inFactoryX, rDFErrorHandler, string, true, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Model loadRDFx(InFactoryX inFactoryX, RDFErrorHandler rDFErrorHandler, String string, boolean bl, int n) throws IOException {
        TestHandler testHandler;
        PrintStream printStream;
        InputStream inputStream = System.in;
        InputStream inputStream2 = null;
        File file = null;
        if (bl) {
            file = File.createTempFile("arp", ".nt");
            printStream = new PrintStream(new FileOutputStream(file));
            testHandler = new TestHandler(rDFErrorHandler);
        } else {
            printStream = new PrintStream(new OutputStream(){

                public void write(int n) throws IOException {
                }
            });
            testHandler = new TestHandler(rDFErrorHandler, n);
        }
        PrintStream printStream2 = System.out;
        try {
            block13: {
                System.setIn(inFactoryX.open());
                System.setOut(printStream);
                try {
                    NTriple.mainEh(new String[]{"-b", string, "-s"}, testHandler, testHandler);
                }
                catch (SimulatedException simulatedException) {
                    if (!bl) break block13;
                    throw simulatedException;
                }
            }
            printStream.close();
            testHandler.atEndOfFile();
            if (n == 0) {
                for (int i = testHandler.getCount(); i >= 1; --i) {
                    NTripleTestSuite.loadRDFx(inFactoryX, TestScope.suppress, string, false, i);
                }
            }
            if (bl) {
                inputStream2 = new FileInputStream(file);
                Model model = NTripleTestSuite.loadNT(inputStream2, string);
                return model;
            }
            Model model = null;
            return model;
        }
        finally {
            System.in.close();
            System.setIn(inputStream);
            System.setOut(printStream2);
            if (inputStream2 != null) {
                inputStream2.close();
            }
            if (file != null) {
                file.delete();
            }
        }
    }

    static class TestHandler
    extends ARPSaxErrorHandler
    implements ARPEventHandler,
    ErrorHandler {
        final int xCountDown;
        Set anon = new HashSet();
        Set oldAnon = new HashSet();
        int state = 1;
        int countDown;
        boolean hasErrors = false;

        TestHandler(RDFErrorHandler rDFErrorHandler) {
            this(rDFErrorHandler, 0);
        }

        TestHandler(RDFErrorHandler rDFErrorHandler, int n) {
            super(rDFErrorHandler);
            this.countDown = n;
            this.xCountDown = n;
        }

        public void statement(AResource aResource, AResource aResource2, AResource aResource3) {
            WGTestSuite.Test.assertEquals((int)this.state, (int)2);
            this.seeing(aResource);
            this.seeing(aResource3);
            if (--this.countDown == 0) {
                throw new SimulatedException();
            }
        }

        private void seeing(AResource aResource) {
            if (aResource.isAnonymous()) {
                this.anon.add(aResource);
            }
            WGTestSuite.Test.assertFalse((String)"bnode reuse?", (boolean)this.oldAnon.contains(aResource));
        }

        private void seen(AResource aResource) {
            if (!this.anon.contains(aResource)) {
                WGTestSuite.Test.assertTrue((String)("end-scope for a bnode that had not been used " + aResource.getAnonymousID()), (boolean)this.anon.contains(aResource));
            }
            this.anon.remove(aResource);
            this.oldAnon.add(aResource);
        }

        public void statement(AResource aResource, AResource aResource2, ALiteral aLiteral) {
            WGTestSuite.Test.assertEquals((String)"no start RDF seen", (int)this.state, (int)2);
            this.seeing(aResource);
            if (--this.countDown == 0) {
                throw new SimulatedException();
            }
        }

        public void endBNodeScope(AResource aResource) {
            WGTestSuite.Test.assertTrue((boolean)aResource.isAnonymous());
            switch (this.state) {
                case 1: {
                    WGTestSuite.Test.fail((String)"Missing startRDF");
                }
                case 2: {
                    WGTestSuite.Test.assertFalse((boolean)aResource.hasNodeID());
                    this.seen(aResource);
                    break;
                }
                case 3: 
                case 4: {
                    WGTestSuite.Test.assertTrue((boolean)aResource.hasNodeID());
                    this.seen(aResource);
                    this.state = 4;
                    break;
                }
                default: {
                    WGTestSuite.Test.fail((String)"impossible - test logic error");
                }
            }
        }

        public void startRDF() {
            switch (this.state) {
                case 2: 
                case 4: {
                    WGTestSuite.Test.fail((String)("Bad state for startRDF " + this.state));
                }
            }
            this.state = 2;
        }

        public void endRDF() {
            WGTestSuite.Test.assertEquals((int)this.state, (int)2);
            this.state = 3;
        }

        public void startPrefixMapping(String string, String string2) {
        }

        public void endPrefixMapping(String string) {
        }

        public void atEndOfFile() {
            if (!this.anon.isEmpty()) {
                Iterator iterator = this.anon.iterator();
                while (iterator.hasNext()) {
                    System.err.print(((AResource)iterator.next()).getAnonymousID() + ", ");
                }
            }
            WGTestSuite.Test.assertTrue((String)("(" + this.xCountDown + ") some bnode still in scope "), (boolean)this.anon.isEmpty());
            switch (this.state) {
                case 1: {
                    WGTestSuite.Test.fail((String)"end-of-file before anything");
                }
                case 2: {
                    WGTestSuite.Test.fail((String)"did not see endRDF");
                }
                case 3: 
                case 4: {
                    break;
                }
                default: {
                    WGTestSuite.Test.fail((String)"impossible logic error in test");
                }
            }
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            this.hasErrors = true;
            super.error(sAXParseException);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.hasErrors = true;
            super.fatalError(sAXParseException);
        }

        public int getCount() {
            return -this.countDown;
        }

        public boolean discardNodesWithNodeID() {
            return false;
        }
    }

    static class SimulatedException
    extends RuntimeException {
        SimulatedException() {
        }
    }
}

