/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp;

import com.hp.hpl.jena.rdf.arp.Location;
import com.hp.hpl.jena.rdf.arp.RDFParserConstants;

class Token
implements RDFParserConstants,
Cloneable {
    private static boolean COUNT = false;
    private static int dead = 0;
    private static int alive = 0;
    private boolean isDead = false;
    final Location location;
    public int kind;
    public Token next;

    protected void finalize() {
        if (COUNT && !this.isDead) {
            this.isDead = true;
            ++dead;
        }
    }

    Token(int n, Location location) {
        if (COUNT) {
            this.initCounting();
        }
        this.kind = n;
        this.location = location;
    }

    Token() {
        if (COUNT) {
            this.initCounting();
        }
        this.location = null;
    }

    private void initCounting() {
        if (++alive % 500 == 0) {
            Runtime.getRuntime().gc();
            Runtime.getRuntime().gc();
            System.err.println(dead + "/" + alive);
        }
    }

    public Object clone() {
        try {
            ++alive;
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return "Impossible";
        }
    }

    public String toString() {
        return tokenImage[this.kind];
    }
}

