/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp;

import com.hp.hpl.jena.rdf.arp.FatalParsingErrorException;
import com.hp.hpl.jena.rdf.arp.Location;
import com.hp.hpl.jena.rdf.arp.ParseException;
import com.hp.hpl.jena.rdf.arp.PullingTokenPipe;
import com.hp.hpl.jena.rdf.arp.RDFParser;
import com.hp.hpl.jena.rdf.arp.SAX2RDF;
import com.hp.hpl.jena.rdf.arp.WrappedException;
import com.hp.hpl.jena.rdf.arp.XMLHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UTFDataFormatException;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.parsers.StandardParserConfiguration;
import org.apache.xerces.util.EncodingMap;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.apache.xerces.xni.parser.XMLPullParserConfiguration;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

class SingleThreadedParser
extends XMLHandler {
    private XMLPullParserConfiguration pullParser;
    private SAXParser saxParser;
    private String readerXMLEncoding = null;
    private String xmlEncoding = null;

    private SingleThreadedParser(SAXParser sAXParser, XMLPullParserConfiguration xMLPullParserConfiguration) {
        this.pullParser = xMLPullParserConfiguration;
        this.saxParser = sAXParser;
        try {
            SAX2RDF.installHandlers((XMLReader)sAXParser, this);
        }
        catch (SAXException sAXException) {
            throw new RuntimeException("Supposedly impossible:", sAXException);
        }
    }

    SAXParser getSAXParser() {
        return this.saxParser;
    }

    static SingleThreadedParser create() {
        SingleThreadedParser singleThreadedParser;
        StandardParserConfiguration standardParserConfiguration = new StandardParserConfiguration();
        MySAXParser mySAXParser = new MySAXParser(standardParserConfiguration);
        mySAXParser.a = singleThreadedParser = new SingleThreadedParser(mySAXParser, (XMLPullParserConfiguration)standardParserConfiguration);
        return singleThreadedParser;
    }

    boolean parseSome() {
        try {
            return this.pullParser.parse(false);
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            try {
                this.generalError(212, uTFDataFormatException);
            }
            catch (SAXParseException sAXParseException) {
                // empty catch block
            }
            return false;
        }
        catch (IOException iOException) {
            try {
                this.generalError(213, iOException);
            }
            catch (SAXParseException sAXParseException) {
                // empty catch block
            }
            return false;
        }
        catch (FatalParsingErrorException fatalParsingErrorException) {
            return false;
        }
    }

    public synchronized void parse(InputSource inputSource) throws IOException, SAXException {
        this.parse(inputSource, inputSource.getSystemId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void parse(InputSource inputSource, String string) throws IOException, SAXException {
        block7: {
            this.initParse(string);
            this.pipe = new PullingTokenPipe(this);
            this.pullParser.setInputSource(this.convert(inputSource));
            SAX2RDF.installHandlers((XMLReader)this.saxParser, this);
            this.saxParser.reset();
            try {
                try {
                    RDFParser rDFParser = new RDFParser(this.pipe, this);
                    if (this.getOptions().getEmbedding()) {
                        rDFParser.embeddedFile(this.documentContext);
                        break block7;
                    }
                    rDFParser.rdfFile(this.documentContext);
                }
                catch (WrappedException wrappedException) {
                    wrappedException.throwMe();
                }
                catch (ParseException parseException) {
                    this.userError(parseException);
                }
            }
            finally {
                this.endBnodeScope();
            }
        }
    }

    XMLInputSource convert(InputSource inputSource) {
        Reader reader = inputSource.getCharacterStream();
        InputStream inputStream = inputSource.getByteStream();
        String string = inputSource.getPublicId();
        String string2 = inputSource.getSystemId();
        this.readerXMLEncoding = null;
        this.encodingProblems = false;
        if (reader == null && inputStream == null) {
            return new XMLInputSource(string, string2, string2);
        }
        if (reader == null) {
            return new XMLInputSource(string, string2, string2, inputStream, null);
        }
        if (inputStream == null) {
            if (reader instanceof InputStreamReader) {
                String string3 = ((InputStreamReader)reader).getEncoding();
                this.readerXMLEncoding = EncodingMap.getJava2IANAMapping((String)string3);
                if (this.readerXMLEncoding == null) {
                    this.readerXMLEncoding = string3;
                }
            }
            return new XMLInputSource(string, string2, string2, reader, null);
        }
        return null;
    }

    void setEncoding(String string) {
        if ((string = string.toUpperCase()) != null && this.xmlEncoding == null) {
            if (string.equals("UTF") && this.readerXMLEncoding != null && this.readerXMLEncoding.startsWith("UTF")) {
                this.xmlEncoding = this.readerXMLEncoding;
                return;
            }
            this.xmlEncoding = string;
            if (this.readerXMLEncoding != null && !this.readerXMLEncoding.equals(string)) {
                try {
                    this.putWarning(129, new Location(this.locator), "Encoding on InputStreamReader or FileReader does not match that of XML document. Use FileInputStream. [" + this.readerXMLEncoding + " != " + string + "]");
                }
                catch (SAXParseException sAXParseException) {
                    // empty catch block
                }
                this.encodingProblems = true;
            }
        }
    }

    private static class MySAXParser
    extends SAXParser {
        SingleThreadedParser a;

        MySAXParser(StandardParserConfiguration standardParserConfiguration) {
            super((XMLParserConfiguration)standardParserConfiguration);
            try {
                this.setFeature("http://xml.org/sax/features/string-interning", false);
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }

        public void xmlDecl(String string, String string2, String string3, Augmentations augmentations) {
            this.a.setEncoding(string2 == null ? "UTF" : string2);
            super.xmlDecl(string, string2, string3, augmentations);
        }
    }
}

