/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp;

import com.hp.hpl.jena.rdf.arp.ALiteral;
import com.hp.hpl.jena.rdf.arp.ARPString;
import com.hp.hpl.jena.rdf.arp.AResource;
import com.hp.hpl.jena.rdf.arp.AResourceInternal;
import com.hp.hpl.jena.rdf.arp.MalformedURIException;
import com.hp.hpl.jena.rdf.arp.URIReference;
import com.hp.hpl.jena.rdf.arp.XMLHandler;

class ARPResource
implements AResourceInternal {
    private static final String RDFNS = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    private static final int RDFNS_LENGTH = "http://www.w3.org/1999/02/22-rdf-syntax-ns#".length();
    private static final String XMLNS = "http://www.w3.org/XML/1998/namespace";
    private static AResourceInternal RDF_STATEMENT;
    static URIReference RDF_BAG;
    static URIReference RDF_SEQ;
    static URIReference RDF_ALT;
    private static String RDF_LI;
    private static AResourceInternal RDF_TYPE;
    private static AResourceInternal RDF_SUBJECT;
    private static AResourceInternal RDF_PREDICATE;
    private static AResourceInternal RDF_OBJECT;
    private XMLHandler arp;
    String nodeID = null;
    private String uri;
    private static int genIdCounter;
    private final int genId = genIdCounter++;
    private int liCounter = 1;
    static String dummy;
    static String nullDummy;
    private static URIReference[] _rdf_n;
    private Object userData;
    private boolean used = false;

    ARPResource(XMLHandler xMLHandler) {
        this.arp = xMLHandler;
    }

    void setAbout(URIReference uRIReference) {
        this.setAbout(uRIReference.getURI());
    }

    void setAbout(String string) {
        this.uri = string.startsWith(dummy) ? string.substring(dummy.length()) : string;
    }

    void setLiObject(Object object, String string) {
        this.setPredObject(ARPResource.rdf_n(this.liCounter++), object, this.reify(string));
    }

    void setPredicateObject(AResourceInternal aResourceInternal, ARPString aRPString) {
        this.setPredObject(aResourceInternal, aRPString, null);
    }

    void setPredicateObject(AResourceInternal aResourceInternal, Object object, String string) {
        this.setPredObject(aResourceInternal, object, this.reify(string));
    }

    AResourceInternal reify(String string) {
        ARPResource aRPResource = null;
        if (string != null) {
            aRPResource = new ARPResource(this.arp);
            aRPResource.setAbout(string);
        }
        return aRPResource;
    }

    void setType(URIReference uRIReference) {
        this.setPredObject(RDF_TYPE, uRIReference, null);
    }

    private void setPredObject(AResourceInternal aResourceInternal, Object object, AResourceInternal aResourceInternal2) {
        this.triple(this, aResourceInternal, object);
        if (aResourceInternal2 != null) {
            this.tripleRes(aResourceInternal2, RDF_TYPE, RDF_STATEMENT);
            this.tripleRes(aResourceInternal2, RDF_SUBJECT, this);
            this.tripleRes(aResourceInternal2, RDF_PREDICATE, aResourceInternal);
            this.triple(aResourceInternal2, RDF_OBJECT, object);
        }
    }

    private void triple(AResourceInternal aResourceInternal, AResourceInternal aResourceInternal2, Object object) {
        int n = 0;
        if (object instanceof AResourceInternal) {
            ++n;
        }
        if (object instanceof ALiteral) {
            n += 2;
        }
        switch (n) {
            case 1: {
                this.tripleRes(aResourceInternal, aResourceInternal2, (AResourceInternal)object);
                break;
            }
            case 2: {
                this.tripleLit(aResourceInternal, aResourceInternal2, (ALiteral)object);
                break;
            }
            default: {
                throw new RuntimeException("Assertion failure: sw = " + n);
            }
        }
    }

    private void tripleRes(AResourceInternal aResourceInternal, AResourceInternal aResourceInternal2, AResourceInternal aResourceInternal3) {
        aResourceInternal.setHasBeenUsed();
        aResourceInternal3.setHasBeenUsed();
        this.arp.getStatementHandler().statement((AResource)aResourceInternal, (AResource)aResourceInternal2, aResourceInternal3);
    }

    private void tripleLit(AResourceInternal aResourceInternal, AResourceInternal aResourceInternal2, ALiteral aLiteral) {
        aResourceInternal.setHasBeenUsed();
        this.arp.getStatementHandler().statement((AResource)aResourceInternal, (AResource)aResourceInternal2, aLiteral);
    }

    private static URIReference rdf_n(int n) {
        if (n >= _rdf_n.length) {
            int n2 = (n + 10) * 3 / 2;
            URIReference[] uRIReferenceArray = new URIReference[n2];
            System.arraycopy(_rdf_n, 0, uRIReferenceArray, 0, _rdf_n.length);
            for (int i = _rdf_n.length; i < n2; ++i) {
                try {
                    uRIReferenceArray[i] = new URIReference("http://www.w3.org/1999/02/22-rdf-syntax-ns#_" + i);
                    continue;
                }
                catch (MalformedURIException malformedURIException) {
                    throw new RuntimeException("Impossible: RDF_nnn handling logic error.");
                }
            }
            _rdf_n = uRIReferenceArray;
        }
        return _rdf_n[n];
    }

    static int isRDF_N(AResourceInternal aResourceInternal) {
        String string;
        if (!aResourceInternal.isAnonymous() && (string = aResourceInternal.getURI()).length() > RDFNS_LENGTH && string.charAt(RDFNS_LENGTH) == '_') {
            try {
                String string2 = string.substring(RDFNS_LENGTH + 1);
                int n = Integer.parseInt(string2);
                if (n > 0 && string.startsWith(RDFNS)) {
                    return n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public boolean isAnonymous() {
        return this.uri == null;
    }

    public String getAnonymousID() {
        return this.nodeID == null ? "A" + Integer.toString(this.genId) : "U" + this.nodeID;
    }

    void setNodeId(String string) {
        this.nodeID = string;
    }

    public String getURI() {
        return this.uri;
    }

    public String toString() {
        return this.uri == null ? "_:" + this.getAnonymousID() : "<" + this.uri + ">";
    }

    public int hashCode() {
        if (this.uri == null && this.nodeID == null) {
            return this.genId;
        }
        if (this.uri != null) {
            return this.uri.hashCode();
        }
        return this.nodeID.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof AResourceInternal)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        AResourceInternal aResourceInternal = (AResourceInternal)object;
        if (this.uri != null) {
            return !aResourceInternal.isAnonymous() && this.uri.equals(aResourceInternal.getURI());
        }
        ARPResource aRPResource = (ARPResource)aResourceInternal;
        return this.nodeID != null && this.nodeID.equals(aRPResource.nodeID);
    }

    public Object getUserData() {
        if (this.uri != null) {
            throw new IllegalStateException("User data only supported on blank nodes");
        }
        if (this.nodeID != null) {
            return this.arp.getUserData(this.nodeID);
        }
        return this.userData;
    }

    public void setUserData(Object object) {
        if (this.uri != null) {
            throw new IllegalStateException("User data only supported on blank nodes");
        }
        if (this.nodeID == null) {
            this.userData = object;
        } else {
            this.arp.setUserData(this.nodeID, object);
        }
    }

    public boolean hasNodeID() {
        return this.nodeID != null;
    }

    public void setHasBeenUsed() {
        this.used = true;
    }

    public boolean getHasBeenUsed() {
        return this.used;
    }

    static {
        try {
            RDF_STATEMENT = new URIReference("http://www.w3.org/1999/02/22-rdf-syntax-ns#Statement".intern());
            RDF_BAG = new URIReference("http://www.w3.org/1999/02/22-rdf-syntax-ns#Bag".intern());
            RDF_SEQ = new URIReference("http://www.w3.org/1999/02/22-rdf-syntax-ns#Seq".intern());
            RDF_ALT = new URIReference("http://www.w3.org/1999/02/22-rdf-syntax-ns#Alt".intern());
            RDF_LI = "http://www.w3.org/1999/02/22-rdf-syntax-ns#li".intern();
            RDF_TYPE = new URIReference("http://www.w3.org/1999/02/22-rdf-syntax-ns#type".intern());
            RDF_SUBJECT = new URIReference("http://www.w3.org/1999/02/22-rdf-syntax-ns#subject".intern());
            RDF_PREDICATE = new URIReference("http://www.w3.org/1999/02/22-rdf-syntax-ns#predicate".intern());
            RDF_OBJECT = new URIReference("http://www.w3.org/1999/02/22-rdf-syntax-ns#object".intern());
        }
        catch (MalformedURIException malformedURIException) {
            System.err.println("Internal error: " + malformedURIException.toString());
            malformedURIException.printStackTrace();
        }
        genIdCounter = 0;
        dummy = "http://jena.hpl.hp.com/arp/not/a/real/uri/";
        nullDummy = "nullpointerexception://jena.hpl.hp.com/arp/";
        _rdf_n = new URIReference[0];
    }
}

