/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.tidy.test;

import com.hp.hpl.jena.ontology.tidy.Checker;
import com.hp.hpl.jena.ontology.tidy.SyntaxProblem;
import com.hp.hpl.jena.ontology.tidy.test.CmdLineTidyTest;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.OWLTest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import jena.owlsyntax;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class Extra
extends TestCase {
    public static Test suite() {
        TestSuite testSuite = new TestSuite(Extra.class);
        testSuite.setName("More OWL syntax");
        testSuite.addTest(CmdLineTidyTest.suite());
        return testSuite;
    }

    public void testdisjointWith001() {
        this.runTest("disjointWith001", OWLTest.Full);
    }

    public void testdisjointWith002() {
        this.runTest("disjointWith002", OWLTest.DL);
    }

    public void testsameAs001() {
        this.runTest("sameAs001", OWLTest.Full);
    }

    public void testann001() {
        this.runTest("ann001", OWLTest.Lite);
    }

    public void testann002() {
        this.runTest("ann002", OWLTest.Lite);
    }

    public void testann003() {
        this.runTest("ann003", OWLTest.Lite);
    }

    public void testann004() {
        this.runTest("ann004", OWLTest.Lite);
    }

    public void testann005() {
        this.runTest("ann005", OWLTest.Full);
    }

    public void testcycle001() {
        this.runTest("cycle001", OWLTest.Full);
    }

    public void testcycle002() {
        this.runTest("cycle002", OWLTest.DL);
    }

    public void testcycle003() {
        this.runTest("cycle003", OWLTest.Full);
    }

    public void testcycle004() {
        this.runTest("cycle004", OWLTest.Full);
    }

    public void testcycle005() {
        this.runTest("cycle005", OWLTest.Full);
    }

    public void testsubClassOf001() {
        this.runTest("subClassOf001", OWLTest.Full);
    }

    public void testsubClassOf002() {
        this.runTest("subClassOf002", OWLTest.Full);
    }

    public void testsubClassOf003() {
        this.runTest("subClassOf003", OWLTest.Full);
    }

    public void testsubClassOf004() {
        this.runTest("subClassOf004", OWLTest.DL);
    }

    public void testsubClassOf005() {
        this.runTest("subClassOf005", OWLTest.Lite);
    }

    public void testlist001() {
        this.runTest("list001", OWLTest.DL);
    }

    public void testimports001() {
        this.runTest("imports001", OWLTest.Full);
    }

    public void testimports002() {
        this.runTest("imports002", OWLTest.Full);
    }

    public void testontologyProp001() {
        this.runTest("ontologyProp001", OWLTest.Lite);
    }

    private void runTest(String string, Resource resource) {
        this.runTestFullName("testing/ontology/tidy/" + string, resource);
    }

    private void runWGTest(String string, Resource resource) {
        this.runTestFullName("testing/wg/" + string, resource);
    }

    private void runTestFullName(String string, Resource resource) {
        Checker checker = new Checker(((Object)resource).equals(OWLTest.Lite));
        Model model = ModelFactory.createDefaultModel();
        model.read("file:" + string + ".rdf");
        checker.addRaw(model.getGraph());
        String string2 = checker.getSubLanguage();
        boolean bl = resource.getURI().endsWith(string2);
        if (!bl) {
            Iterator iterator = checker.getProblems();
            while (iterator.hasNext()) {
                SyntaxProblem syntaxProblem = (SyntaxProblem)iterator.next();
                System.err.println(syntaxProblem.longDescription());
            }
        }
        Extra.assertTrue((boolean)bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEMess() {
        PrintStream printStream = System.out;
        PrintStream printStream2 = System.err;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            System.setOut(new PrintStream(new OutputStream(){

                public void write(int n) throws IOException {
                }
            }));
            System.setErr(new PrintStream(byteArrayOutputStream));
            owlsyntax.main(new String[]{"file:testing/ontology/tidy/emess.rdf"});
        }
        finally {
            System.setOut(printStream);
            System.setErr(printStream2);
        }
        String string = byteArrayOutputStream.toString();
        Extra.assertTrue((String)"not enough triples in error message", (string.indexOf("ObjectProperty") != -1 ? 1 : 0) != 0);
        Extra.assertTrue((String)"not enough triples in error message", (string.indexOf("range") != -1 ? 1 : 0) != 0);
    }
}

