/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.tidy.impl;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.compose.Union;
import com.hp.hpl.jena.ontology.tidy.impl.AbsChecker;
import com.hp.hpl.jena.ontology.tidy.impl.CNodeI;
import com.hp.hpl.jena.ontology.tidy.impl.CategorySet;
import com.hp.hpl.jena.ontology.tidy.impl.CheckerImpl;
import com.hp.hpl.jena.ontology.tidy.impl.MinimalityInfo;
import com.hp.hpl.jena.shared.BrokenException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class MinimalSubGraph
extends AbsChecker {
    static final int MAXDIST = 10000;
    private final Set todo = new HashSet();
    private final Map allMinInfos = new HashMap();
    private final Set activeMinInfos = new HashSet();
    private final Graph parentUnion;
    private int distance;

    void add(MinimalityInfo minimalityInfo) {
        this.allMinInfos.put(minimalityInfo.cn.asNode(), minimalityInfo);
    }

    MinimalSubGraph(boolean bl, Triple triple, CheckerImpl checkerImpl) {
        super(bl);
        this.justForErrorMessages = this.hasBeenChecked;
        this.parentUnion = new Union(checkerImpl.hasBeenChecked, checkerImpl.justForErrorMessages);
        if (!this.add(triple, false)) {
            this.hasBeenChecked.add(triple);
        } else {
            boolean bl2 = this.hasBeenChecked.contains(triple);
            this.hasBeenChecked.delete(triple);
            this.setDistance(triple.getSubject(), 0);
            this.setDistance(triple.getPredicate(), 0);
            this.setDistance(triple.getObject(), 0);
            this.todo(triple);
            (bl2 ? this.hasBeenChecked : this.justForErrorMessages).add(triple);
            this.extend();
        }
    }

    Graph getContradiction() {
        return this.hasBeenChecked;
    }

    private void todo(Triple triple) {
        if (!this.hasBeenChecked.contains(triple)) {
            this.todo.add(triple);
        }
    }

    private void todo(Node node, Node node2, Node node3) {
        ExtendedIterator extendedIterator = this.parentUnion.find(node, node2, node3);
        while (extendedIterator.hasNext()) {
            Triple triple = (Triple)extendedIterator.next();
            this.todo(triple);
        }
    }

    private void todo(Node node) {
        this.todo(node, Node.ANY, Node.ANY);
        this.todo(Node.ANY, node, Node.ANY);
        this.todo(Node.ANY, Node.ANY, node);
    }

    private void extend() {
        while (true) {
            Triple triple = null;
            boolean bl = true;
            Triple triple2 = null;
            int n = -1;
            this.setMinInfos();
            Iterator iterator = this.todo.iterator();
            while (iterator.hasNext()) {
                triple2 = (Triple)iterator.next();
                switch (this.addX(triple2, true)) {
                    case 0: {
                        this.hasBeenChecked.add(triple2);
                        return;
                    }
                    case 1: {
                        int n2;
                        if (!bl || (n2 = this.score()) <= n) break;
                        n = n2;
                        triple = triple2;
                        break;
                    }
                    case 2: {
                        int n2;
                        if (bl) {
                            bl = false;
                            n = -1;
                        }
                        if ((n2 = this.score()) <= n) break;
                        n = n2;
                        triple = triple2;
                        break;
                    }
                    default: {
                        throw new BrokenException("Can't happen");
                    }
                }
                this.hasBeenChecked.delete(triple2);
                this.reset(this.allMinInfos);
            }
            if (triple == null) {
                this.dump();
                throw new BrokenException("no bestTriple");
            }
            if (this.addX(triple, true) == 0) {
                System.err.println("Non-fatal logic error");
                this.dump();
                this.hasBeenChecked.add(triple2);
                return;
            }
            this.todo.remove(triple);
            this.distance = 10000;
            this.todoAndDistance(triple.getSubject());
            this.todoAndDistance(triple.getPredicate());
            this.todoAndDistance(triple.getObject());
            this.setDistance(triple.getSubject(), this.distance);
            this.setDistance(triple.getPredicate(), this.distance);
            this.setDistance(triple.getObject(), this.distance);
        }
    }

    private void setMinInfos() {
        Iterator iterator = this.allMinInfos.values().iterator();
        while (iterator.hasNext()) {
            MinimalityInfo minimalityInfo = (MinimalityInfo)iterator.next();
            minimalityInfo.oldCategory = minimalityInfo.cn.getCategories();
            minimalityInfo.cn.getSeen(minimalityInfo.oldSeen);
        }
    }

    private void todoAndDistance(Node node) {
        this.activeMinInfos.add(this.allMinInfos.get(node));
        this.todo(node);
        int n = this.getDistance(node);
        if (n >= 0 && n < this.distance) {
            this.distance = n;
        }
    }

    private void reset(Map map) {
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            MinimalityInfo minimalityInfo = (MinimalityInfo)iterator.next();
            minimalityInfo.cn.setCategories(minimalityInfo.oldCategory, false);
            minimalityInfo.cn.setSeen(minimalityInfo.oldSeen);
        }
    }

    int getDistance(Node node) {
        MinimalityInfo minimalityInfo = (MinimalityInfo)this.allMinInfos.get(node);
        return minimalityInfo.distance;
    }

    void setDistance(Node node, int n) {
        ((MinimalityInfo)this.allMinInfos.get((Object)node)).distance = n;
    }

    int score() {
        int n = 0;
        Iterator iterator = this.activeMinInfos.iterator();
        while (iterator.hasNext()) {
            int n2;
            MinimalityInfo minimalityInfo = (MinimalityInfo)iterator.next();
            int n4 = (10000 - minimalityInfo.distance) * 10000;
            if (n4 + 10000 < n) continue;
            int n5 = CategorySet.getSet(minimalityInfo.cn.getCategories()).length;
            if (n5 > (n2 = CategorySet.getSet(minimalityInfo.oldCategory).length)) {
                throw new BrokenException("cat length problem");
            }
            if ((n4 += n2 - n5) <= n) continue;
            n = n4;
        }
        return n;
    }

    void actions(int n, CNodeI cNodeI, CNodeI cNodeI2, Triple triple) {
    }

    boolean extraInfo() {
        return true;
    }
}

