/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.tidy.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.ProfileRegistry;
import com.hp.hpl.jena.ontology.tidy.Levels;
import com.hp.hpl.jena.ontology.tidy.impl.AbsChecker;
import com.hp.hpl.jena.ontology.tidy.impl.CNodeI;
import com.hp.hpl.jena.ontology.tidy.impl.CategorySet;
import com.hp.hpl.jena.ontology.tidy.impl.Grammar;
import com.hp.hpl.jena.ontology.tidy.impl.MinimalSubGraph;
import com.hp.hpl.jena.ontology.tidy.impl.OneTwoImpl;
import com.hp.hpl.jena.ontology.tidy.impl.Q;
import com.hp.hpl.jena.ontology.tidy.impl.SyntaxProblemImpl;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.shared.BrokenException;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.iterator.ConcatenatedIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class CheckerImpl
extends AbsChecker {
    private Vector monotoneProblems = new Vector();
    private Vector warnings = new Vector();
    private Vector nonMonotoneProblems = null;
    private int nonMonotoneLevel;
    static OntDocumentManager importsCloseManager = new OntDocumentManager();
    static OntModelSpec dullOWL;
    Map disjoints = new HashMap();

    public Iterator getErrors() {
        this.nonMonotoneLevel = 1;
        if (this.monotoneProblems.size() > 0) {
            return this.monotoneProblems.iterator();
        }
        this.snapCheck();
        return this.nonMonotoneProblems.iterator();
    }

    public Iterator getProblems() {
        return new ConcatenatedIterator(this.getErrors(), this.warnings.iterator());
    }

    protected void endBNode(Node node) {
        if (!this.useRemove) {
            return;
        }
        CNodeI cNodeI = this.getCNode(node);
        int n = cNodeI.getCategories();
        int n2 = CategorySet.flags[n];
        if (n2 != 0) {
            if ((n2 & 0x10) != 0 && this.getCNode(node).asOne().incompleteOne()) {
                this.bnProblem("Incomplete blank owl:Class or owl:AllDifferent", node);
            }
            if ((n2 & 0x20) != 0 && this.getCNode(node).asTwo().incompleteTwo()) {
                this.bnProblem("Incomplete rdf:List or owl:Restriction", node);
            }
            if ((n2 & 0xFFFFFFCF) != 0) {
                if ((n2 & 2) != 0) {
                    this.bnProblem("Untyped node", node);
                }
                if ((n2 & 4) != 0) {
                    this.bnProblem("Orphaned rdf:List node", node);
                }
                if ((n2 & 8) != 0) {
                    this.bnProblem("Orphaned blank owl:Class or owl:Restriction is in OWL DL", node, 1);
                }
            }
            cNodeI.asBlank().strip(Q.member(21, CategorySet.getSet(n)));
        }
    }

    private synchronized void snapCheck() {
        if (this.nonMonotoneProblems == null) {
            this.nonMonotoneProblems = new Vector();
            this.nonMonotoneLevel = 1;
            CheckerImpl checkerImpl = this;
            this.cyclicTouched = new HashSet();
            Iterator iterator = this.nodeInfo.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Node node = (Node)entry.getKey();
                CNodeI cNodeI = (CNodeI)entry.getValue();
                int n = cNodeI.getCategories();
                int n2 = CategorySet.flags[n];
                boolean bl = false;
                if (n2 == 0) continue;
                if (node.isBlank()) {
                    bl = cNodeI.asBlank().stripped();
                }
                if (!bl) {
                    if ((n2 & 0x10) != 0 && this.getCNode(node).asOne().incompleteOne()) {
                        this.nonMonProblem("Incomplete blank owl:Class or owl:AllDifferent", node);
                    }
                    if ((n2 & 0x20) != 0 && this.getCNode(node).asTwo().incompleteTwo()) {
                        this.nonMonProblem("Incomplete rdf:List or owl:Restriction", node);
                    }
                    if ((n2 & 0xFFFFFFCF) == 0) continue;
                    if ((n2 & 2) != 0) {
                        this.nonMonProblem("Untyped node", node);
                    }
                    if ((n2 & 4) != 0) {
                        this.nonMonProblem("Orphaned rdf:List node", node);
                    }
                    if ((n2 & 8) != 0) {
                        this.nonMonProblem("Orphaned blank owl:Class or owl:Restriction is in OWL DL", node, 1);
                    }
                }
                if ((n2 & 1) == 0) continue;
                if (Q.intersect(Grammar.descriptionsX, CategorySet.getSet(n)) || Q.intersect(Grammar.restrictionsX, CategorySet.getSet(n))) {
                    this.nonMonProblem("Cyclic blank owl:Class or owl:Restriction", node);
                }
                if (Q.intersect(Grammar.listsX, CategorySet.getSet(n))) {
                    this.nonMonProblem("Cyclic rdf:List", node);
                }
                if (!Q.member(21, CategorySet.getSet(n))) continue;
                this.isCyclic((OneTwoImpl)cNodeI, node);
            }
            this.clearCyclicState();
            this.checkDisjoint();
        }
    }

    private void checkDisjoint() {
        Iterator iterator = this.disjoints.keySet().iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (!node.isBlank()) continue;
            Iterator iterator2 = ((Set)this.disjoints.get(node)).iterator();
            while (iterator2.hasNext()) {
                Node node2 = (Node)iterator2.next();
                Iterator iterator3 = ((Set)this.disjoints.get(node)).iterator();
                while (iterator3.hasNext()) {
                    Node node3 = (Node)iterator3.next();
                    if (node2.equals(node3) || ((Set)this.disjoints.get(node2)).contains(node3)) continue;
                    this.nonMonProblem("Ill-formed owl:disjointWith", node);
                }
            }
        }
    }

    private boolean isCyclic(OneTwoImpl oneTwoImpl, Node node) {
        int n = oneTwoImpl.getCyclicState();
        switch (n) {
            case 1: {
                oneTwoImpl.setCyclicState(2);
                this.nonMonProblem("Cyclic unnamed individual", node);
            }
            case 2: {
                return true;
            }
            case 0: {
                oneTwoImpl.setCyclicState(1);
                Triple triple = oneTwoImpl.get(2);
                boolean bl = triple == null ? false : this.isCyclic((OneTwoImpl)this.getCNode(triple.getSubject()), node);
                oneTwoImpl.setCyclicState(bl ? 2 : 3);
                return bl;
            }
            case 3: {
                return false;
            }
        }
        throw new BrokenException("Impossible case in switch.");
    }

    private void clearCyclicState() {
        Iterator iterator = this.cyclicTouched.iterator();
        while (iterator.hasNext()) {
            ((OneTwoImpl)iterator.next()).setCyclicState(0);
        }
    }

    private void nonMonProblem(String string, Node node) {
        this.nonMonProblem(string, node, 2);
    }

    private void nonMonProblem(String string, Node node, int n) {
        Model model = ModelFactory.createDefaultModel();
        Graph graph = model.getGraph();
        if (this.nonMonotoneLevel <= n) {
            this.nonMonotoneLevel = n + 1;
        }
        if (n == 1 && !this.wantLite) {
            return;
        }
        EnhNode enhNode = ((EnhGraph)((Object)model)).getNodeAs(node, RDFNode.class);
        ExtendedIterator extendedIterator = this.hasBeenChecked.find(node, null, null);
        while (extendedIterator.hasNext()) {
            graph.add((Triple)extendedIterator.next());
        }
        this.nonMonotoneProblems.add(new SyntaxProblemImpl(string, enhNode, n));
    }

    private void bnProblem(String string, Node node) {
        this.bnProblem(string, node, 2);
    }

    private void bnProblem(String string, Node node, int n) {
        Model model = ModelFactory.createDefaultModel();
        Graph graph = model.getGraph();
        this.setMonotoneLevel(n + 1);
        if (n == 1 && !this.wantLite) {
            return;
        }
        EnhNode enhNode = ((EnhGraph)((Object)model)).getNodeAs(node, RDFNode.class);
        ExtendedIterator extendedIterator = this.hasBeenChecked.find(node, null, null);
        while (extendedIterator.hasNext()) {
            graph.add((Triple)extendedIterator.next());
        }
        this.addProblem(new SyntaxProblemImpl(string, enhNode, n));
    }

    public CheckerImpl() {
        this(false);
    }

    public CheckerImpl(boolean bl) {
        super(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRaw(Graph graph) {
        ExtendedIterator extendedIterator = null;
        try {
            extendedIterator = graph.find(null, null, null);
            while (extendedIterator.hasNext()) {
                this.add((Triple)extendedIterator.next(), true);
            }
        }
        finally {
            if (extendedIterator != null) {
                extendedIterator.close();
            }
        }
    }

    public void load(String string) {
        this.load(string, "RDF/XML");
    }

    public void load(String string, String string2) {
        OntModel ontModel = ModelFactory.createOntologyModel(new OntModelSpec(null, null, null, ProfileRegistry.OWL_LANG), null);
        ontModel.getDocumentManager().setProcessImports(true);
        ontModel.read(string, string2);
        this.addRaw(ontModel.getGraph());
    }

    void addProblem(int n, Triple triple, String string) {
        String string2;
        Graph graph;
        super.addProblem(n, triple, string);
        if (n == 1 && !this.wantLite) {
            return;
        }
        if (this.justForErrorMessages == null) {
            graph = Factory.createDefaultGraph(ReificationStyle.Minimal);
            graph.add(triple);
            string2 = "\n Rerun without memory optimizations to get more correct error message.";
        } else {
            graph = new MinimalSubGraph(n == 1, triple, this).getContradiction();
            string2 = "";
        }
        this.addProblem(new SyntaxProblemImpl(string + " Not a " + Levels.toString(n) + " subgraph" + string2, graph, n));
    }

    void addProblem(SyntaxProblemImpl syntaxProblemImpl) {
        super.addProblem(syntaxProblemImpl);
        switch (syntaxProblemImpl.getLevel()) {
            case 0: {
                this.warnings.add(syntaxProblemImpl);
            }
            case 1: {
                if (this.wantLite) break;
                return;
            }
        }
        this.monotoneProblems.add(syntaxProblemImpl);
    }

    public String getSubLanguage() {
        int n;
        if (this.monotoneLevel < 3 && this.monotoneProblems.size() == 0) {
            this.snapCheck();
        }
        int n2 = n = this.monotoneLevel < this.nonMonotoneLevel ? this.nonMonotoneLevel : this.monotoneLevel;
        if (this.wantLite && n == 2) {
            return "DL or Full";
        }
        return Levels.toString(n);
    }

    void actions(int n, CNodeI cNodeI, CNodeI cNodeI2, Triple triple) {
        if (this.look.tripleForObject(n)) {
            cNodeI2.asBlank().addObjectTriple(triple);
        }
        if (this.look.tripleForSubject(n)) {
            cNodeI.asBlank().addObjectTriple(triple);
        }
        switch (this.look.action(n)) {
            case 8: {
                cNodeI.asOne().first(triple);
                break;
            }
            case 16: {
                cNodeI.asTwo().first(triple);
                break;
            }
            case 24: {
                cNodeI.asTwo().second(triple);
            }
        }
    }

    void addDisjoint(Node node, Node node2) {
        HashSet<Node> hashSet = (HashSet<Node>)this.disjoints.get(node);
        if (hashSet == null) {
            hashSet = new HashSet<Node>();
            this.disjoints.put(node, hashSet);
        }
        hashSet.add(node2);
    }

    boolean extraInfo() {
        return false;
    }

    protected Graph importsClosure(Graph graph) {
        OntModel ontModel = ModelFactory.createOntologyModel(dullOWL, ModelFactory.createModelForGraph(graph));
        return ontModel.getGraph();
    }

    static {
        importsCloseManager.setProcessImports(true);
        dullOWL = new OntModelSpec(null, importsCloseManager, null, ProfileRegistry.OWL_LANG);
    }
}

