/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.ontology.AllDifferent;
import com.hp.hpl.jena.ontology.AnnotationProperty;
import com.hp.hpl.jena.ontology.FunctionalProperty;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.InverseFunctionalProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.ontology.OntologyException;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.ontology.SymmetricProperty;
import com.hp.hpl.jena.ontology.TransitiveProperty;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.OWL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.logging.LogFactory;

public class TestListSyntaxCategories
extends TestCase {
    public static final String NS = "http://jena.hpl.hp.com/testing/ontology#";
    protected static DoListTest[] testCases = new DoListTest[]{new DoListTest("OWL list ontologies", "file:testing/ontology/owl/list-syntax/test.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 1, new String[]{"http://jena.hpl.hp.com/testing/ontology"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listOntologies();
        }

        public boolean test(Resource resource) {
            return resource instanceof Ontology;
        }
    }, new DoListTest("DAML list ontologies", "file:testing/ontology/daml/list-syntax/test.rdf", OntModelSpec.DAML_MEM_RULE_INF, 1, new String[]{"http://jena.hpl.hp.com/testing/ontology"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listOntologies();
        }

        public boolean test(Resource resource) {
            return resource instanceof Ontology;
        }
    }, new DoListTest("OWL list properties", "file:testing/ontology/owl/list-syntax/test.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#p"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listOntProperties();
        }

        public boolean test(Resource resource) {
            return resource instanceof OntProperty && resource instanceof Property;
        }
    }, new DoListTest("OWL list object properties", "file:testing/ontology/owl/list-syntax/test.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 2, new String[]{"http://jena.hpl.hp.com/testing/ontology#op", "http://jena.hpl.hp.com/testing/ontology#op1"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listObjectProperties();
        }

        public boolean test(Resource resource) {
            return resource instanceof OntProperty && resource instanceof Property;
        }
    }, new DoListTest("OWL list datatype properties", "file:testing/ontology/owl/list-syntax/test.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#dp"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listDatatypeProperties();
        }

        public boolean test(Resource resource) {
            return resource instanceof OntProperty && resource instanceof Property;
        }
    }, new DoListTest("OWL list functional properties", "file:testing/ontology/owl/list-syntax/test-proptypes.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#fp"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listFunctionalProperties();
        }

        public boolean test(Resource resource) {
            return resource instanceof OntProperty && resource instanceof FunctionalProperty && resource instanceof Property;
        }
    }, new DoListTest("OWL list transitive properties", "file:testing/ontology/owl/list-syntax/test-proptypes.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#tp"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listTransitiveProperties();
        }

        public boolean test(Resource resource) {
            return resource instanceof OntProperty && resource instanceof TransitiveProperty && resource instanceof Property;
        }
    }, new DoListTest("OWL list symmetric properties", "file:testing/ontology/owl/list-syntax/test-proptypes.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#sp"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listSymmetricProperties();
        }

        public boolean test(Resource resource) {
            return resource instanceof OntProperty && resource instanceof SymmetricProperty && resource instanceof Property;
        }
    }, new DoListTest("OWL list inverse functional properties", "file:testing/ontology/owl/list-syntax/test-proptypes.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#ifp"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listInverseFunctionalProperties();
        }

        public boolean test(Resource resource) {
            return resource instanceof OntProperty && resource instanceof InverseFunctionalProperty && resource instanceof Property;
        }
    }, new DoListTest("DAML list properties", "file:testing/ontology/daml/list-syntax/test.rdf", OntModelSpec.DAML_MEM_RULE_INF, 2, new String[]{"http://jena.hpl.hp.com/testing/ontology#p", "http://jena.hpl.hp.com/testing/ontology#rdf-p"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listOntProperties();
        }

        public boolean test(Resource resource) {
            return resource instanceof OntProperty && resource instanceof Property;
        }
    }, new DoListTest("DAML list object properties", "file:testing/ontology/daml/list-syntax/test.rdf", OntModelSpec.DAML_MEM_RULE_INF, 2, new String[]{"http://jena.hpl.hp.com/testing/ontology#op", "http://jena.hpl.hp.com/testing/ontology#op1"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listObjectProperties();
        }

        public boolean test(Resource resource) {
            return resource instanceof OntProperty && resource instanceof Property;
        }
    }, new DoListTest("DAML list datatype properties", "file:testing/ontology/daml/list-syntax/test.rdf", OntModelSpec.DAML_MEM_RULE_INF, 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#dp"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listDatatypeProperties();
        }

        public boolean test(Resource resource) {
            return resource instanceof OntProperty && resource instanceof Property;
        }
    }, new DoListTest("DAML list functional properties", "file:testing/ontology/daml/list-syntax/test-proptypes.rdf", OntModelSpec.DAML_MEM_RULE_INF, 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#fp"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listFunctionalProperties();
        }

        public boolean test(Resource resource) {
            return resource instanceof OntProperty && resource instanceof FunctionalProperty && resource instanceof Property;
        }
    }, new DoListTest("DAML list transitive properties", "file:testing/ontology/daml/list-syntax/test-proptypes.rdf", OntModelSpec.DAML_MEM_RULE_INF, 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#tp"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listTransitiveProperties();
        }

        public boolean test(Resource resource) {
            return resource instanceof OntProperty && resource instanceof TransitiveProperty && resource instanceof Property;
        }
    }, new DoListTest("DAML list inverse functional properties", "file:testing/ontology/daml/list-syntax/test-proptypes.rdf", OntModelSpec.DAML_MEM_RULE_INF, 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#ifp"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listInverseFunctionalProperties();
        }

        public boolean test(Resource resource) {
            return resource instanceof OntProperty && resource instanceof InverseFunctionalProperty && resource instanceof Property;
        }
    }, new DoListTest("OWL list individuals", "file:testing/ontology/owl/list-syntax/test.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 8, new String[]{"http://jena.hpl.hp.com/testing/ontology#A0", "http://jena.hpl.hp.com/testing/ontology#A1", "http://jena.hpl.hp.com/testing/ontology#C0", "http://jena.hpl.hp.com/testing/ontology#a0", "http://jena.hpl.hp.com/testing/ontology#a1", "http://jena.hpl.hp.com/testing/ontology#a2", "http://jena.hpl.hp.com/testing/ontology#z0", "http://jena.hpl.hp.com/testing/ontology#z1"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listIndividuals();
        }

        public boolean test(Resource resource) {
            return resource instanceof Individual;
        }
    }, new DoListTest("empty OWL list individuals", null, OntModelSpec.OWL_MEM, 0, new String[0]){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listIndividuals();
        }

        public boolean test(Resource resource) {
            return resource instanceof Individual;
        }
    }, new DoListTest("empty OWL+rule list individuals", null, OntModelSpec.OWL_MEM_RULE_INF, 0, new String[0]){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listIndividuals();
        }

        public boolean test(Resource resource) {
            return resource instanceof Individual;
        }
    }, new DoListTest("DAML list individuals", "file:testing/ontology/daml/list-syntax/test.rdf", OntModelSpec.DAML_MEM_RULE_INF, 6, new String[]{"http://jena.hpl.hp.com/testing/ontology#A0", "http://jena.hpl.hp.com/testing/ontology#A1", "http://jena.hpl.hp.com/testing/ontology#C0", "http://jena.hpl.hp.com/testing/ontology#a1", "http://jena.hpl.hp.com/testing/ontology#a2", "http://jena.hpl.hp.com/testing/ontology#a0"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listIndividuals();
        }

        public boolean test(Resource resource) {
            return resource instanceof Individual;
        }
    }, new DoListTest("empty DAML+rule list individuals", null, OntModelSpec.DAML_MEM_RULE_INF, 0, new String[0]){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listIndividuals();
        }

        public boolean test(Resource resource) {
            return resource instanceof Individual;
        }
    }, new DoListTest("OWL list all different", "file:testing/ontology/owl/list-syntax/test.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 1, null){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listAllDifferent();
        }

        public boolean test(Resource resource) {
            return resource instanceof AllDifferent;
        }
    }, new DoListTest("DAML list all different", "file:testing/ontology/daml/list-syntax/test.rdf", OntModelSpec.DAML_MEM_RULE_INF, 0, null, true){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listAllDifferent();
        }

        public boolean test(Resource resource) {
            return resource instanceof AllDifferent;
        }
    }, new DoListTest("OWL list classes", "file:testing/ontology/owl/list-syntax/test.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 11, new String[]{"http://jena.hpl.hp.com/testing/ontology#A", "http://jena.hpl.hp.com/testing/ontology#B", "http://jena.hpl.hp.com/testing/ontology#C", "http://jena.hpl.hp.com/testing/ontology#D", "http://jena.hpl.hp.com/testing/ontology#E", "http://jena.hpl.hp.com/testing/ontology#X0", "http://jena.hpl.hp.com/testing/ontology#X1", "http://jena.hpl.hp.com/testing/ontology#Y0", "http://jena.hpl.hp.com/testing/ontology#Y1", "http://jena.hpl.hp.com/testing/ontology#Z"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listClasses();
        }

        public boolean test(Resource resource) {
            return resource instanceof OntClass;
        }
    }, new DoListTest("OWL list named classes", "file:testing/ontology/owl/list-syntax/test.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 10, new String[]{"http://jena.hpl.hp.com/testing/ontology#A", "http://jena.hpl.hp.com/testing/ontology#B", "http://jena.hpl.hp.com/testing/ontology#C", "http://jena.hpl.hp.com/testing/ontology#D", "http://jena.hpl.hp.com/testing/ontology#E", "http://jena.hpl.hp.com/testing/ontology#X0", "http://jena.hpl.hp.com/testing/ontology#X1", "http://jena.hpl.hp.com/testing/ontology#Y0", "http://jena.hpl.hp.com/testing/ontology#Y1", "http://jena.hpl.hp.com/testing/ontology#Z"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listNamedClasses();
        }

        public boolean test(Resource resource) {
            return resource instanceof OntClass;
        }
    }, new DoListTest("OWL list intersection classes", "file:testing/ontology/owl/list-syntax/test.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#A"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listIntersectionClasses();
        }

        public boolean test(Resource resource) {
            return resource instanceof OntClass;
        }
    }, new DoListTest("OWL list union classes", "file:testing/ontology/owl/list-syntax/test.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#B"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listUnionClasses();
        }

        public boolean test(Resource resource) {
            return resource instanceof OntClass;
        }
    }, new DoListTest("OWL list complement classes", "file:testing/ontology/owl/list-syntax/test.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#C"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listComplementClasses();
        }

        public boolean test(Resource resource) {
            return resource instanceof OntClass;
        }
    }, new DoListTest("OWL list enumerated classes", "file:testing/ontology/owl/list-syntax/test.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#D"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listEnumeratedClasses();
        }

        public boolean test(Resource resource) {
            return resource instanceof OntClass;
        }
    }, new DoListTest("OWL list restrictions", "file:testing/ontology/owl/list-syntax/test.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 1, null){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listRestrictions();
        }

        public boolean test(Resource resource) {
            return resource instanceof Restriction;
        }
    }, new DoListTest("DAML list classes", "file:testing/ontology/daml/list-syntax/test.rdf", OntModelSpec.DAML_MEM_RULE_INF, 12, new String[]{"http://jena.hpl.hp.com/testing/ontology#A", "http://jena.hpl.hp.com/testing/ontology#B", "http://jena.hpl.hp.com/testing/ontology#C", "http://jena.hpl.hp.com/testing/ontology#D", "http://jena.hpl.hp.com/testing/ontology#E", "http://jena.hpl.hp.com/testing/ontology#X0", "http://jena.hpl.hp.com/testing/ontology#X1", "http://jena.hpl.hp.com/testing/ontology#Y0", "http://jena.hpl.hp.com/testing/ontology#Y1", "http://jena.hpl.hp.com/testing/ontology#Z", DAML_OIL.Thing.getURI()}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listClasses();
        }

        public boolean test(Resource resource) {
            return resource instanceof OntClass;
        }
    }, new DoListTest("DAML list named classes", "file:testing/ontology/daml/list-syntax/test.rdf", OntModelSpec.DAML_MEM_RULE_INF, 11, new String[]{"http://jena.hpl.hp.com/testing/ontology#A", "http://jena.hpl.hp.com/testing/ontology#B", "http://jena.hpl.hp.com/testing/ontology#C", "http://jena.hpl.hp.com/testing/ontology#D", "http://jena.hpl.hp.com/testing/ontology#E", "http://jena.hpl.hp.com/testing/ontology#X0", "http://jena.hpl.hp.com/testing/ontology#X1", "http://jena.hpl.hp.com/testing/ontology#Y0", "http://jena.hpl.hp.com/testing/ontology#Y1", "http://jena.hpl.hp.com/testing/ontology#Z", DAML_OIL.Thing.getURI()}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listNamedClasses();
        }

        public boolean test(Resource resource) {
            return resource instanceof OntClass;
        }
    }, new DoListTest("DAML list intersection classes", "file:testing/ontology/daml/list-syntax/test.rdf", OntModelSpec.DAML_MEM_RULE_INF, 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#A"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listIntersectionClasses();
        }

        public boolean test(Resource resource) {
            return resource instanceof OntClass;
        }
    }, new DoListTest("DAML list union classes", "file:testing/ontology/daml/list-syntax/test.rdf", OntModelSpec.DAML_MEM_RULE_INF, 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#B"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listUnionClasses();
        }

        public boolean test(Resource resource) {
            return resource instanceof OntClass;
        }
    }, new DoListTest("DAML list complement classes", "file:testing/ontology/daml/list-syntax/test.rdf", OntModelSpec.DAML_MEM_RULE_INF, 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#C"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listComplementClasses();
        }

        public boolean test(Resource resource) {
            return resource instanceof OntClass;
        }
    }, new DoListTest("DAML list enumerated classes", "file:testing/ontology/daml/list-syntax/test.rdf", OntModelSpec.DAML_MEM_RULE_INF, 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#D"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listEnumeratedClasses();
        }

        public boolean test(Resource resource) {
            return resource instanceof OntClass;
        }
    }, new DoListTest("DAML list restrictions", "file:testing/ontology/daml/list-syntax/test.rdf", OntModelSpec.DAML_MEM_RULE_INF, 1, null){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listRestrictions();
        }

        public boolean test(Resource resource) {
            return resource instanceof Restriction;
        }
    }, new DoListTest("OWL list annotation properties", "file:testing/ontology/owl/list-syntax/test.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 6, null){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listAnnotationProperties();
        }

        public boolean test(Resource resource) {
            return resource instanceof AnnotationProperty;
        }
    }, new DoListTest("OWL+import list ontologies", "file:testing/ontology/owl/list-syntax/test-with-import.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 2, new String[]{"http://jena.hpl.hp.com/testing/ontology", "http://www.w3.org/2002/07/owl"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listOntologies();
        }

        public boolean test(Resource resource) {
            return resource instanceof Ontology;
        }
    }, new DoListTest("OWL+import list properties", "file:testing/ontology/owl/list-syntax/test-with-import.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 40, null){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listOntProperties();
        }

        public boolean test(Resource resource) {
            return resource instanceof OntProperty && resource instanceof Property;
        }
    }, new DoListTest("OWL+import list object properties", "file:testing/ontology/owl/list-syntax/test-with-import.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 2, new String[]{"http://jena.hpl.hp.com/testing/ontology#op", "http://jena.hpl.hp.com/testing/ontology#op1"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listObjectProperties();
        }

        public boolean test(Resource resource) {
            return resource instanceof OntProperty && resource instanceof Property;
        }
    }, new DoListTest("OWL+import list datatype properties", "file:testing/ontology/owl/list-syntax/test-with-import.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#dp"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listDatatypeProperties();
        }

        public boolean test(Resource resource) {
            return resource instanceof OntProperty && resource instanceof Property;
        }
    }, new DoListTest("OWL+import list individuals", "file:testing/ontology/owl/list-syntax/test-with-import.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 8, null){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listIndividuals();
        }

        public boolean test(Resource resource) {
            return resource instanceof Individual;
        }
    }, new DoListTest("OWL+import list all different", "file:testing/ontology/owl/list-syntax/test-with-import.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 1, null){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listAllDifferent();
        }

        public boolean test(Resource resource) {
            return resource instanceof AllDifferent;
        }
    }, new DoListTest("OWL+import list classes", "file:testing/ontology/owl/list-syntax/test-with-import.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 14, null){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listClasses();
        }

        public boolean test(Resource resource) {
            return resource instanceof OntClass;
        }
    }, new DoListTest("OWL+import list named classes", "file:testing/ontology/owl/list-syntax/test-with-import.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 12, new String[]{"http://jena.hpl.hp.com/testing/ontology#A", "http://jena.hpl.hp.com/testing/ontology#B", "http://jena.hpl.hp.com/testing/ontology#C", "http://jena.hpl.hp.com/testing/ontology#D", "http://jena.hpl.hp.com/testing/ontology#E", "http://jena.hpl.hp.com/testing/ontology#X0", "http://jena.hpl.hp.com/testing/ontology#X1", "http://jena.hpl.hp.com/testing/ontology#Y0", "http://jena.hpl.hp.com/testing/ontology#Y1", "http://jena.hpl.hp.com/testing/ontology#Z", OWL.Thing.getURI(), OWL.Nothing.getURI()}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listNamedClasses();
        }

        public boolean test(Resource resource) {
            return resource instanceof OntClass;
        }
    }, new DoListTest("OWL+import list intersection classes", "file:testing/ontology/owl/list-syntax/test-with-import.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#A"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listIntersectionClasses();
        }

        public boolean test(Resource resource) {
            return resource instanceof OntClass;
        }
    }, new DoListTest("OWL+import list union classes", "file:testing/ontology/owl/list-syntax/test-with-import.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 2, new String[]{"http://jena.hpl.hp.com/testing/ontology#B", OWL.Thing.getURI()}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listUnionClasses();
        }

        public boolean test(Resource resource) {
            return resource instanceof OntClass;
        }
    }, new DoListTest("OWL+import list complement classes", "file:testing/ontology/owl/list-syntax/test-with-import.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 3, null){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listComplementClasses();
        }

        public boolean test(Resource resource) {
            return resource instanceof OntClass;
        }
    }, new DoListTest("OWL+import list enumerated classes", "file:testing/ontology/owl/list-syntax/test-with-import.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 1, new String[]{"http://jena.hpl.hp.com/testing/ontology#D"}){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listEnumeratedClasses();
        }

        public boolean test(Resource resource) {
            return resource instanceof OntClass;
        }
    }, new DoListTest("OWL+import list restrictions", "file:testing/ontology/owl/list-syntax/test-with-import.rdf", OntModelSpec.OWL_MEM_TRANS_INF, 1, null){

        public Iterator doList(OntModel ontModel) {
            return ontModel.listRestrictions();
        }

        public boolean test(Resource resource) {
            return resource instanceof Restriction;
        }
    }};

    public TestListSyntaxCategories(String string) {
        super(string);
    }

    public static TestSuite suite() {
        TestSuite testSuite = new TestSuite("TestListSyntaxCategories");
        for (int i = 0; i < testCases.length; ++i) {
            testSuite.addTest((Test)testCases[i]);
        }
        return testSuite;
    }

    protected static class DoListTest
    extends TestCase {
        protected String m_fileName;
        protected OntModelSpec m_spec;
        protected int m_count;
        protected String[] m_expected;
        protected boolean m_exExpected;

        protected DoListTest(String string, String string2, OntModelSpec ontModelSpec, int n, String[] stringArray) {
            this(string, string2, ontModelSpec, n, stringArray, false);
        }

        protected DoListTest(String string, String string2, OntModelSpec ontModelSpec, int n, String[] stringArray, boolean bl) {
            super(string);
            this.m_fileName = string2;
            this.m_spec = ontModelSpec;
            this.m_count = n;
            this.m_expected = stringArray;
            this.m_exExpected = bl;
        }

        public void setUp() {
            OntDocumentManager.getInstance().reset(true);
        }

        public void runTest() {
            OntModel ontModel = ModelFactory.createOntologyModel(this.m_spec, null);
            ontModel.getDocumentManager().setMetadataSearchPath("file:etc/ont-policy-test.rdf", true);
            if (this.m_fileName != null) {
                ontModel.read(this.m_fileName);
            }
            boolean bl = false;
            Iterator iterator = null;
            try {
                iterator = this.doList(ontModel);
            }
            catch (OntologyException ontologyException) {
                bl = true;
            }
            DoListTest.assertEquals((String)("Ontology exception" + (this.m_exExpected ? " was " : " was not ") + "expected"), (boolean)this.m_exExpected, (boolean)bl);
            if (!bl) {
                Iterator iterator2;
                Resource resource;
                List list = this.expected(ontModel);
                ArrayList<Resource> arrayList = new ArrayList<Resource>();
                int n = 0;
                while (iterator.hasNext()) {
                    resource = (Resource)iterator.next();
                    DoListTest.assertTrue((String)("Should not fail node test on " + resource), (boolean)this.test(resource));
                    arrayList.add(resource);
                    if (list == null) continue;
                    if (list.contains(resource)) {
                        list.remove(resource);
                        continue;
                    }
                    if (resource.isAnon()) continue;
                    ++n;
                }
                if (this.m_count != arrayList.size()) {
                    resource = LogFactory.getLog(((Object)((Object)this)).getClass());
                    resource.debug(this.getName() + " - expected " + this.m_count + " results, actual = " + arrayList.size());
                    iterator2 = arrayList.iterator();
                    while (iterator2.hasNext()) {
                        resource.debug(this.getName() + " - saw actual: " + iterator2.next());
                    }
                }
                if (list != null && !list.isEmpty()) {
                    resource = LogFactory.getLog(((Object)((Object)this)).getClass());
                    iterator2 = list.iterator();
                    while (iterator2.hasNext()) {
                        resource.debug(this.getName() + " - expected but did not find: " + iterator2.next());
                    }
                }
                DoListTest.assertEquals((String)"Wrong number of results returned", (int)this.m_count, (int)arrayList.size());
                if (list != null) {
                    DoListTest.assertTrue((String)"Did not find all expected resources in iterator", (boolean)list.isEmpty());
                    DoListTest.assertEquals((String)"Found extraneous results, not in expected list", (int)0, (int)n);
                }
            }
        }

        public Iterator doList(OntModel ontModel) {
            return null;
        }

        public boolean test(Resource resource) {
            return true;
        }

        protected List expected(OntModel ontModel) {
            if (this.m_expected != null) {
                ArrayList<Resource> arrayList = new ArrayList<Resource>();
                for (int i = 0; i < this.m_expected.length; ++i) {
                    arrayList.add(ontModel.getResource(this.m_expected[i]));
                }
                return arrayList;
            }
            return null;
        }
    }
}

