/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.query.BindingQueryPlan;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.ontology.ComplementClass;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.EnumeratedClass;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.IntersectionClass;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.ontology.UnionClass;
import com.hp.hpl.jena.ontology.impl.OntResourceImpl;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.SingletonIterator;
import com.hp.hpl.jena.util.iterator.UniqueExtendedIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.LogFactory;

public class OntClassImpl
extends OntResourceImpl
implements OntClass {
    public static Implementation factory = new Implementation(){

        public EnhNode wrap(Node node, EnhGraph enhGraph) {
            if (this.canWrap(node, enhGraph)) {
                return new OntClassImpl(node, enhGraph);
            }
            throw new ConversionException("Cannot convert node " + node.toString() + " to OntClass: it does not have rdf:type owl:Class or equivalent");
        }

        public boolean canWrap(Node node, EnhGraph enhGraph) {
            Profile profile;
            Profile profile2 = profile = enhGraph instanceof OntModel ? ((OntModel)((Object)enhGraph)).getProfile() : null;
            return profile != null && profile.isSupported(node, enhGraph, class$com$hp$hpl$jena$ontology$OntClass == null ? (class$com$hp$hpl$jena$ontology$OntClass = OntClassImpl.class$("com.hp.hpl.jena.ontology.OntClass")) : class$com$hp$hpl$jena$ontology$OntClass);
        }
    };
    protected BindingQueryPlan m_domainQuery;
    protected BindingQueryPlan m_restrictionPropQuery = null;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$Property;

    public OntClassImpl(Node node, EnhGraph enhGraph) {
        super(node, enhGraph);
        Query query = new Query();
        query.addMatch(Query.X, this.getProfile().DOMAIN().asNode(), this.asNode());
        this.m_domainQuery = this.getModel().queryHandler().prepareBindings(query, new Node[]{Query.X});
        if (this.getProfile().ON_PROPERTY() != null) {
            query = new Query();
            query.addMatch(this.asNode(), this.getProfile().SUB_CLASS_OF().asNode(), Query.X);
            query.addMatch(Query.X, this.getProfile().ON_PROPERTY().asNode(), Query.Y);
            this.m_restrictionPropQuery = this.getModel().queryHandler().prepareBindings(query, new Node[]{Query.Y});
        }
    }

    public void setSuperClass(Resource resource) {
        this.setPropertyValue(this.getProfile().SUB_CLASS_OF(), "SUB_CLASS_OF", resource);
    }

    public void addSuperClass(Resource resource) {
        this.addPropertyValue(this.getProfile().SUB_CLASS_OF(), "SUB_CLASS_OF", resource);
    }

    public OntClass getSuperClass() {
        return (OntClass)this.objectAs(this.getProfile().SUB_CLASS_OF(), "SUB_CLASS_OF", OntClass.class);
    }

    public ExtendedIterator listSuperClasses() {
        return this.listSuperClasses(false);
    }

    public ExtendedIterator listSuperClasses(boolean bl) {
        return UniqueExtendedIterator.create(this.listDirectPropertyValues(this.getProfile().SUB_CLASS_OF(), "SUB_CLASS_OF", OntClass.class, this.getProfile().SUB_CLASS_OF(), bl, false).filterDrop(new OntResourceImpl.SingleEqualityFilter(this, this)));
    }

    public boolean hasSuperClass(Resource resource) {
        return this.hasSuperClass(resource, false);
    }

    public boolean hasSuperClass() {
        return this.getSuperClass() != null;
    }

    public boolean hasSuperClass(Resource resource, boolean bl) {
        OntModel ontModel;
        if (!bl) {
            return this.hasPropertyValue(this.getProfile().SUB_CLASS_OF(), "SUB_CLASS_OF", resource);
        }
        InfGraph infGraph = null;
        if (this.getGraph() instanceof InfGraph) {
            infGraph = (InfGraph)((Object)this.getGraph());
        } else if (this.getGraph() instanceof OntModel && (ontModel = (OntModel)((Object)this.getGraph())).getGraph() instanceof InfGraph) {
            infGraph = (InfGraph)ontModel.getGraph();
        }
        if (infGraph != null && infGraph.getReasoner().supportsProperty(ReasonerVocabulary.directSubClassOf)) {
            return this.hasPropertyValue(ReasonerVocabulary.directSubClassOf, "direct sub-class", resource);
        }
        return this.hasSuperClassDirect(resource);
    }

    public void removeSuperClass(Resource resource) {
        this.removePropertyValue(this.getProfile().SUB_CLASS_OF(), "SUB_CLASS_OF", resource);
    }

    public void setSubClass(Resource resource) {
        this.checkProfile(this.getProfile().SUB_CLASS_OF(), "SUB_CLASS_OF");
        StmtIterator stmtIterator = this.getModel().listStatements(null, this.getProfile().SUB_CLASS_OF(), this);
        while (stmtIterator.hasNext()) {
            stmtIterator.removeNext();
        }
        ((OntClass)resource.as(OntClass.class)).addSuperClass(this);
    }

    public void addSubClass(Resource resource) {
        ((OntClass)resource.as(OntClass.class)).addSuperClass(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OntClass getSubClass() {
        this.checkProfile(this.getProfile().SUB_CLASS_OF(), "SUB_CLASS_OF");
        StmtIterator stmtIterator = this.getModel().listStatements(null, this.getProfile().SUB_CLASS_OF(), this);
        try {
            if (stmtIterator.hasNext()) {
                OntClass ontClass = (OntClass)stmtIterator.nextStatement().getSubject().as(OntClass.class);
                return ontClass;
            }
            OntClass ontClass = null;
            return ontClass;
        }
        finally {
            stmtIterator.close();
        }
    }

    public ExtendedIterator listSubClasses() {
        return this.listSubClasses(false);
    }

    public ExtendedIterator listSubClasses(boolean bl) {
        return UniqueExtendedIterator.create(this.listDirectPropertyValues(this.getProfile().SUB_CLASS_OF(), "SUB_CLASS_OF", OntClass.class, this.getProfile().SUB_CLASS_OF(), bl, true).filterDrop(new OntResourceImpl.SingleEqualityFilter(this, this)));
    }

    public boolean hasSubClass(Resource resource) {
        return this.hasSubClass(resource, false);
    }

    public boolean hasSubClass() {
        return this.getSubClass() != null;
    }

    public boolean hasSubClass(Resource resource, boolean bl) {
        return ((OntClass)resource.as(OntClass.class)).hasSuperClass(this, bl);
    }

    public void removeSubClass(Resource resource) {
        ((OntClass)resource.as(OntClass.class)).removeSuperClass(this);
    }

    public void setEquivalentClass(Resource resource) {
        this.setPropertyValue(this.getProfile().EQUIVALENT_CLASS(), "EQUIVALENT_CLASS", resource);
    }

    public void addEquivalentClass(Resource resource) {
        this.addPropertyValue(this.getProfile().EQUIVALENT_CLASS(), "EQUIVALENT_CLASS", resource);
    }

    public OntClass getEquivalentClass() {
        return (OntClass)this.objectAs(this.getProfile().EQUIVALENT_CLASS(), "EQUIVALENT_CLASS", OntClass.class);
    }

    public ExtendedIterator listEquivalentClasses() {
        return UniqueExtendedIterator.create(this.listAs(this.getProfile().EQUIVALENT_CLASS(), "EQUIVALENT_CLASS", OntClass.class));
    }

    public boolean hasEquivalentClass(Resource resource) {
        return this.hasPropertyValue(this.getProfile().EQUIVALENT_CLASS(), "EQUIVALENT_CLASS", resource);
    }

    public void removeEquivalentClass(Resource resource) {
        this.removePropertyValue(this.getProfile().EQUIVALENT_CLASS(), "EQUIVALENT_CLASS", resource);
    }

    public void setDisjointWith(Resource resource) {
        this.setPropertyValue(this.getProfile().DISJOINT_WITH(), "DISJOINT_WITH", resource);
    }

    public void addDisjointWith(Resource resource) {
        this.addPropertyValue(this.getProfile().DISJOINT_WITH(), "DISJOINT_WITH", resource);
    }

    public OntClass getDisjointWith() {
        return (OntClass)this.objectAs(this.getProfile().DISJOINT_WITH(), "DISJOINT_WITH", OntClass.class);
    }

    public ExtendedIterator listDisjointWith() {
        return UniqueExtendedIterator.create(this.listAs(this.getProfile().DISJOINT_WITH(), "DISJOINT_WITH", OntClass.class));
    }

    public boolean isDisjointWith(Resource resource) {
        return this.hasPropertyValue(this.getProfile().DISJOINT_WITH(), "DISJOINT_WITH", resource);
    }

    public void removeDisjointWith(Resource resource) {
        this.removePropertyValue(this.getProfile().DISJOINT_WITH(), "DISJOINT_WITH", resource);
    }

    public ExtendedIterator listDeclaredProperties() {
        return this.listDeclaredProperties(true);
    }

    public ExtendedIterator listDeclaredProperties(boolean bl) {
        OntModel ontModel = (OntModel)this.getModel();
        Model model = bl ? ontModel : ontModel.getBaseModel();
        HashSet<RDFNode> hashSet = new HashSet<RDFNode>();
        HashSet hashSet2 = new HashSet();
        hashSet.add(this);
        ExtendedIterator extendedIterator = model.listStatements((Resource)this, this.getProfile().SUB_CLASS_OF(), (RDFNode)null);
        while (extendedIterator.hasNext()) {
            hashSet.add(extendedIterator.nextStatement().getObject());
        }
        ExtendedIterator extendedIterator2 = extendedIterator = bl ? hashSet.iterator() : new SingletonIterator(this);
        while (extendedIterator.hasNext()) {
            Object object;
            Resource resource;
            Object object2;
            Resource resource2 = (Resource)extendedIterator.next();
            if (this.getProfile().RESTRICTION() != null && (resource2.canAs(class$com$hp$hpl$jena$ontology$Restriction == null ? OntClassImpl.class$("com.hp.hpl.jena.ontology.Restriction") : class$com$hp$hpl$jena$ontology$Restriction) || resource2.hasProperty(this.getProfile().ON_PROPERTY()))) {
                object2 = (Restriction)resource2.as(class$com$hp$hpl$jena$ontology$Restriction == null ? OntClassImpl.class$("com.hp.hpl.jena.ontology.Restriction") : class$com$hp$hpl$jena$ontology$Restriction);
                resource = object2.getOnProperty();
                if (resource == null) {
                    object = object2.getURI();
                    if (object == null) {
                        object = "[anon restriction with anonID " + object2.getId().toString() + "]";
                    }
                    LogFactory.getLog(this.getClass()).warn((Object)("Found restriction " + (String)object + " with no onProperty declaration"));
                    continue;
                }
                if (hashSet2.contains(resource) || object2.hasProperty(this.getProfile().MAX_CARDINALITY(), 0L) || object2.hasProperty(this.getProfile().CARDINALITY(), 0L)) continue;
                this.collectProperty((Property)resource, hashSet2, ontModel);
                continue;
            }
            object2 = model.listStatements(null, this.getProfile().DOMAIN(), resource2);
            while (object2.hasNext()) {
                resource = object2.nextStatement().getSubject();
                if (hashSet2.contains(resource)) continue;
                object = null;
                boolean bl2 = true;
                object = model.listStatements(resource, this.getProfile().DOMAIN(), (RDFNode)null);
                while (bl2 && object.hasNext()) {
                    bl2 = hashSet.contains(object.nextStatement().getObject());
                }
                if (bl2) {
                    this.collectProperty((Property)resource.as(class$com$hp$hpl$jena$rdf$model$Property == null ? OntClassImpl.class$("com.hp.hpl.jena.rdf.model.Property") : class$com$hp$hpl$jena$rdf$model$Property), hashSet2, ontModel);
                }
                object.close();
            }
        }
        return WrappedIterator.create(hashSet2.iterator()).mapWith(new OntResourceImpl.AsMapper(this, OntProperty.class));
    }

    public ExtendedIterator listInstances() {
        return UniqueExtendedIterator.create(this.getModel().listStatements(null, RDF.type, this).mapWith(new OntResourceImpl.SubjectAsMapper(this, Individual.class)));
    }

    public Individual createIndividual() {
        return ((OntModel)this.getModel()).createIndividual(this);
    }

    public Individual createIndividual(String string) {
        return ((OntModel)this.getModel()).createIndividual(string, this);
    }

    public EnumeratedClass asEnumeratedClass() {
        return (EnumeratedClass)this.as(EnumeratedClass.class);
    }

    public UnionClass asUnionClass() {
        return (UnionClass)this.as(UnionClass.class);
    }

    public IntersectionClass asIntersectionClass() {
        return (IntersectionClass)this.as(IntersectionClass.class);
    }

    public ComplementClass asComplementClass() {
        return (ComplementClass)this.as(ComplementClass.class);
    }

    public Restriction asRestriction() {
        return (Restriction)this.as(Restriction.class);
    }

    public boolean isEnumeratedClass() {
        this.checkProfile(this.getProfile().ONE_OF(), "ONE_OF");
        return this.hasProperty(this.getProfile().ONE_OF());
    }

    public boolean isUnionClass() {
        this.checkProfile(this.getProfile().UNION_OF(), "UNION_OF");
        return this.hasProperty(this.getProfile().UNION_OF());
    }

    public boolean isIntersectionClass() {
        this.checkProfile(this.getProfile().INTERSECTION_OF(), "INTERSECTION_OF");
        return this.hasProperty(this.getProfile().INTERSECTION_OF());
    }

    public boolean isComplementClass() {
        this.checkProfile(this.getProfile().COMPLEMENT_OF(), "COMPLEMENT_OF");
        return this.hasProperty(this.getProfile().COMPLEMENT_OF());
    }

    public boolean isRestriction() {
        this.checkProfile(this.getProfile().RESTRICTION(), "RESTRICTION");
        return this.hasProperty(this.getProfile().ON_PROPERTY()) || this.hasProperty(RDF.type, this.getProfile().RESTRICTION());
    }

    public EnumeratedClass convertToEnumeratedClass(RDFList rDFList) {
        this.setPropertyValue(this.getProfile().ONE_OF(), "ONE_OF", rDFList);
        return (EnumeratedClass)this.as(EnumeratedClass.class);
    }

    public IntersectionClass convertToIntersectionClass(RDFList rDFList) {
        this.setPropertyValue(this.getProfile().INTERSECTION_OF(), "INTERSECTION_OF", rDFList);
        return (IntersectionClass)this.as(IntersectionClass.class);
    }

    public UnionClass convertToUnionClass(RDFList rDFList) {
        this.setPropertyValue(this.getProfile().UNION_OF(), "UNION_OF", rDFList);
        return (UnionClass)this.as(UnionClass.class);
    }

    public ComplementClass convertToComplementClass(Resource resource) {
        this.setPropertyValue(this.getProfile().COMPLEMENT_OF(), "COMPLEMENT_OF", resource);
        return (ComplementClass)this.as(ComplementClass.class);
    }

    public Restriction convertToRestriction(Property property) {
        if (!this.hasRDFType(this.getProfile().RESTRICTION(), "RESTRICTION", false)) {
            this.setRDFType(this.getProfile().RESTRICTION());
        }
        this.setPropertyValue(this.getProfile().ON_PROPERTY(), "ON_PROPERTY", property);
        return (Restriction)this.as(Restriction.class);
    }

    private void collectProperty(Property property, Set set, OntModel ontModel) {
        set.add(ontModel.getProperty(property.getURI()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasSuperClassDirect(Resource resource) {
        ExtendedIterator extendedIterator = this.listDirectPropertyValues(this.getProfile().SUB_CLASS_OF(), "subClassOf", OntClass.class, this.getProfile().SUB_CLASS_OF(), true, false);
        try {
            while (extendedIterator.hasNext()) {
                if (!((Object)resource).equals(extendedIterator.next())) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            extendedIterator.close();
        }
        return false;
    }
}

