/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_Blank;
import com.hp.hpl.jena.graph.Node_URI;
import com.hp.hpl.jena.ontology.AllDifferent;
import com.hp.hpl.jena.ontology.AllValuesFromRestriction;
import com.hp.hpl.jena.ontology.AnnotationProperty;
import com.hp.hpl.jena.ontology.CardinalityRestriction;
import com.hp.hpl.jena.ontology.DataRange;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.FunctionalProperty;
import com.hp.hpl.jena.ontology.HasValueRestriction;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.InverseFunctionalProperty;
import com.hp.hpl.jena.ontology.MaxCardinalityRestriction;
import com.hp.hpl.jena.ontology.MinCardinalityRestriction;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.ontology.SomeValuesFromRestriction;
import com.hp.hpl.jena.ontology.SymmetricProperty;
import com.hp.hpl.jena.ontology.TransitiveProperty;
import com.hp.hpl.jena.ontology.impl.AbstractProfile;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class OWLProfile
extends AbstractProfile {
    private static Object[][] s_supportsCheckData = new Object[][]{{AllDifferent.class, new SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.AllDifferent.asNode());
        }
    }}, {AnnotationProperty.class, new SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            Iterator iterator = ((OntModel)((Object)enhGraph)).getProfile().getAnnotationProperties();
            while (iterator.hasNext()) {
                if (!((Resource)iterator.next()).asNode().equals(node)) continue;
                return true;
            }
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.AnnotationProperty.asNode());
        }
    }}, {OntClass.class, new SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.Class.asNode()) || enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.Restriction.asNode()) || enhGraph.asGraph().contains(node, RDF.type.asNode(), RDFS.Class.asNode()) || node.equals(OWL.Thing.asNode()) || node.equals(OWL.Nothing.asNode());
        }
    }}, {DatatypeProperty.class, new SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.DatatypeProperty.asNode());
        }
    }}, {ObjectProperty.class, new SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.ObjectProperty.asNode()) || enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.TransitiveProperty.asNode()) || enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.SymmetricProperty.asNode()) || enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.InverseFunctionalProperty.asNode());
        }
    }}, {FunctionalProperty.class, new SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.FunctionalProperty.asNode());
        }
    }}, {InverseFunctionalProperty.class, new SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.InverseFunctionalProperty.asNode());
        }
    }}, {RDFList.class, new SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return node.equals(RDF.nil.asNode()) || enhGraph.asGraph().contains(node, RDF.type.asNode(), RDF.List.asNode());
        }
    }}, {OntProperty.class, new SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), RDF.Property.asNode()) || enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.ObjectProperty.asNode()) || enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.DatatypeProperty.asNode()) || enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.AnnotationProperty.asNode()) || enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.TransitiveProperty.asNode()) || enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.SymmetricProperty.asNode()) || enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.FunctionalProperty.asNode()) || enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.InverseFunctionalProperty.asNode());
        }
    }}, {Ontology.class, new SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.Ontology.asNode());
        }
    }}, {Restriction.class, new SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.Restriction.asNode());
        }
    }}, {HasValueRestriction.class, new SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.Restriction.asNode()) && OWLProfile.containsSome(enhGraph, node, OWL.hasValue) && OWLProfile.containsSome(enhGraph, node, OWL.onProperty);
        }
    }}, {AllValuesFromRestriction.class, new SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.Restriction.asNode()) && OWLProfile.containsSome(enhGraph, node, OWL.allValuesFrom) && OWLProfile.containsSome(enhGraph, node, OWL.onProperty);
        }
    }}, {SomeValuesFromRestriction.class, new SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.Restriction.asNode()) && OWLProfile.containsSome(enhGraph, node, OWL.someValuesFrom) && OWLProfile.containsSome(enhGraph, node, OWL.onProperty);
        }
    }}, {CardinalityRestriction.class, new SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.Restriction.asNode()) && OWLProfile.containsSome(enhGraph, node, OWL.cardinality) && OWLProfile.containsSome(enhGraph, node, OWL.onProperty);
        }
    }}, {MinCardinalityRestriction.class, new SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.Restriction.asNode()) && OWLProfile.containsSome(enhGraph, node, OWL.minCardinality) && OWLProfile.containsSome(enhGraph, node, OWL.onProperty);
        }
    }}, {MaxCardinalityRestriction.class, new SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.Restriction.asNode()) && OWLProfile.containsSome(enhGraph, node, OWL.maxCardinality) && OWLProfile.containsSome(enhGraph, node, OWL.onProperty);
        }
    }}, {SymmetricProperty.class, new SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.SymmetricProperty.asNode()) && !enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.DatatypeProperty.asNode());
        }
    }}, {TransitiveProperty.class, new SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.TransitiveProperty.asNode()) && !enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.DatatypeProperty.asNode());
        }
    }}, {Individual.class, new SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return node instanceof Node_URI || node instanceof Node_Blank;
        }
    }}, {DataRange.class, new SupportsCheck(){

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return node instanceof Node_Blank && enhGraph.asGraph().contains(node, RDF.type.asNode(), OWL.DataRange.asNode());
        }
    }}};
    private static HashMap s_supportsChecks = new HashMap();

    public String NAMESPACE() {
        return OWL.getURI();
    }

    public Resource CLASS() {
        return OWL.Class;
    }

    public Resource RESTRICTION() {
        return OWL.Restriction;
    }

    public Resource THING() {
        return OWL.Thing;
    }

    public Resource NOTHING() {
        return OWL.Nothing;
    }

    public Resource PROPERTY() {
        return RDF.Property;
    }

    public Resource OBJECT_PROPERTY() {
        return OWL.ObjectProperty;
    }

    public Resource DATATYPE_PROPERTY() {
        return OWL.DatatypeProperty;
    }

    public Resource TRANSITIVE_PROPERTY() {
        return OWL.TransitiveProperty;
    }

    public Resource SYMMETRIC_PROPERTY() {
        return OWL.SymmetricProperty;
    }

    public Resource FUNCTIONAL_PROPERTY() {
        return OWL.FunctionalProperty;
    }

    public Resource INVERSE_FUNCTIONAL_PROPERTY() {
        return OWL.InverseFunctionalProperty;
    }

    public Resource ALL_DIFFERENT() {
        return OWL.AllDifferent;
    }

    public Resource ONTOLOGY() {
        return OWL.Ontology;
    }

    public Resource DEPRECATED_CLASS() {
        return OWL.DeprecatedClass;
    }

    public Resource DEPRECATED_PROPERTY() {
        return OWL.DeprecatedProperty;
    }

    public Resource ANNOTATION_PROPERTY() {
        return OWL.AnnotationProperty;
    }

    public Resource ONTOLOGY_PROPERTY() {
        return OWL.OntologyProperty;
    }

    public Resource LIST() {
        return RDF.List;
    }

    public Resource NIL() {
        return RDF.nil;
    }

    public Resource DATARANGE() {
        return OWL.DataRange;
    }

    public Property EQUIVALENT_PROPERTY() {
        return OWL.equivalentProperty;
    }

    public Property EQUIVALENT_CLASS() {
        return OWL.equivalentClass;
    }

    public Property DISJOINT_WITH() {
        return OWL.disjointWith;
    }

    public Property SAME_INDIVIDUAL_AS() {
        return null;
    }

    public Property SAME_AS() {
        return OWL.sameAs;
    }

    public Property DIFFERENT_FROM() {
        return OWL.differentFrom;
    }

    public Property DISTINCT_MEMBERS() {
        return OWL.distinctMembers;
    }

    public Property UNION_OF() {
        return OWL.unionOf;
    }

    public Property INTERSECTION_OF() {
        return OWL.intersectionOf;
    }

    public Property COMPLEMENT_OF() {
        return OWL.complementOf;
    }

    public Property ONE_OF() {
        return OWL.oneOf;
    }

    public Property ON_PROPERTY() {
        return OWL.onProperty;
    }

    public Property ALL_VALUES_FROM() {
        return OWL.allValuesFrom;
    }

    public Property HAS_VALUE() {
        return OWL.hasValue;
    }

    public Property SOME_VALUES_FROM() {
        return OWL.someValuesFrom;
    }

    public Property MIN_CARDINALITY() {
        return OWL.minCardinality;
    }

    public Property MAX_CARDINALITY() {
        return OWL.maxCardinality;
    }

    public Property CARDINALITY() {
        return OWL.cardinality;
    }

    public Property INVERSE_OF() {
        return OWL.inverseOf;
    }

    public Property IMPORTS() {
        return OWL.imports;
    }

    public Property PRIOR_VERSION() {
        return OWL.priorVersion;
    }

    public Property BACKWARD_COMPATIBLE_WITH() {
        return OWL.backwardCompatibleWith;
    }

    public Property INCOMPATIBLE_WITH() {
        return OWL.incompatibleWith;
    }

    public Property SUB_PROPERTY_OF() {
        return RDFS.subPropertyOf;
    }

    public Property SUB_CLASS_OF() {
        return RDFS.subClassOf;
    }

    public Property DOMAIN() {
        return RDFS.domain;
    }

    public Property RANGE() {
        return RDFS.range;
    }

    public Property FIRST() {
        return RDF.first;
    }

    public Property REST() {
        return RDF.rest;
    }

    public Property MIN_CARDINALITY_Q() {
        return null;
    }

    public Property MAX_CARDINALITY_Q() {
        return null;
    }

    public Property CARDINALITY_Q() {
        return null;
    }

    public Property HAS_CLASS_Q() {
        return null;
    }

    public Property VERSION_INFO() {
        return OWL.versionInfo;
    }

    public Property LABEL() {
        return RDFS.label;
    }

    public Property COMMENT() {
        return RDFS.comment;
    }

    public Property SEE_ALSO() {
        return RDFS.seeAlso;
    }

    public Property IS_DEFINED_BY() {
        return RDFS.isDefinedBy;
    }

    protected Resource[][] aliasTable() {
        return new Resource[0][];
    }

    public Iterator getAxiomTypes() {
        return Arrays.asList(OWL.AllDifferent).iterator();
    }

    public Iterator getAnnotationProperties() {
        return Arrays.asList(OWL.versionInfo, RDFS.label, RDFS.seeAlso, RDFS.comment, RDFS.isDefinedBy).iterator();
    }

    public Iterator getClassDescriptionTypes() {
        return Arrays.asList(OWL.Class, OWL.Restriction).iterator();
    }

    public boolean isSupported(Node node, EnhGraph enhGraph, Class clazz) {
        if (enhGraph instanceof OntModel) {
            OntModel ontModel = (OntModel)((Object)enhGraph);
            if (!ontModel.strictMode()) {
                return true;
            }
            SupportsCheck supportsCheck = (SupportsCheck)this.getCheckTable().get(clazz);
            return supportsCheck != null && supportsCheck.doCheck(node, enhGraph);
        }
        return false;
    }

    public String getLabel() {
        return "OWL Full";
    }

    public static boolean containsSome(EnhGraph enhGraph, Node node, Property property) {
        return AbstractProfile.containsSome(enhGraph, node, property);
    }

    protected Map getCheckTable() {
        return s_supportsChecks;
    }

    static {
        for (int i = 0; i < s_supportsCheckData.length; ++i) {
            s_supportsChecks.put(s_supportsCheckData[i][0], s_supportsCheckData[i][1]);
        }
    }

    protected static class SupportsCheck {
        protected SupportsCheck() {
        }

        public boolean doCheck(Node node, EnhGraph enhGraph) {
            return true;
        }
    }
}

