/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.BooleanClassDescription;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.impl.OntClassImpl;
import com.hp.hpl.jena.ontology.impl.OntResourceImpl;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Iterator;

public abstract class BooleanClassDescriptionImpl
extends OntClassImpl
implements BooleanClassDescription {
    public BooleanClassDescriptionImpl(Node node, EnhGraph enhGraph) {
        super(node, enhGraph);
    }

    public void setOperands(RDFList rDFList) {
        this.setPropertyValue(this.operator(), this.getOperatorName(), rDFList);
    }

    public void addOperand(Resource resource) {
        this.addListPropertyValue(this.operator(), this.getOperatorName(), resource);
    }

    public void addOperands(Iterator iterator) {
        while (iterator.hasNext()) {
            this.addOperand((Resource)iterator.next());
        }
    }

    public RDFList getOperands() {
        return (RDFList)this.objectAs(this.operator(), this.getOperatorName(), RDFList.class);
    }

    public ExtendedIterator listOperands() {
        return this.getOperands().iterator().mapWith(new OntResourceImpl.AsMapper(this, OntClass.class));
    }

    public boolean hasOperand(Resource resource) {
        return this.getOperands().contains(resource);
    }

    public void removeOperand(Resource resource) {
        this.setOperands(this.getOperands().remove(resource));
    }

    public abstract Property operator();

    protected abstract String getOperatorName();
}

